# -*- coding: utf-8 -*-

"""
aviationstack

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from aviationstack.api_helper import APIHelper
from aviationstack.configuration import Server
from aviationstack.controllers.base_controller import BaseController
from apimatic_core.request_builder import RequestBuilder
from apimatic_core.response_handler import ResponseHandler
from apimatic_core.types.parameter import Parameter
from aviationstack.http.http_method_enum import HttpMethodEnum
from apimatic_core.authentication.multiple.single_auth import Single
from aviationstack.models.flight_schedule_response import FlightScheduleResponse
from aviationstack.exceptions.error_response_exception import ErrorResponseException


class FlightSchedulesController(BaseController):

    """A Controller to access Endpoints in the aviationstack API."""
    def __init__(self, config):
        super(FlightSchedulesController, self).__init__(config)

    def get_flight_schedules(self,
                             iata_code,
                             mtype,
                             limit=100,
                             offset=0):
        """Does a GET request to /v1/flights/{iata_code}/{type}.

        Retrieve flight schedule information for a specific airport

        Args:
            iata_code (str): [Required] The IATA code of the airport you'd
                like to request data from. Example: JFK,DXB.
            mtype (TypeEnum): [Required] Airport schedule type. Available
                values: departure or arrival.
            limit (int, optional): Number of results to return
            offset (int, optional): Number of results to skip

        Returns:
            FlightScheduleResponse: Response from the API. Successful response

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.DEFAULT)
            .path('/v1/flights/{iata_code}/{type}')
            .http_method(HttpMethodEnum.GET)
            .template_param(Parameter()
                            .key('iata_code')
                            .value(iata_code)
                            .should_encode(True))
            .template_param(Parameter()
                            .key('type')
                            .value(mtype)
                            .should_encode(True))
            .query_param(Parameter()
                         .key('limit')
                         .value(limit))
            .query_param(Parameter()
                         .key('offset')
                         .value(offset))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .auth(Single('ApiKeyAuth'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(FlightScheduleResponse.from_dictionary)
            .local_error('400', 'Bad request', ErrorResponseException)
            .local_error('401', 'Unauthorized', ErrorResponseException)
        ).execute()
