# -*- coding: utf-8 -*-

"""
aviationstack

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from aviationstack.api_helper import APIHelper
from aviationstack.configuration import Server
from aviationstack.controllers.base_controller import BaseController
from apimatic_core.request_builder import RequestBuilder
from apimatic_core.response_handler import ResponseHandler
from apimatic_core.types.parameter import Parameter
from aviationstack.http.http_method_enum import HttpMethodEnum
from apimatic_core.authentication.multiple.single_auth import Single
from aviationstack.models.route_response import RouteResponse
from aviationstack.exceptions.error_response_exception import ErrorResponseException


class RoutesController(BaseController):

    """A Controller to access Endpoints in the aviationstack API."""
    def __init__(self, config):
        super(RoutesController, self).__init__(config)

    def get_routes(self,
                   limit=100,
                   offset=0,
                   airline_iata=None,
                   airline_icao=None):
        """Does a GET request to /v1/routes.

        Retrieve airline route information

        Args:
            limit (int, optional): Number of results to return
            offset (int, optional): Number of results to skip
            airline_iata (str, optional): IATA code of the airline
            airline_icao (str, optional): ICAO code of the airline

        Returns:
            RouteResponse: Response from the API. Successful response

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.DEFAULT)
            .path('/v1/routes')
            .http_method(HttpMethodEnum.GET)
            .query_param(Parameter()
                         .key('limit')
                         .value(limit))
            .query_param(Parameter()
                         .key('offset')
                         .value(offset))
            .query_param(Parameter()
                         .key('airline_iata')
                         .value(airline_iata))
            .query_param(Parameter()
                         .key('airline_icao')
                         .value(airline_icao))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .auth(Single('ApiKeyAuth'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(RouteResponse.from_dictionary)
            .local_error('400', 'Bad request', ErrorResponseException)
            .local_error('401', 'Unauthorized', ErrorResponseException)
        ).execute()
