# -*- coding: utf-8 -*-

"""
aviationstack

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from aviationstack.api_helper import APIHelper


class AircraftInfo(object):

    """Implementation of the 'AircraftInfo' model.

    Attributes:
        registration (str): Aircraft registration
        iata (str): IATA code
        icao (str): ICAO code
        model (str): Aircraft model

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "registration": 'registration',
        "iata": 'iata',
        "icao": 'icao',
        "model": 'model'
    }

    _optionals = [
        'registration',
        'iata',
        'icao',
        'model',
    ]

    def __init__(self,
                 registration=APIHelper.SKIP,
                 iata=APIHelper.SKIP,
                 icao=APIHelper.SKIP,
                 model=APIHelper.SKIP):
        """Constructor for the AircraftInfo class"""

        # Initialize members of the class
        if registration is not APIHelper.SKIP:
            self.registration = registration 
        if iata is not APIHelper.SKIP:
            self.iata = iata 
        if icao is not APIHelper.SKIP:
            self.icao = icao 
        if model is not APIHelper.SKIP:
            self.model = model 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        registration = dictionary.get("registration") if dictionary.get("registration") else APIHelper.SKIP
        iata = dictionary.get("iata") if dictionary.get("iata") else APIHelper.SKIP
        icao = dictionary.get("icao") if dictionary.get("icao") else APIHelper.SKIP
        model = dictionary.get("model") if dictionary.get("model") else APIHelper.SKIP
        # Return an object of this model
        return cls(registration,
                   iata,
                   icao,
                   model)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'registration={(self.registration if hasattr(self, "registration") else None)!r}, '
                f'iata={(self.iata if hasattr(self, "iata") else None)!r}, '
                f'icao={(self.icao if hasattr(self, "icao") else None)!r}, '
                f'model={(self.model if hasattr(self, "model") else None)!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'registration={(self.registration if hasattr(self, "registration") else None)!s}, '
                f'iata={(self.iata if hasattr(self, "iata") else None)!s}, '
                f'icao={(self.icao if hasattr(self, "icao") else None)!s}, '
                f'model={(self.model if hasattr(self, "model") else None)!s})')
