# -*- coding: utf-8 -*-

"""
aviationstack

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from aviationstack.api_helper import APIHelper


class AircraftType(object):

    """Implementation of the 'AircraftType' model.

    Attributes:
        iata_code (str): IATA code of the aircraft type
        aircraft_name (str): Name of the aircraft type

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "iata_code": 'iata_code',
        "aircraft_name": 'aircraft_name'
    }

    _optionals = [
        'iata_code',
        'aircraft_name',
    ]

    def __init__(self,
                 iata_code=APIHelper.SKIP,
                 aircraft_name=APIHelper.SKIP):
        """Constructor for the AircraftType class"""

        # Initialize members of the class
        if iata_code is not APIHelper.SKIP:
            self.iata_code = iata_code 
        if aircraft_name is not APIHelper.SKIP:
            self.aircraft_name = aircraft_name 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        iata_code = dictionary.get("iata_code") if dictionary.get("iata_code") else APIHelper.SKIP
        aircraft_name = dictionary.get("aircraft_name") if dictionary.get("aircraft_name") else APIHelper.SKIP
        # Return an object of this model
        return cls(iata_code,
                   aircraft_name)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'iata_code={(self.iata_code if hasattr(self, "iata_code") else None)!r}, '
                f'aircraft_name={(self.aircraft_name if hasattr(self, "aircraft_name") else None)!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'iata_code={(self.iata_code if hasattr(self, "iata_code") else None)!s}, '
                f'aircraft_name={(self.aircraft_name if hasattr(self, "aircraft_name") else None)!s})')
