# -*- coding: utf-8 -*-

"""
aviationstack

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from aviationstack.api_helper import APIHelper


class Airline(object):

    """Implementation of the 'Airline' model.

    Attributes:
        airline_name (str): Name of the airline
        iata_code (str): IATA code of the airline
        icao_code (str): ICAO code of the airline
        fleet_size (str): Size of the fleet
        fleet_average_age (str): Average age of the fleet
        date_founded (str): Date when the airline was founded
        hub_code (str): Hub airport code
        country_name (str): Country name
        country_code (str): Country code

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "airline_name": 'airline_name',
        "iata_code": 'iata_code',
        "icao_code": 'icao_code',
        "fleet_size": 'fleet_size',
        "fleet_average_age": 'fleet_average_age',
        "date_founded": 'date_founded',
        "hub_code": 'hub_code',
        "country_name": 'country_name',
        "country_code": 'country_code'
    }

    _optionals = [
        'airline_name',
        'iata_code',
        'icao_code',
        'fleet_size',
        'fleet_average_age',
        'date_founded',
        'hub_code',
        'country_name',
        'country_code',
    ]

    def __init__(self,
                 airline_name=APIHelper.SKIP,
                 iata_code=APIHelper.SKIP,
                 icao_code=APIHelper.SKIP,
                 fleet_size=APIHelper.SKIP,
                 fleet_average_age=APIHelper.SKIP,
                 date_founded=APIHelper.SKIP,
                 hub_code=APIHelper.SKIP,
                 country_name=APIHelper.SKIP,
                 country_code=APIHelper.SKIP):
        """Constructor for the Airline class"""

        # Initialize members of the class
        if airline_name is not APIHelper.SKIP:
            self.airline_name = airline_name 
        if iata_code is not APIHelper.SKIP:
            self.iata_code = iata_code 
        if icao_code is not APIHelper.SKIP:
            self.icao_code = icao_code 
        if fleet_size is not APIHelper.SKIP:
            self.fleet_size = fleet_size 
        if fleet_average_age is not APIHelper.SKIP:
            self.fleet_average_age = fleet_average_age 
        if date_founded is not APIHelper.SKIP:
            self.date_founded = date_founded 
        if hub_code is not APIHelper.SKIP:
            self.hub_code = hub_code 
        if country_name is not APIHelper.SKIP:
            self.country_name = country_name 
        if country_code is not APIHelper.SKIP:
            self.country_code = country_code 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        airline_name = dictionary.get("airline_name") if dictionary.get("airline_name") else APIHelper.SKIP
        iata_code = dictionary.get("iata_code") if dictionary.get("iata_code") else APIHelper.SKIP
        icao_code = dictionary.get("icao_code") if dictionary.get("icao_code") else APIHelper.SKIP
        fleet_size = dictionary.get("fleet_size") if dictionary.get("fleet_size") else APIHelper.SKIP
        fleet_average_age = dictionary.get("fleet_average_age") if dictionary.get("fleet_average_age") else APIHelper.SKIP
        date_founded = dictionary.get("date_founded") if dictionary.get("date_founded") else APIHelper.SKIP
        hub_code = dictionary.get("hub_code") if dictionary.get("hub_code") else APIHelper.SKIP
        country_name = dictionary.get("country_name") if dictionary.get("country_name") else APIHelper.SKIP
        country_code = dictionary.get("country_code") if dictionary.get("country_code") else APIHelper.SKIP
        # Return an object of this model
        return cls(airline_name,
                   iata_code,
                   icao_code,
                   fleet_size,
                   fleet_average_age,
                   date_founded,
                   hub_code,
                   country_name,
                   country_code)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'airline_name={(self.airline_name if hasattr(self, "airline_name") else None)!r}, '
                f'iata_code={(self.iata_code if hasattr(self, "iata_code") else None)!r}, '
                f'icao_code={(self.icao_code if hasattr(self, "icao_code") else None)!r}, '
                f'fleet_size={(self.fleet_size if hasattr(self, "fleet_size") else None)!r}, '
                f'fleet_average_age={(self.fleet_average_age if hasattr(self, "fleet_average_age") else None)!r}, '
                f'date_founded={(self.date_founded if hasattr(self, "date_founded") else None)!r}, '
                f'hub_code={(self.hub_code if hasattr(self, "hub_code") else None)!r}, '
                f'country_name={(self.country_name if hasattr(self, "country_name") else None)!r}, '
                f'country_code={(self.country_code if hasattr(self, "country_code") else None)!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'airline_name={(self.airline_name if hasattr(self, "airline_name") else None)!s}, '
                f'iata_code={(self.iata_code if hasattr(self, "iata_code") else None)!s}, '
                f'icao_code={(self.icao_code if hasattr(self, "icao_code") else None)!s}, '
                f'fleet_size={(self.fleet_size if hasattr(self, "fleet_size") else None)!s}, '
                f'fleet_average_age={(self.fleet_average_age if hasattr(self, "fleet_average_age") else None)!s}, '
                f'date_founded={(self.date_founded if hasattr(self, "date_founded") else None)!s}, '
                f'hub_code={(self.hub_code if hasattr(self, "hub_code") else None)!s}, '
                f'country_name={(self.country_name if hasattr(self, "country_name") else None)!s}, '
                f'country_code={(self.country_code if hasattr(self, "country_code") else None)!s})')
