# -*- coding: utf-8 -*-

"""
aviationstack

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from aviationstack.api_helper import APIHelper


class AirlineInfo(object):

    """Implementation of the 'AirlineInfo' model.

    Attributes:
        name (str): Airline name
        iata (str): IATA code
        icao (str): ICAO code

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "name": 'name',
        "iata": 'iata',
        "icao": 'icao'
    }

    _optionals = [
        'name',
        'iata',
        'icao',
    ]

    def __init__(self,
                 name=APIHelper.SKIP,
                 iata=APIHelper.SKIP,
                 icao=APIHelper.SKIP):
        """Constructor for the AirlineInfo class"""

        # Initialize members of the class
        if name is not APIHelper.SKIP:
            self.name = name 
        if iata is not APIHelper.SKIP:
            self.iata = iata 
        if icao is not APIHelper.SKIP:
            self.icao = icao 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        name = dictionary.get("name") if dictionary.get("name") else APIHelper.SKIP
        iata = dictionary.get("iata") if dictionary.get("iata") else APIHelper.SKIP
        icao = dictionary.get("icao") if dictionary.get("icao") else APIHelper.SKIP
        # Return an object of this model
        return cls(name,
                   iata,
                   icao)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'name={(self.name if hasattr(self, "name") else None)!r}, '
                f'iata={(self.iata if hasattr(self, "iata") else None)!r}, '
                f'icao={(self.icao if hasattr(self, "icao") else None)!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'name={(self.name if hasattr(self, "name") else None)!s}, '
                f'iata={(self.iata if hasattr(self, "iata") else None)!s}, '
                f'icao={(self.icao if hasattr(self, "icao") else None)!s})')
