# -*- coding: utf-8 -*-

"""
aviationstack

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from aviationstack.api_helper import APIHelper


class Airplane(object):

    """Implementation of the 'Airplane' model.

    Attributes:
        registration_number (str): Aircraft registration number
        production_line (str): Production line
        iata_type_code (str): IATA type code
        model_name (str): Model name
        model_code (str): Model code
        owner_airline_name (str): Owner airline name
        owner_airline_code (str): Owner airline code
        owner_airline_country_code (str): Owner airline country code
        owner_airline_country_name (str): Owner airline country name
        serial_number (str): Serial number
        engine_model (str): Engine model
        engine_count (str): Number of engines
        built (str): Build date

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "registration_number": 'registration_number',
        "production_line": 'production_line',
        "iata_type_code": 'iata_type_code',
        "model_name": 'model_name',
        "model_code": 'model_code',
        "owner_airline_name": 'owner_airline_name',
        "owner_airline_code": 'owner_airline_code',
        "owner_airline_country_code": 'owner_airline_country_code',
        "owner_airline_country_name": 'owner_airline_country_name',
        "serial_number": 'serial_number',
        "engine_model": 'engine_model',
        "engine_count": 'engine_count',
        "built": 'built'
    }

    _optionals = [
        'registration_number',
        'production_line',
        'iata_type_code',
        'model_name',
        'model_code',
        'owner_airline_name',
        'owner_airline_code',
        'owner_airline_country_code',
        'owner_airline_country_name',
        'serial_number',
        'engine_model',
        'engine_count',
        'built',
    ]

    def __init__(self,
                 registration_number=APIHelper.SKIP,
                 production_line=APIHelper.SKIP,
                 iata_type_code=APIHelper.SKIP,
                 model_name=APIHelper.SKIP,
                 model_code=APIHelper.SKIP,
                 owner_airline_name=APIHelper.SKIP,
                 owner_airline_code=APIHelper.SKIP,
                 owner_airline_country_code=APIHelper.SKIP,
                 owner_airline_country_name=APIHelper.SKIP,
                 serial_number=APIHelper.SKIP,
                 engine_model=APIHelper.SKIP,
                 engine_count=APIHelper.SKIP,
                 built=APIHelper.SKIP):
        """Constructor for the Airplane class"""

        # Initialize members of the class
        if registration_number is not APIHelper.SKIP:
            self.registration_number = registration_number 
        if production_line is not APIHelper.SKIP:
            self.production_line = production_line 
        if iata_type_code is not APIHelper.SKIP:
            self.iata_type_code = iata_type_code 
        if model_name is not APIHelper.SKIP:
            self.model_name = model_name 
        if model_code is not APIHelper.SKIP:
            self.model_code = model_code 
        if owner_airline_name is not APIHelper.SKIP:
            self.owner_airline_name = owner_airline_name 
        if owner_airline_code is not APIHelper.SKIP:
            self.owner_airline_code = owner_airline_code 
        if owner_airline_country_code is not APIHelper.SKIP:
            self.owner_airline_country_code = owner_airline_country_code 
        if owner_airline_country_name is not APIHelper.SKIP:
            self.owner_airline_country_name = owner_airline_country_name 
        if serial_number is not APIHelper.SKIP:
            self.serial_number = serial_number 
        if engine_model is not APIHelper.SKIP:
            self.engine_model = engine_model 
        if engine_count is not APIHelper.SKIP:
            self.engine_count = engine_count 
        if built is not APIHelper.SKIP:
            self.built = built 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        registration_number = dictionary.get("registration_number") if dictionary.get("registration_number") else APIHelper.SKIP
        production_line = dictionary.get("production_line") if dictionary.get("production_line") else APIHelper.SKIP
        iata_type_code = dictionary.get("iata_type_code") if dictionary.get("iata_type_code") else APIHelper.SKIP
        model_name = dictionary.get("model_name") if dictionary.get("model_name") else APIHelper.SKIP
        model_code = dictionary.get("model_code") if dictionary.get("model_code") else APIHelper.SKIP
        owner_airline_name = dictionary.get("owner_airline_name") if dictionary.get("owner_airline_name") else APIHelper.SKIP
        owner_airline_code = dictionary.get("owner_airline_code") if dictionary.get("owner_airline_code") else APIHelper.SKIP
        owner_airline_country_code = dictionary.get("owner_airline_country_code") if dictionary.get("owner_airline_country_code") else APIHelper.SKIP
        owner_airline_country_name = dictionary.get("owner_airline_country_name") if dictionary.get("owner_airline_country_name") else APIHelper.SKIP
        serial_number = dictionary.get("serial_number") if dictionary.get("serial_number") else APIHelper.SKIP
        engine_model = dictionary.get("engine_model") if dictionary.get("engine_model") else APIHelper.SKIP
        engine_count = dictionary.get("engine_count") if dictionary.get("engine_count") else APIHelper.SKIP
        built = dictionary.get("built") if dictionary.get("built") else APIHelper.SKIP
        # Return an object of this model
        return cls(registration_number,
                   production_line,
                   iata_type_code,
                   model_name,
                   model_code,
                   owner_airline_name,
                   owner_airline_code,
                   owner_airline_country_code,
                   owner_airline_country_name,
                   serial_number,
                   engine_model,
                   engine_count,
                   built)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'registration_number={(self.registration_number if hasattr(self, "registration_number") else None)!r}, '
                f'production_line={(self.production_line if hasattr(self, "production_line") else None)!r}, '
                f'iata_type_code={(self.iata_type_code if hasattr(self, "iata_type_code") else None)!r}, '
                f'model_name={(self.model_name if hasattr(self, "model_name") else None)!r}, '
                f'model_code={(self.model_code if hasattr(self, "model_code") else None)!r}, '
                f'owner_airline_name={(self.owner_airline_name if hasattr(self, "owner_airline_name") else None)!r}, '
                f'owner_airline_code={(self.owner_airline_code if hasattr(self, "owner_airline_code") else None)!r}, '
                f'owner_airline_country_code={(self.owner_airline_country_code if hasattr(self, "owner_airline_country_code") else None)!r}, '
                f'owner_airline_country_name={(self.owner_airline_country_name if hasattr(self, "owner_airline_country_name") else None)!r}, '
                f'serial_number={(self.serial_number if hasattr(self, "serial_number") else None)!r}, '
                f'engine_model={(self.engine_model if hasattr(self, "engine_model") else None)!r}, '
                f'engine_count={(self.engine_count if hasattr(self, "engine_count") else None)!r}, '
                f'built={(self.built if hasattr(self, "built") else None)!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'registration_number={(self.registration_number if hasattr(self, "registration_number") else None)!s}, '
                f'production_line={(self.production_line if hasattr(self, "production_line") else None)!s}, '
                f'iata_type_code={(self.iata_type_code if hasattr(self, "iata_type_code") else None)!s}, '
                f'model_name={(self.model_name if hasattr(self, "model_name") else None)!s}, '
                f'model_code={(self.model_code if hasattr(self, "model_code") else None)!s}, '
                f'owner_airline_name={(self.owner_airline_name if hasattr(self, "owner_airline_name") else None)!s}, '
                f'owner_airline_code={(self.owner_airline_code if hasattr(self, "owner_airline_code") else None)!s}, '
                f'owner_airline_country_code={(self.owner_airline_country_code if hasattr(self, "owner_airline_country_code") else None)!s}, '
                f'owner_airline_country_name={(self.owner_airline_country_name if hasattr(self, "owner_airline_country_name") else None)!s}, '
                f'serial_number={(self.serial_number if hasattr(self, "serial_number") else None)!s}, '
                f'engine_model={(self.engine_model if hasattr(self, "engine_model") else None)!s}, '
                f'engine_count={(self.engine_count if hasattr(self, "engine_count") else None)!s}, '
                f'built={(self.built if hasattr(self, "built") else None)!s})')
