# -*- coding: utf-8 -*-

"""
aviationstack

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from aviationstack.api_helper import APIHelper


class Airport(object):

    """Implementation of the 'Airport' model.

    Attributes:
        airport_name (str): Name of the airport
        iata_code (str): IATA code of the airport
        icao_code (str): ICAO code of the airport
        latitude (float): Latitude coordinate
        longitude (float): Longitude coordinate
        geoname_id (str): Geonames ID
        timezone (str): Timezone
        gmt (str): GMT offset
        phone_number (str): Phone number
        country_name (str): Country name
        country_code (str): Country code
        website (str): Website URL
        wikipedia (str): Wikipedia URL

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "airport_name": 'airport_name',
        "iata_code": 'iata_code',
        "icao_code": 'icao_code',
        "latitude": 'latitude',
        "longitude": 'longitude',
        "geoname_id": 'geoname_id',
        "timezone": 'timezone',
        "gmt": 'gmt',
        "phone_number": 'phone_number',
        "country_name": 'country_name',
        "country_code": 'country_code',
        "website": 'website',
        "wikipedia": 'wikipedia'
    }

    _optionals = [
        'airport_name',
        'iata_code',
        'icao_code',
        'latitude',
        'longitude',
        'geoname_id',
        'timezone',
        'gmt',
        'phone_number',
        'country_name',
        'country_code',
        'website',
        'wikipedia',
    ]

    def __init__(self,
                 airport_name=APIHelper.SKIP,
                 iata_code=APIHelper.SKIP,
                 icao_code=APIHelper.SKIP,
                 latitude=APIHelper.SKIP,
                 longitude=APIHelper.SKIP,
                 geoname_id=APIHelper.SKIP,
                 timezone=APIHelper.SKIP,
                 gmt=APIHelper.SKIP,
                 phone_number=APIHelper.SKIP,
                 country_name=APIHelper.SKIP,
                 country_code=APIHelper.SKIP,
                 website=APIHelper.SKIP,
                 wikipedia=APIHelper.SKIP):
        """Constructor for the Airport class"""

        # Initialize members of the class
        if airport_name is not APIHelper.SKIP:
            self.airport_name = airport_name 
        if iata_code is not APIHelper.SKIP:
            self.iata_code = iata_code 
        if icao_code is not APIHelper.SKIP:
            self.icao_code = icao_code 
        if latitude is not APIHelper.SKIP:
            self.latitude = latitude 
        if longitude is not APIHelper.SKIP:
            self.longitude = longitude 
        if geoname_id is not APIHelper.SKIP:
            self.geoname_id = geoname_id 
        if timezone is not APIHelper.SKIP:
            self.timezone = timezone 
        if gmt is not APIHelper.SKIP:
            self.gmt = gmt 
        if phone_number is not APIHelper.SKIP:
            self.phone_number = phone_number 
        if country_name is not APIHelper.SKIP:
            self.country_name = country_name 
        if country_code is not APIHelper.SKIP:
            self.country_code = country_code 
        if website is not APIHelper.SKIP:
            self.website = website 
        if wikipedia is not APIHelper.SKIP:
            self.wikipedia = wikipedia 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        airport_name = dictionary.get("airport_name") if dictionary.get("airport_name") else APIHelper.SKIP
        iata_code = dictionary.get("iata_code") if dictionary.get("iata_code") else APIHelper.SKIP
        icao_code = dictionary.get("icao_code") if dictionary.get("icao_code") else APIHelper.SKIP
        latitude = dictionary.get("latitude") if dictionary.get("latitude") else APIHelper.SKIP
        longitude = dictionary.get("longitude") if dictionary.get("longitude") else APIHelper.SKIP
        geoname_id = dictionary.get("geoname_id") if dictionary.get("geoname_id") else APIHelper.SKIP
        timezone = dictionary.get("timezone") if dictionary.get("timezone") else APIHelper.SKIP
        gmt = dictionary.get("gmt") if dictionary.get("gmt") else APIHelper.SKIP
        phone_number = dictionary.get("phone_number") if dictionary.get("phone_number") else APIHelper.SKIP
        country_name = dictionary.get("country_name") if dictionary.get("country_name") else APIHelper.SKIP
        country_code = dictionary.get("country_code") if dictionary.get("country_code") else APIHelper.SKIP
        website = dictionary.get("website") if dictionary.get("website") else APIHelper.SKIP
        wikipedia = dictionary.get("wikipedia") if dictionary.get("wikipedia") else APIHelper.SKIP
        # Return an object of this model
        return cls(airport_name,
                   iata_code,
                   icao_code,
                   latitude,
                   longitude,
                   geoname_id,
                   timezone,
                   gmt,
                   phone_number,
                   country_name,
                   country_code,
                   website,
                   wikipedia)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'airport_name={(self.airport_name if hasattr(self, "airport_name") else None)!r}, '
                f'iata_code={(self.iata_code if hasattr(self, "iata_code") else None)!r}, '
                f'icao_code={(self.icao_code if hasattr(self, "icao_code") else None)!r}, '
                f'latitude={(self.latitude if hasattr(self, "latitude") else None)!r}, '
                f'longitude={(self.longitude if hasattr(self, "longitude") else None)!r}, '
                f'geoname_id={(self.geoname_id if hasattr(self, "geoname_id") else None)!r}, '
                f'timezone={(self.timezone if hasattr(self, "timezone") else None)!r}, '
                f'gmt={(self.gmt if hasattr(self, "gmt") else None)!r}, '
                f'phone_number={(self.phone_number if hasattr(self, "phone_number") else None)!r}, '
                f'country_name={(self.country_name if hasattr(self, "country_name") else None)!r}, '
                f'country_code={(self.country_code if hasattr(self, "country_code") else None)!r}, '
                f'website={(self.website if hasattr(self, "website") else None)!r}, '
                f'wikipedia={(self.wikipedia if hasattr(self, "wikipedia") else None)!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'airport_name={(self.airport_name if hasattr(self, "airport_name") else None)!s}, '
                f'iata_code={(self.iata_code if hasattr(self, "iata_code") else None)!s}, '
                f'icao_code={(self.icao_code if hasattr(self, "icao_code") else None)!s}, '
                f'latitude={(self.latitude if hasattr(self, "latitude") else None)!s}, '
                f'longitude={(self.longitude if hasattr(self, "longitude") else None)!s}, '
                f'geoname_id={(self.geoname_id if hasattr(self, "geoname_id") else None)!s}, '
                f'timezone={(self.timezone if hasattr(self, "timezone") else None)!s}, '
                f'gmt={(self.gmt if hasattr(self, "gmt") else None)!s}, '
                f'phone_number={(self.phone_number if hasattr(self, "phone_number") else None)!s}, '
                f'country_name={(self.country_name if hasattr(self, "country_name") else None)!s}, '
                f'country_code={(self.country_code if hasattr(self, "country_code") else None)!s}, '
                f'website={(self.website if hasattr(self, "website") else None)!s}, '
                f'wikipedia={(self.wikipedia if hasattr(self, "wikipedia") else None)!s})')
