# -*- coding: utf-8 -*-

"""
aviationstack

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from aviationstack.api_helper import APIHelper


class AirportInfo(object):

    """Implementation of the 'AirportInfo' model.

    Attributes:
        airport (str): Airport name
        timezone (str): Timezone
        iata (str): IATA code
        icao (str): ICAO code
        terminal (str): Terminal
        gate (str): Gate
        delay (int): Delay in minutes
        scheduled (datetime): Scheduled time
        estimated (datetime): Estimated time
        actual (datetime): Actual time
        estimated_runway (datetime): Estimated runway time
        actual_runway (datetime): Actual runway time

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "airport": 'airport',
        "timezone": 'timezone',
        "iata": 'iata',
        "icao": 'icao',
        "terminal": 'terminal',
        "gate": 'gate',
        "delay": 'delay',
        "scheduled": 'scheduled',
        "estimated": 'estimated',
        "actual": 'actual',
        "estimated_runway": 'estimated_runway',
        "actual_runway": 'actual_runway'
    }

    _optionals = [
        'airport',
        'timezone',
        'iata',
        'icao',
        'terminal',
        'gate',
        'delay',
        'scheduled',
        'estimated',
        'actual',
        'estimated_runway',
        'actual_runway',
    ]

    def __init__(self,
                 airport=APIHelper.SKIP,
                 timezone=APIHelper.SKIP,
                 iata=APIHelper.SKIP,
                 icao=APIHelper.SKIP,
                 terminal=APIHelper.SKIP,
                 gate=APIHelper.SKIP,
                 delay=APIHelper.SKIP,
                 scheduled=APIHelper.SKIP,
                 estimated=APIHelper.SKIP,
                 actual=APIHelper.SKIP,
                 estimated_runway=APIHelper.SKIP,
                 actual_runway=APIHelper.SKIP):
        """Constructor for the AirportInfo class"""

        # Initialize members of the class
        if airport is not APIHelper.SKIP:
            self.airport = airport 
        if timezone is not APIHelper.SKIP:
            self.timezone = timezone 
        if iata is not APIHelper.SKIP:
            self.iata = iata 
        if icao is not APIHelper.SKIP:
            self.icao = icao 
        if terminal is not APIHelper.SKIP:
            self.terminal = terminal 
        if gate is not APIHelper.SKIP:
            self.gate = gate 
        if delay is not APIHelper.SKIP:
            self.delay = delay 
        if scheduled is not APIHelper.SKIP:
            self.scheduled = APIHelper.apply_datetime_converter(scheduled, APIHelper.RFC3339DateTime) if scheduled else None 
        if estimated is not APIHelper.SKIP:
            self.estimated = APIHelper.apply_datetime_converter(estimated, APIHelper.RFC3339DateTime) if estimated else None 
        if actual is not APIHelper.SKIP:
            self.actual = APIHelper.apply_datetime_converter(actual, APIHelper.RFC3339DateTime) if actual else None 
        if estimated_runway is not APIHelper.SKIP:
            self.estimated_runway = APIHelper.apply_datetime_converter(estimated_runway, APIHelper.RFC3339DateTime) if estimated_runway else None 
        if actual_runway is not APIHelper.SKIP:
            self.actual_runway = APIHelper.apply_datetime_converter(actual_runway, APIHelper.RFC3339DateTime) if actual_runway else None 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        airport = dictionary.get("airport") if dictionary.get("airport") else APIHelper.SKIP
        timezone = dictionary.get("timezone") if dictionary.get("timezone") else APIHelper.SKIP
        iata = dictionary.get("iata") if dictionary.get("iata") else APIHelper.SKIP
        icao = dictionary.get("icao") if dictionary.get("icao") else APIHelper.SKIP
        terminal = dictionary.get("terminal") if dictionary.get("terminal") else APIHelper.SKIP
        gate = dictionary.get("gate") if dictionary.get("gate") else APIHelper.SKIP
        delay = dictionary.get("delay") if dictionary.get("delay") else APIHelper.SKIP
        scheduled = APIHelper.RFC3339DateTime.from_value(dictionary.get("scheduled")).datetime if dictionary.get("scheduled") else APIHelper.SKIP
        estimated = APIHelper.RFC3339DateTime.from_value(dictionary.get("estimated")).datetime if dictionary.get("estimated") else APIHelper.SKIP
        actual = APIHelper.RFC3339DateTime.from_value(dictionary.get("actual")).datetime if dictionary.get("actual") else APIHelper.SKIP
        estimated_runway = APIHelper.RFC3339DateTime.from_value(dictionary.get("estimated_runway")).datetime if dictionary.get("estimated_runway") else APIHelper.SKIP
        actual_runway = APIHelper.RFC3339DateTime.from_value(dictionary.get("actual_runway")).datetime if dictionary.get("actual_runway") else APIHelper.SKIP
        # Return an object of this model
        return cls(airport,
                   timezone,
                   iata,
                   icao,
                   terminal,
                   gate,
                   delay,
                   scheduled,
                   estimated,
                   actual,
                   estimated_runway,
                   actual_runway)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'airport={(self.airport if hasattr(self, "airport") else None)!r}, '
                f'timezone={(self.timezone if hasattr(self, "timezone") else None)!r}, '
                f'iata={(self.iata if hasattr(self, "iata") else None)!r}, '
                f'icao={(self.icao if hasattr(self, "icao") else None)!r}, '
                f'terminal={(self.terminal if hasattr(self, "terminal") else None)!r}, '
                f'gate={(self.gate if hasattr(self, "gate") else None)!r}, '
                f'delay={(self.delay if hasattr(self, "delay") else None)!r}, '
                f'scheduled={(self.scheduled if hasattr(self, "scheduled") else None)!r}, '
                f'estimated={(self.estimated if hasattr(self, "estimated") else None)!r}, '
                f'actual={(self.actual if hasattr(self, "actual") else None)!r}, '
                f'estimated_runway={(self.estimated_runway if hasattr(self, "estimated_runway") else None)!r}, '
                f'actual_runway={(self.actual_runway if hasattr(self, "actual_runway") else None)!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'airport={(self.airport if hasattr(self, "airport") else None)!s}, '
                f'timezone={(self.timezone if hasattr(self, "timezone") else None)!s}, '
                f'iata={(self.iata if hasattr(self, "iata") else None)!s}, '
                f'icao={(self.icao if hasattr(self, "icao") else None)!s}, '
                f'terminal={(self.terminal if hasattr(self, "terminal") else None)!s}, '
                f'gate={(self.gate if hasattr(self, "gate") else None)!s}, '
                f'delay={(self.delay if hasattr(self, "delay") else None)!s}, '
                f'scheduled={(self.scheduled if hasattr(self, "scheduled") else None)!s}, '
                f'estimated={(self.estimated if hasattr(self, "estimated") else None)!s}, '
                f'actual={(self.actual if hasattr(self, "actual") else None)!s}, '
                f'estimated_runway={(self.estimated_runway if hasattr(self, "estimated_runway") else None)!s}, '
                f'actual_runway={(self.actual_runway if hasattr(self, "actual_runway") else None)!s})')
