# -*- coding: utf-8 -*-

"""
aviationstack

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from aviationstack.api_helper import APIHelper


class City(object):

    """Implementation of the 'City' model.

    Attributes:
        city_name (str): Name of the city
        city_code (str): Code of the city
        country_code (str): Country code
        country_name (str): Country name

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "city_name": 'city_name',
        "city_code": 'city_code',
        "country_code": 'country_code',
        "country_name": 'country_name'
    }

    _optionals = [
        'city_name',
        'city_code',
        'country_code',
        'country_name',
    ]

    def __init__(self,
                 city_name=APIHelper.SKIP,
                 city_code=APIHelper.SKIP,
                 country_code=APIHelper.SKIP,
                 country_name=APIHelper.SKIP):
        """Constructor for the City class"""

        # Initialize members of the class
        if city_name is not APIHelper.SKIP:
            self.city_name = city_name 
        if city_code is not APIHelper.SKIP:
            self.city_code = city_code 
        if country_code is not APIHelper.SKIP:
            self.country_code = country_code 
        if country_name is not APIHelper.SKIP:
            self.country_name = country_name 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        city_name = dictionary.get("city_name") if dictionary.get("city_name") else APIHelper.SKIP
        city_code = dictionary.get("city_code") if dictionary.get("city_code") else APIHelper.SKIP
        country_code = dictionary.get("country_code") if dictionary.get("country_code") else APIHelper.SKIP
        country_name = dictionary.get("country_name") if dictionary.get("country_name") else APIHelper.SKIP
        # Return an object of this model
        return cls(city_name,
                   city_code,
                   country_code,
                   country_name)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'city_name={(self.city_name if hasattr(self, "city_name") else None)!r}, '
                f'city_code={(self.city_code if hasattr(self, "city_code") else None)!r}, '
                f'country_code={(self.country_code if hasattr(self, "country_code") else None)!r}, '
                f'country_name={(self.country_name if hasattr(self, "country_name") else None)!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'city_name={(self.city_name if hasattr(self, "city_name") else None)!s}, '
                f'city_code={(self.city_code if hasattr(self, "city_code") else None)!s}, '
                f'country_code={(self.country_code if hasattr(self, "country_code") else None)!s}, '
                f'country_name={(self.country_name if hasattr(self, "country_name") else None)!s})')
