# -*- coding: utf-8 -*-

"""
aviationstack

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from aviationstack.api_helper import APIHelper


class Country(object):

    """Implementation of the 'Country' model.

    Attributes:
        country_name (str): Name of the country
        country_code (str): Code of the country
        country_iso_2 (str): ISO 2-letter country code
        country_iso_3 (str): ISO 3-letter country code

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "country_name": 'country_name',
        "country_code": 'country_code',
        "country_iso_2": 'country_iso2',
        "country_iso_3": 'country_iso3'
    }

    _optionals = [
        'country_name',
        'country_code',
        'country_iso_2',
        'country_iso_3',
    ]

    def __init__(self,
                 country_name=APIHelper.SKIP,
                 country_code=APIHelper.SKIP,
                 country_iso_2=APIHelper.SKIP,
                 country_iso_3=APIHelper.SKIP):
        """Constructor for the Country class"""

        # Initialize members of the class
        if country_name is not APIHelper.SKIP:
            self.country_name = country_name 
        if country_code is not APIHelper.SKIP:
            self.country_code = country_code 
        if country_iso_2 is not APIHelper.SKIP:
            self.country_iso_2 = country_iso_2 
        if country_iso_3 is not APIHelper.SKIP:
            self.country_iso_3 = country_iso_3 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        country_name = dictionary.get("country_name") if dictionary.get("country_name") else APIHelper.SKIP
        country_code = dictionary.get("country_code") if dictionary.get("country_code") else APIHelper.SKIP
        country_iso_2 = dictionary.get("country_iso2") if dictionary.get("country_iso2") else APIHelper.SKIP
        country_iso_3 = dictionary.get("country_iso3") if dictionary.get("country_iso3") else APIHelper.SKIP
        # Return an object of this model
        return cls(country_name,
                   country_code,
                   country_iso_2,
                   country_iso_3)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'country_name={(self.country_name if hasattr(self, "country_name") else None)!r}, '
                f'country_code={(self.country_code if hasattr(self, "country_code") else None)!r}, '
                f'country_iso_2={(self.country_iso_2 if hasattr(self, "country_iso_2") else None)!r}, '
                f'country_iso_3={(self.country_iso_3 if hasattr(self, "country_iso_3") else None)!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'country_name={(self.country_name if hasattr(self, "country_name") else None)!s}, '
                f'country_code={(self.country_code if hasattr(self, "country_code") else None)!s}, '
                f'country_iso_2={(self.country_iso_2 if hasattr(self, "country_iso_2") else None)!s}, '
                f'country_iso_3={(self.country_iso_3 if hasattr(self, "country_iso_3") else None)!s})')
