# -*- coding: utf-8 -*-

"""
aviationstack

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from aviationstack.api_helper import APIHelper


class Error(object):

    """Implementation of the 'Error' model.

    Attributes:
        code (str): Error code
        message (str): Error message
        details (Any): Additional error details

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "code": 'code',
        "message": 'message',
        "details": 'details'
    }

    _optionals = [
        'code',
        'message',
        'details',
    ]

    def __init__(self,
                 code=APIHelper.SKIP,
                 message=APIHelper.SKIP,
                 details=APIHelper.SKIP):
        """Constructor for the Error class"""

        # Initialize members of the class
        if code is not APIHelper.SKIP:
            self.code = code 
        if message is not APIHelper.SKIP:
            self.message = message 
        if details is not APIHelper.SKIP:
            self.details = details 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        code = dictionary.get("code") if dictionary.get("code") else APIHelper.SKIP
        message = dictionary.get("message") if dictionary.get("message") else APIHelper.SKIP
        details = dictionary.get("details") if dictionary.get("details") else APIHelper.SKIP
        # Return an object of this model
        return cls(code,
                   message,
                   details)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'code={(self.code if hasattr(self, "code") else None)!r}, '
                f'message={(self.message if hasattr(self, "message") else None)!r}, '
                f'details={(self.details if hasattr(self, "details") else None)!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'code={(self.code if hasattr(self, "code") else None)!s}, '
                f'message={(self.message if hasattr(self, "message") else None)!s}, '
                f'details={(self.details if hasattr(self, "details") else None)!s})')
