# -*- coding: utf-8 -*-

"""
aviationstack

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
import dateutil.parser

from aviationstack.api_helper import APIHelper
from aviationstack.models.aircraft_info import AircraftInfo
from aviationstack.models.airline_info import AirlineInfo
from aviationstack.models.airport_info import AirportInfo
from aviationstack.models.flight_info import FlightInfo
from aviationstack.models.live_info import LiveInfo


class Flight(object):

    """Implementation of the 'Flight' model.

    Attributes:
        flight_date (date): Date of the flight
        flight_status (FlightStatusEnum): Status of the flight
        departure (AirportInfo): The model property of type AirportInfo.
        arrival (AirportInfo): The model property of type AirportInfo.
        airline (AirlineInfo): The model property of type AirlineInfo.
        flight (FlightInfo): The model property of type FlightInfo.
        aircraft (AircraftInfo): The model property of type AircraftInfo.
        live (LiveInfo): The model property of type LiveInfo.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "flight_date": 'flight_date',
        "flight_status": 'flight_status',
        "departure": 'departure',
        "arrival": 'arrival',
        "airline": 'airline',
        "flight": 'flight',
        "aircraft": 'aircraft',
        "live": 'live'
    }

    _optionals = [
        'flight_date',
        'flight_status',
        'departure',
        'arrival',
        'airline',
        'flight',
        'aircraft',
        'live',
    ]

    def __init__(self,
                 flight_date=APIHelper.SKIP,
                 flight_status=APIHelper.SKIP,
                 departure=APIHelper.SKIP,
                 arrival=APIHelper.SKIP,
                 airline=APIHelper.SKIP,
                 flight=APIHelper.SKIP,
                 aircraft=APIHelper.SKIP,
                 live=APIHelper.SKIP):
        """Constructor for the Flight class"""

        # Initialize members of the class
        if flight_date is not APIHelper.SKIP:
            self.flight_date = flight_date 
        if flight_status is not APIHelper.SKIP:
            self.flight_status = flight_status 
        if departure is not APIHelper.SKIP:
            self.departure = departure 
        if arrival is not APIHelper.SKIP:
            self.arrival = arrival 
        if airline is not APIHelper.SKIP:
            self.airline = airline 
        if flight is not APIHelper.SKIP:
            self.flight = flight 
        if aircraft is not APIHelper.SKIP:
            self.aircraft = aircraft 
        if live is not APIHelper.SKIP:
            self.live = live 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        flight_date = dateutil.parser.parse(dictionary.get('flight_date')).date() if dictionary.get('flight_date') else APIHelper.SKIP
        flight_status = dictionary.get("flight_status") if dictionary.get("flight_status") else APIHelper.SKIP
        departure = AirportInfo.from_dictionary(dictionary.get('departure')) if 'departure' in dictionary.keys() else APIHelper.SKIP
        arrival = AirportInfo.from_dictionary(dictionary.get('arrival')) if 'arrival' in dictionary.keys() else APIHelper.SKIP
        airline = AirlineInfo.from_dictionary(dictionary.get('airline')) if 'airline' in dictionary.keys() else APIHelper.SKIP
        flight = FlightInfo.from_dictionary(dictionary.get('flight')) if 'flight' in dictionary.keys() else APIHelper.SKIP
        aircraft = AircraftInfo.from_dictionary(dictionary.get('aircraft')) if 'aircraft' in dictionary.keys() else APIHelper.SKIP
        live = LiveInfo.from_dictionary(dictionary.get('live')) if 'live' in dictionary.keys() else APIHelper.SKIP
        # Return an object of this model
        return cls(flight_date,
                   flight_status,
                   departure,
                   arrival,
                   airline,
                   flight,
                   aircraft,
                   live)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'flight_date={(self.flight_date if hasattr(self, "flight_date") else None)!r}, '
                f'flight_status={(self.flight_status if hasattr(self, "flight_status") else None)!r}, '
                f'departure={(self.departure if hasattr(self, "departure") else None)!r}, '
                f'arrival={(self.arrival if hasattr(self, "arrival") else None)!r}, '
                f'airline={(self.airline if hasattr(self, "airline") else None)!r}, '
                f'flight={(self.flight if hasattr(self, "flight") else None)!r}, '
                f'aircraft={(self.aircraft if hasattr(self, "aircraft") else None)!r}, '
                f'live={(self.live if hasattr(self, "live") else None)!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'flight_date={(self.flight_date if hasattr(self, "flight_date") else None)!s}, '
                f'flight_status={(self.flight_status if hasattr(self, "flight_status") else None)!s}, '
                f'departure={(self.departure if hasattr(self, "departure") else None)!s}, '
                f'arrival={(self.arrival if hasattr(self, "arrival") else None)!s}, '
                f'airline={(self.airline if hasattr(self, "airline") else None)!s}, '
                f'flight={(self.flight if hasattr(self, "flight") else None)!s}, '
                f'aircraft={(self.aircraft if hasattr(self, "aircraft") else None)!s}, '
                f'live={(self.live if hasattr(self, "live") else None)!s})')
