# -*- coding: utf-8 -*-

"""
aviationstack

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from aviationstack.api_helper import APIHelper


class FlightInfo(object):

    """Implementation of the 'FlightInfo' model.

    Attributes:
        number (str): Flight number
        iata (str): IATA code
        icao (str): ICAO code
        codeshared (str): Codeshare information

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "number": 'number',
        "iata": 'iata',
        "icao": 'icao',
        "codeshared": 'codeshared'
    }

    _optionals = [
        'number',
        'iata',
        'icao',
        'codeshared',
    ]

    def __init__(self,
                 number=APIHelper.SKIP,
                 iata=APIHelper.SKIP,
                 icao=APIHelper.SKIP,
                 codeshared=APIHelper.SKIP):
        """Constructor for the FlightInfo class"""

        # Initialize members of the class
        if number is not APIHelper.SKIP:
            self.number = number 
        if iata is not APIHelper.SKIP:
            self.iata = iata 
        if icao is not APIHelper.SKIP:
            self.icao = icao 
        if codeshared is not APIHelper.SKIP:
            self.codeshared = codeshared 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        number = dictionary.get("number") if dictionary.get("number") else APIHelper.SKIP
        iata = dictionary.get("iata") if dictionary.get("iata") else APIHelper.SKIP
        icao = dictionary.get("icao") if dictionary.get("icao") else APIHelper.SKIP
        codeshared = dictionary.get("codeshared") if dictionary.get("codeshared") else APIHelper.SKIP
        # Return an object of this model
        return cls(number,
                   iata,
                   icao,
                   codeshared)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'number={(self.number if hasattr(self, "number") else None)!r}, '
                f'iata={(self.iata if hasattr(self, "iata") else None)!r}, '
                f'icao={(self.icao if hasattr(self, "icao") else None)!r}, '
                f'codeshared={(self.codeshared if hasattr(self, "codeshared") else None)!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'number={(self.number if hasattr(self, "number") else None)!s}, '
                f'iata={(self.iata if hasattr(self, "iata") else None)!s}, '
                f'icao={(self.icao if hasattr(self, "icao") else None)!s}, '
                f'codeshared={(self.codeshared if hasattr(self, "codeshared") else None)!s})')
