# -*- coding: utf-8 -*-

"""
aviationstack

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from aviationstack.api_helper import APIHelper


class LiveInfo(object):

    """Implementation of the 'LiveInfo' model.

    Attributes:
        updated (datetime): Last update time
        latitude (float): Current latitude
        longitude (float): Current longitude
        altitude (float): Current altitude
        direction (float): Current direction
        speed_horizontal (float): Horizontal speed
        speed_vertical (float): Vertical speed
        is_ground (bool): Whether aircraft is on ground

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "updated": 'updated',
        "latitude": 'latitude',
        "longitude": 'longitude',
        "altitude": 'altitude',
        "direction": 'direction',
        "speed_horizontal": 'speed_horizontal',
        "speed_vertical": 'speed_vertical',
        "is_ground": 'is_ground'
    }

    _optionals = [
        'updated',
        'latitude',
        'longitude',
        'altitude',
        'direction',
        'speed_horizontal',
        'speed_vertical',
        'is_ground',
    ]

    def __init__(self,
                 updated=APIHelper.SKIP,
                 latitude=APIHelper.SKIP,
                 longitude=APIHelper.SKIP,
                 altitude=APIHelper.SKIP,
                 direction=APIHelper.SKIP,
                 speed_horizontal=APIHelper.SKIP,
                 speed_vertical=APIHelper.SKIP,
                 is_ground=APIHelper.SKIP):
        """Constructor for the LiveInfo class"""

        # Initialize members of the class
        if updated is not APIHelper.SKIP:
            self.updated = APIHelper.apply_datetime_converter(updated, APIHelper.RFC3339DateTime) if updated else None 
        if latitude is not APIHelper.SKIP:
            self.latitude = latitude 
        if longitude is not APIHelper.SKIP:
            self.longitude = longitude 
        if altitude is not APIHelper.SKIP:
            self.altitude = altitude 
        if direction is not APIHelper.SKIP:
            self.direction = direction 
        if speed_horizontal is not APIHelper.SKIP:
            self.speed_horizontal = speed_horizontal 
        if speed_vertical is not APIHelper.SKIP:
            self.speed_vertical = speed_vertical 
        if is_ground is not APIHelper.SKIP:
            self.is_ground = is_ground 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        updated = APIHelper.RFC3339DateTime.from_value(dictionary.get("updated")).datetime if dictionary.get("updated") else APIHelper.SKIP
        latitude = dictionary.get("latitude") if dictionary.get("latitude") else APIHelper.SKIP
        longitude = dictionary.get("longitude") if dictionary.get("longitude") else APIHelper.SKIP
        altitude = dictionary.get("altitude") if dictionary.get("altitude") else APIHelper.SKIP
        direction = dictionary.get("direction") if dictionary.get("direction") else APIHelper.SKIP
        speed_horizontal = dictionary.get("speed_horizontal") if dictionary.get("speed_horizontal") else APIHelper.SKIP
        speed_vertical = dictionary.get("speed_vertical") if dictionary.get("speed_vertical") else APIHelper.SKIP
        is_ground = dictionary.get("is_ground") if "is_ground" in dictionary.keys() else APIHelper.SKIP
        # Return an object of this model
        return cls(updated,
                   latitude,
                   longitude,
                   altitude,
                   direction,
                   speed_horizontal,
                   speed_vertical,
                   is_ground)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'updated={(self.updated if hasattr(self, "updated") else None)!r}, '
                f'latitude={(self.latitude if hasattr(self, "latitude") else None)!r}, '
                f'longitude={(self.longitude if hasattr(self, "longitude") else None)!r}, '
                f'altitude={(self.altitude if hasattr(self, "altitude") else None)!r}, '
                f'direction={(self.direction if hasattr(self, "direction") else None)!r}, '
                f'speed_horizontal={(self.speed_horizontal if hasattr(self, "speed_horizontal") else None)!r}, '
                f'speed_vertical={(self.speed_vertical if hasattr(self, "speed_vertical") else None)!r}, '
                f'is_ground={(self.is_ground if hasattr(self, "is_ground") else None)!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'updated={(self.updated if hasattr(self, "updated") else None)!s}, '
                f'latitude={(self.latitude if hasattr(self, "latitude") else None)!s}, '
                f'longitude={(self.longitude if hasattr(self, "longitude") else None)!s}, '
                f'altitude={(self.altitude if hasattr(self, "altitude") else None)!s}, '
                f'direction={(self.direction if hasattr(self, "direction") else None)!s}, '
                f'speed_horizontal={(self.speed_horizontal if hasattr(self, "speed_horizontal") else None)!s}, '
                f'speed_vertical={(self.speed_vertical if hasattr(self, "speed_vertical") else None)!s}, '
                f'is_ground={(self.is_ground if hasattr(self, "is_ground") else None)!s})')
