# -*- coding: utf-8 -*-

"""
aviationstack

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from aviationstack.api_helper import APIHelper
from aviationstack.models.airline_info import AirlineInfo
from aviationstack.models.airport_info import AirportInfo


class Route(object):

    """Implementation of the 'Route' model.

    Attributes:
        airline (AirlineInfo): The model property of type AirlineInfo.
        departure (AirportInfo): The model property of type AirportInfo.
        arrival (AirportInfo): The model property of type AirportInfo.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "airline": 'airline',
        "departure": 'departure',
        "arrival": 'arrival'
    }

    _optionals = [
        'airline',
        'departure',
        'arrival',
    ]

    def __init__(self,
                 airline=APIHelper.SKIP,
                 departure=APIHelper.SKIP,
                 arrival=APIHelper.SKIP):
        """Constructor for the Route class"""

        # Initialize members of the class
        if airline is not APIHelper.SKIP:
            self.airline = airline 
        if departure is not APIHelper.SKIP:
            self.departure = departure 
        if arrival is not APIHelper.SKIP:
            self.arrival = arrival 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        airline = AirlineInfo.from_dictionary(dictionary.get('airline')) if 'airline' in dictionary.keys() else APIHelper.SKIP
        departure = AirportInfo.from_dictionary(dictionary.get('departure')) if 'departure' in dictionary.keys() else APIHelper.SKIP
        arrival = AirportInfo.from_dictionary(dictionary.get('arrival')) if 'arrival' in dictionary.keys() else APIHelper.SKIP
        # Return an object of this model
        return cls(airline,
                   departure,
                   arrival)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'airline={(self.airline if hasattr(self, "airline") else None)!r}, '
                f'departure={(self.departure if hasattr(self, "departure") else None)!r}, '
                f'arrival={(self.arrival if hasattr(self, "arrival") else None)!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'airline={(self.airline if hasattr(self, "airline") else None)!s}, '
                f'departure={(self.departure if hasattr(self, "departure") else None)!s}, '
                f'arrival={(self.arrival if hasattr(self, "arrival") else None)!s})')
