# -*- coding: utf-8 -*-

"""
aviationstack

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from aviationstack.api_helper import APIHelper


class Tax(object):

    """Implementation of the 'Tax' model.

    Attributes:
        iata_code (str): IATA code
        tax_name (str): Name of the tax
        tax_code (str): Code of the tax
        country_code (str): Country code
        country_name (str): Country name

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "iata_code": 'iata_code',
        "tax_name": 'tax_name',
        "tax_code": 'tax_code',
        "country_code": 'country_code',
        "country_name": 'country_name'
    }

    _optionals = [
        'iata_code',
        'tax_name',
        'tax_code',
        'country_code',
        'country_name',
    ]

    def __init__(self,
                 iata_code=APIHelper.SKIP,
                 tax_name=APIHelper.SKIP,
                 tax_code=APIHelper.SKIP,
                 country_code=APIHelper.SKIP,
                 country_name=APIHelper.SKIP):
        """Constructor for the Tax class"""

        # Initialize members of the class
        if iata_code is not APIHelper.SKIP:
            self.iata_code = iata_code 
        if tax_name is not APIHelper.SKIP:
            self.tax_name = tax_name 
        if tax_code is not APIHelper.SKIP:
            self.tax_code = tax_code 
        if country_code is not APIHelper.SKIP:
            self.country_code = country_code 
        if country_name is not APIHelper.SKIP:
            self.country_name = country_name 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        iata_code = dictionary.get("iata_code") if dictionary.get("iata_code") else APIHelper.SKIP
        tax_name = dictionary.get("tax_name") if dictionary.get("tax_name") else APIHelper.SKIP
        tax_code = dictionary.get("tax_code") if dictionary.get("tax_code") else APIHelper.SKIP
        country_code = dictionary.get("country_code") if dictionary.get("country_code") else APIHelper.SKIP
        country_name = dictionary.get("country_name") if dictionary.get("country_name") else APIHelper.SKIP
        # Return an object of this model
        return cls(iata_code,
                   tax_name,
                   tax_code,
                   country_code,
                   country_name)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'iata_code={(self.iata_code if hasattr(self, "iata_code") else None)!r}, '
                f'tax_name={(self.tax_name if hasattr(self, "tax_name") else None)!r}, '
                f'tax_code={(self.tax_code if hasattr(self, "tax_code") else None)!r}, '
                f'country_code={(self.country_code if hasattr(self, "country_code") else None)!r}, '
                f'country_name={(self.country_name if hasattr(self, "country_name") else None)!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'iata_code={(self.iata_code if hasattr(self, "iata_code") else None)!s}, '
                f'tax_name={(self.tax_name if hasattr(self, "tax_name") else None)!s}, '
                f'tax_code={(self.tax_code if hasattr(self, "tax_code") else None)!s}, '
                f'country_code={(self.country_code if hasattr(self, "country_code") else None)!s}, '
                f'country_name={(self.country_name if hasattr(self, "country_name") else None)!s})')
