# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['WirelessBluetoothSettingsArgs', 'WirelessBluetoothSettings']

@pulumi.input_type
class WirelessBluetoothSettingsArgs:
    def __init__(__self__, *,
                 serial: pulumi.Input[_builtins.str],
                 major: Optional[pulumi.Input[_builtins.int]] = None,
                 minor: Optional[pulumi.Input[_builtins.int]] = None,
                 uuid: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a WirelessBluetoothSettings resource.
        :param pulumi.Input[_builtins.str] serial: serial path parameter.
        :param pulumi.Input[_builtins.int] major: Desired major value of the beacon. If the value is set to null it will reset to Dashboard's automatically generated value.
        :param pulumi.Input[_builtins.int] minor: Desired minor value of the beacon. If the value is set to null it will reset to Dashboard's automatically generated value.
        :param pulumi.Input[_builtins.str] uuid: Desired UUID of the beacon. If the value is set to null it will reset to Dashboard's automatically generated value.
        """
        pulumi.set(__self__, "serial", serial)
        if major is not None:
            pulumi.set(__self__, "major", major)
        if minor is not None:
            pulumi.set(__self__, "minor", minor)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)

    @_builtins.property
    @pulumi.getter
    def serial(self) -> pulumi.Input[_builtins.str]:
        """
        serial path parameter.
        """
        return pulumi.get(self, "serial")

    @serial.setter
    def serial(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "serial", value)

    @_builtins.property
    @pulumi.getter
    def major(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Desired major value of the beacon. If the value is set to null it will reset to Dashboard's automatically generated value.
        """
        return pulumi.get(self, "major")

    @major.setter
    def major(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "major", value)

    @_builtins.property
    @pulumi.getter
    def minor(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Desired minor value of the beacon. If the value is set to null it will reset to Dashboard's automatically generated value.
        """
        return pulumi.get(self, "minor")

    @minor.setter
    def minor(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "minor", value)

    @_builtins.property
    @pulumi.getter
    def uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Desired UUID of the beacon. If the value is set to null it will reset to Dashboard's automatically generated value.
        """
        return pulumi.get(self, "uuid")

    @uuid.setter
    def uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uuid", value)


@pulumi.input_type
class _WirelessBluetoothSettingsState:
    def __init__(__self__, *,
                 major: Optional[pulumi.Input[_builtins.int]] = None,
                 minor: Optional[pulumi.Input[_builtins.int]] = None,
                 serial: Optional[pulumi.Input[_builtins.str]] = None,
                 uuid: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering WirelessBluetoothSettings resources.
        :param pulumi.Input[_builtins.int] major: Desired major value of the beacon. If the value is set to null it will reset to Dashboard's automatically generated value.
        :param pulumi.Input[_builtins.int] minor: Desired minor value of the beacon. If the value is set to null it will reset to Dashboard's automatically generated value.
        :param pulumi.Input[_builtins.str] serial: serial path parameter.
        :param pulumi.Input[_builtins.str] uuid: Desired UUID of the beacon. If the value is set to null it will reset to Dashboard's automatically generated value.
        """
        if major is not None:
            pulumi.set(__self__, "major", major)
        if minor is not None:
            pulumi.set(__self__, "minor", minor)
        if serial is not None:
            pulumi.set(__self__, "serial", serial)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)

    @_builtins.property
    @pulumi.getter
    def major(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Desired major value of the beacon. If the value is set to null it will reset to Dashboard's automatically generated value.
        """
        return pulumi.get(self, "major")

    @major.setter
    def major(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "major", value)

    @_builtins.property
    @pulumi.getter
    def minor(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Desired minor value of the beacon. If the value is set to null it will reset to Dashboard's automatically generated value.
        """
        return pulumi.get(self, "minor")

    @minor.setter
    def minor(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "minor", value)

    @_builtins.property
    @pulumi.getter
    def serial(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        serial path parameter.
        """
        return pulumi.get(self, "serial")

    @serial.setter
    def serial(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "serial", value)

    @_builtins.property
    @pulumi.getter
    def uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Desired UUID of the beacon. If the value is set to null it will reset to Dashboard's automatically generated value.
        """
        return pulumi.get(self, "uuid")

    @uuid.setter
    def uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uuid", value)


@pulumi.type_token("meraki:devices/wirelessBluetoothSettings:WirelessBluetoothSettings")
class WirelessBluetoothSettings(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 major: Optional[pulumi.Input[_builtins.int]] = None,
                 minor: Optional[pulumi.Input[_builtins.int]] = None,
                 serial: Optional[pulumi.Input[_builtins.str]] = None,
                 uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.devices.WirelessBluetoothSettings("example",
            major=13,
            minor=125,
            serial="string",
            uuid="00000000-0000-0000-000-000000000000")
        pulumi.export("merakiDevicesWirelessBluetoothSettingsExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:devices/wirelessBluetoothSettings:WirelessBluetoothSettings example "serial"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] major: Desired major value of the beacon. If the value is set to null it will reset to Dashboard's automatically generated value.
        :param pulumi.Input[_builtins.int] minor: Desired minor value of the beacon. If the value is set to null it will reset to Dashboard's automatically generated value.
        :param pulumi.Input[_builtins.str] serial: serial path parameter.
        :param pulumi.Input[_builtins.str] uuid: Desired UUID of the beacon. If the value is set to null it will reset to Dashboard's automatically generated value.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WirelessBluetoothSettingsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.devices.WirelessBluetoothSettings("example",
            major=13,
            minor=125,
            serial="string",
            uuid="00000000-0000-0000-000-000000000000")
        pulumi.export("merakiDevicesWirelessBluetoothSettingsExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:devices/wirelessBluetoothSettings:WirelessBluetoothSettings example "serial"
        ```

        :param str resource_name: The name of the resource.
        :param WirelessBluetoothSettingsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WirelessBluetoothSettingsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 major: Optional[pulumi.Input[_builtins.int]] = None,
                 minor: Optional[pulumi.Input[_builtins.int]] = None,
                 serial: Optional[pulumi.Input[_builtins.str]] = None,
                 uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WirelessBluetoothSettingsArgs.__new__(WirelessBluetoothSettingsArgs)

            __props__.__dict__["major"] = major
            __props__.__dict__["minor"] = minor
            if serial is None and not opts.urn:
                raise TypeError("Missing required property 'serial'")
            __props__.__dict__["serial"] = serial
            __props__.__dict__["uuid"] = uuid
        super(WirelessBluetoothSettings, __self__).__init__(
            'meraki:devices/wirelessBluetoothSettings:WirelessBluetoothSettings',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            major: Optional[pulumi.Input[_builtins.int]] = None,
            minor: Optional[pulumi.Input[_builtins.int]] = None,
            serial: Optional[pulumi.Input[_builtins.str]] = None,
            uuid: Optional[pulumi.Input[_builtins.str]] = None) -> 'WirelessBluetoothSettings':
        """
        Get an existing WirelessBluetoothSettings resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] major: Desired major value of the beacon. If the value is set to null it will reset to Dashboard's automatically generated value.
        :param pulumi.Input[_builtins.int] minor: Desired minor value of the beacon. If the value is set to null it will reset to Dashboard's automatically generated value.
        :param pulumi.Input[_builtins.str] serial: serial path parameter.
        :param pulumi.Input[_builtins.str] uuid: Desired UUID of the beacon. If the value is set to null it will reset to Dashboard's automatically generated value.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WirelessBluetoothSettingsState.__new__(_WirelessBluetoothSettingsState)

        __props__.__dict__["major"] = major
        __props__.__dict__["minor"] = minor
        __props__.__dict__["serial"] = serial
        __props__.__dict__["uuid"] = uuid
        return WirelessBluetoothSettings(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def major(self) -> pulumi.Output[_builtins.int]:
        """
        Desired major value of the beacon. If the value is set to null it will reset to Dashboard's automatically generated value.
        """
        return pulumi.get(self, "major")

    @_builtins.property
    @pulumi.getter
    def minor(self) -> pulumi.Output[_builtins.int]:
        """
        Desired minor value of the beacon. If the value is set to null it will reset to Dashboard's automatically generated value.
        """
        return pulumi.get(self, "minor")

    @_builtins.property
    @pulumi.getter
    def serial(self) -> pulumi.Output[_builtins.str]:
        """
        serial path parameter.
        """
        return pulumi.get(self, "serial")

    @_builtins.property
    @pulumi.getter
    def uuid(self) -> pulumi.Output[_builtins.str]:
        """
        Desired UUID of the beacon. If the value is set to null it will reset to Dashboard's automatically generated value.
        """
        return pulumi.get(self, "uuid")

