# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BaseArgs', 'Base']

@pulumi.input_type
class BaseArgs:
    def __init__(__self__, *,
                 api: Optional[pulumi.Input['BaseApiArgs']] = None,
                 management: Optional[pulumi.Input['BaseManagementArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Base resource.
        :param pulumi.Input['BaseApiArgs'] api: API related settings
        :param pulumi.Input['BaseManagementArgs'] management: Information about the organization's management system
        :param pulumi.Input[_builtins.str] name: Organization name
        :param pulumi.Input[_builtins.str] organization_id: organizationId path parameter. Organization ID
        """
        if api is not None:
            pulumi.set(__self__, "api", api)
        if management is not None:
            pulumi.set(__self__, "management", management)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)

    @_builtins.property
    @pulumi.getter
    def api(self) -> Optional[pulumi.Input['BaseApiArgs']]:
        """
        API related settings
        """
        return pulumi.get(self, "api")

    @api.setter
    def api(self, value: Optional[pulumi.Input['BaseApiArgs']]):
        pulumi.set(self, "api", value)

    @_builtins.property
    @pulumi.getter
    def management(self) -> Optional[pulumi.Input['BaseManagementArgs']]:
        """
        Information about the organization's management system
        """
        return pulumi.get(self, "management")

    @management.setter
    def management(self, value: Optional[pulumi.Input['BaseManagementArgs']]):
        pulumi.set(self, "management", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Organization name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        organizationId path parameter. Organization ID
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization_id", value)


@pulumi.input_type
class _BaseState:
    def __init__(__self__, *,
                 api: Optional[pulumi.Input['BaseApiArgs']] = None,
                 cloud: Optional[pulumi.Input['BaseCloudArgs']] = None,
                 licensing: Optional[pulumi.Input['BaseLicensingArgs']] = None,
                 management: Optional[pulumi.Input['BaseManagementArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Base resources.
        :param pulumi.Input['BaseApiArgs'] api: API related settings
        :param pulumi.Input['BaseCloudArgs'] cloud: Data for this organization
        :param pulumi.Input['BaseLicensingArgs'] licensing: Licensing related settings
        :param pulumi.Input['BaseManagementArgs'] management: Information about the organization's management system
        :param pulumi.Input[_builtins.str] name: Organization name
        :param pulumi.Input[_builtins.str] organization_id: organizationId path parameter. Organization ID
        :param pulumi.Input[_builtins.str] url: Organization URL
        """
        if api is not None:
            pulumi.set(__self__, "api", api)
        if cloud is not None:
            pulumi.set(__self__, "cloud", cloud)
        if licensing is not None:
            pulumi.set(__self__, "licensing", licensing)
        if management is not None:
            pulumi.set(__self__, "management", management)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter
    def api(self) -> Optional[pulumi.Input['BaseApiArgs']]:
        """
        API related settings
        """
        return pulumi.get(self, "api")

    @api.setter
    def api(self, value: Optional[pulumi.Input['BaseApiArgs']]):
        pulumi.set(self, "api", value)

    @_builtins.property
    @pulumi.getter
    def cloud(self) -> Optional[pulumi.Input['BaseCloudArgs']]:
        """
        Data for this organization
        """
        return pulumi.get(self, "cloud")

    @cloud.setter
    def cloud(self, value: Optional[pulumi.Input['BaseCloudArgs']]):
        pulumi.set(self, "cloud", value)

    @_builtins.property
    @pulumi.getter
    def licensing(self) -> Optional[pulumi.Input['BaseLicensingArgs']]:
        """
        Licensing related settings
        """
        return pulumi.get(self, "licensing")

    @licensing.setter
    def licensing(self, value: Optional[pulumi.Input['BaseLicensingArgs']]):
        pulumi.set(self, "licensing", value)

    @_builtins.property
    @pulumi.getter
    def management(self) -> Optional[pulumi.Input['BaseManagementArgs']]:
        """
        Information about the organization's management system
        """
        return pulumi.get(self, "management")

    @management.setter
    def management(self, value: Optional[pulumi.Input['BaseManagementArgs']]):
        pulumi.set(self, "management", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Organization name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        organizationId path parameter. Organization ID
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization_id", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Organization URL
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url", value)


@pulumi.type_token("meraki:organizations/base:base")
class Base(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api: Optional[pulumi.Input[Union['BaseApiArgs', 'BaseApiArgsDict']]] = None,
                 management: Optional[pulumi.Input[Union['BaseManagementArgs', 'BaseManagementArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.organizations.Base("example",
            management={
                "details": [{
                    "name": "MSP ID",
                    "value": "123456",
                }],
            },
            name="My organization")
        pulumi.export("merakiOrganizationsExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:organizations/base:base example "organization_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['BaseApiArgs', 'BaseApiArgsDict']] api: API related settings
        :param pulumi.Input[Union['BaseManagementArgs', 'BaseManagementArgsDict']] management: Information about the organization's management system
        :param pulumi.Input[_builtins.str] name: Organization name
        :param pulumi.Input[_builtins.str] organization_id: organizationId path parameter. Organization ID
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[BaseArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.organizations.Base("example",
            management={
                "details": [{
                    "name": "MSP ID",
                    "value": "123456",
                }],
            },
            name="My organization")
        pulumi.export("merakiOrganizationsExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:organizations/base:base example "organization_id"
        ```

        :param str resource_name: The name of the resource.
        :param BaseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BaseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api: Optional[pulumi.Input[Union['BaseApiArgs', 'BaseApiArgsDict']]] = None,
                 management: Optional[pulumi.Input[Union['BaseManagementArgs', 'BaseManagementArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BaseArgs.__new__(BaseArgs)

            __props__.__dict__["api"] = api
            __props__.__dict__["management"] = management
            __props__.__dict__["name"] = name
            __props__.__dict__["organization_id"] = organization_id
            __props__.__dict__["cloud"] = None
            __props__.__dict__["licensing"] = None
            __props__.__dict__["url"] = None
        super(Base, __self__).__init__(
            'meraki:organizations/base:base',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api: Optional[pulumi.Input[Union['BaseApiArgs', 'BaseApiArgsDict']]] = None,
            cloud: Optional[pulumi.Input[Union['BaseCloudArgs', 'BaseCloudArgsDict']]] = None,
            licensing: Optional[pulumi.Input[Union['BaseLicensingArgs', 'BaseLicensingArgsDict']]] = None,
            management: Optional[pulumi.Input[Union['BaseManagementArgs', 'BaseManagementArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            organization_id: Optional[pulumi.Input[_builtins.str]] = None,
            url: Optional[pulumi.Input[_builtins.str]] = None) -> 'Base':
        """
        Get an existing Base resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['BaseApiArgs', 'BaseApiArgsDict']] api: API related settings
        :param pulumi.Input[Union['BaseCloudArgs', 'BaseCloudArgsDict']] cloud: Data for this organization
        :param pulumi.Input[Union['BaseLicensingArgs', 'BaseLicensingArgsDict']] licensing: Licensing related settings
        :param pulumi.Input[Union['BaseManagementArgs', 'BaseManagementArgsDict']] management: Information about the organization's management system
        :param pulumi.Input[_builtins.str] name: Organization name
        :param pulumi.Input[_builtins.str] organization_id: organizationId path parameter. Organization ID
        :param pulumi.Input[_builtins.str] url: Organization URL
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BaseState.__new__(_BaseState)

        __props__.__dict__["api"] = api
        __props__.__dict__["cloud"] = cloud
        __props__.__dict__["licensing"] = licensing
        __props__.__dict__["management"] = management
        __props__.__dict__["name"] = name
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["url"] = url
        return Base(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def api(self) -> pulumi.Output['outputs.BaseApi']:
        """
        API related settings
        """
        return pulumi.get(self, "api")

    @_builtins.property
    @pulumi.getter
    def cloud(self) -> pulumi.Output['outputs.BaseCloud']:
        """
        Data for this organization
        """
        return pulumi.get(self, "cloud")

    @_builtins.property
    @pulumi.getter
    def licensing(self) -> pulumi.Output['outputs.BaseLicensing']:
        """
        Licensing related settings
        """
        return pulumi.get(self, "licensing")

    @_builtins.property
    @pulumi.getter
    def management(self) -> pulumi.Output['outputs.BaseManagement']:
        """
        Information about the organization's management system
        """
        return pulumi.get(self, "management")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Organization name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[_builtins.str]:
        """
        organizationId path parameter. Organization ID
        """
        return pulumi.get(self, "organization_id")

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Output[_builtins.str]:
        """
        Organization URL
        """
        return pulumi.get(self, "url")

