# vdw-surfgen

`vdw-surfgen` is a Python CLI tool to generate points on the van der Waals (VDW) surface of a molecule using its XYZ geometry file.

Surface points are generated at a scaled VDW radius and can be used for visualization, machine learning, or molecular modeling.

It is inspired by  Robert T. McGibbon's [pyvdwsurface](https://github.com/rmcgibbo/pyvdwsurface).

## 🔧 Features

- 🧬 Read atomic coordinates from `.xyz` files
- ⚛️ Compute VDW surface points using Fibonacci sphere sampling
- 🔬 Set surface density (points per Å²)
- 💾 Save results as:
  - `.xyz` pseudo-atom file (always saved)
  - `.txt` coordinate file (optional)
  - `.png` 3D scatter plot (optional)
- 🎨 Beautiful colored terminal output with progress bars
- ⚡ Command-line interface (CLI) with full control

## 🚀 Installation

```bash
pip install vdw-surfgen

```

## 🔨Usage

```bash
# Basic usage (XYZ file always saved)
vsg molecule.xyz

# With additional formats and custom parameters
vsg molecule.xyz --scale 1.2 --density 2.0 --txt --img
```

**Options:**
- `--scale`: Scale factor for VDW radii (default: 1.0)
- `--density`: Point density per Å² (default: 1.0)  
- `--txt`: Save as TXT coordinate file
- `--img`: Save 3D visualization as PNG



[soajagbe](https://github.com/sajagbe).

