"""
TOV Extravaganza Help Command
Shows quick start and usage information
"""

from .. import __version__

def main():
    """Display help and usage information"""
    
    print()
    print("=" * 70)
    print(f"  TOV Extravaganza - Neutron Star Physics Toolkit")
    print(f"  Version {__version__}")
    print("=" * 70)
    print()
    print("QUICK START:")
    print()
    print("  1. Get example EOS files:")
    print("     $ tovx-demo")
    print()
    print("  2. Run analysis (choose one):")
    print("     $ tovx-wizard                      # Interactive guided mode")
    print("     $ tovx inputCode/hsdd2.csv         # Direct M-R + Tidal")
    print()
    print("CONSOLE COMMANDS:")
    print()
    print("  tovx-demo         Get example EOS files (copies to current dir)")
    print("  tovx              Solve TOV + compute tidal deformability")
    print("  tovx-radial       Generate radial profiles (M(r), p(r))")
    print("  tovx-converter    Convert EOS units interactively")
    print("  tovx-wizard       Interactive guided workflow")
    print("  tovextravaganza   Show this help message")
    print()
    print("EXAMPLES:")
    print()
    print("  # Compute Mass-Radius + Tidal for HS(DD2) EOS")
    print("  $ tovx inputCode/hsdd2.csv")
    print()
    print("  # Get radial profile for 1.4 solar mass star")
    print("  $ tovx-radial inputCode/hsdd2.csv -M 1.4")
    print()
    print("  # High resolution (1000 stars)")
    print("  $ tovx inputCode/hsdd2.csv -n 1000")
    print()
    print("OUTPUT:")
    print()
    print("  export/stars/")
    print("    csv/       Mass-Radius data (p_c, R, M, Lambda, k2)")
    print("    plots/     M-R curve, Lambda(M), k2(M) plots")
    print()
    print("  export/radial_profiles/")
    print("    json/      Detailed radial data")
    print("    plots/     M(r) and p(r) plots")
    print()
    print("HELP:")
    print()
    print("  $ tovx --help              Detailed tov.py options")
    print("  $ tovx-radial --help       Detailed radial.py options")
    print()
    print("DOCUMENTATION:")
    print()
    print("  GitHub:  https://github.com/PsiPhiDelta/TOVExtravaganza")
    print("  PyPI:    https://pypi.org/project/tovextravaganza/")
    print("  Citation: arXiv:2411.04064")
    print()
    print("CITATION:")
    print()
    print("  If you use this in your research, please cite:")
    print("  - This software: github.com/PsiPhiDelta/TOVExtravaganza")
    print("  - Our paper: arXiv:2411.04064")
    print()
    print("=" * 70)
    print("  Oh boy oh boy! Happy computing!")
    print("=" * 70)
    print()


if __name__ == "__main__":
    main()

