UR-AJ
-----
By Akshay Ajit Bhawar
Linkedin: 

A lightweight Python library to control Universal Robots (UR3/UR5/UR10/UR16) via socket programming.

Installation:
    pip install ur-aj

Usage Example:
    import ur_aj as ur
    import time

    ur.configure_robot("192.168.1.11", send=30001, recv=30003)

    print("Pose:", ur.getpose())
    print("Joints:", ur.getjoints())

    ur.moveJ(-12, -503, 122, 27, 124, -120, speed=0.1)
    ur.moveLoffset(100, 0, 20, speed=0.1)

    ur.digitalout(0, True)
    time.sleep(1)
    ur.digitalout(0, False)

Features:
    - Get robot pose, joints, and speed
    - MoveL / MoveJ absolute & relative motions
    - Control digital & analog IO
    - Update single joint angle
