"""
Actor model for Infosourceful Kernel.
"""

from typing import Optional
from pydantic import BaseModel, EmailStr
from .enums import ActorRole


class Actor(BaseModel):
    """Represents an actor (person or system) in the Infosourceful ecosystem."""

    name: str
    role: ActorRole
    email: Optional[EmailStr] = None

    class Config:
        """Pydantic configuration."""

        use_enum_values = True
