"""
Decision model for Infosourceful Kernel.
"""

from typing import Optional
from datetime import date
from pydantic import BaseModel
from .enums import DecisionStatus


class Decision(BaseModel):
    """Represents a decision made in the Infosourceful ecosystem."""

    id: str
    title: str
    date: Optional[date] = None
    rationale: Optional[str] = None
    status: Optional[DecisionStatus] = None

    class Config:
        """Pydantic configuration."""

        use_enum_values = True
