"""
Enums for Infosourceful Kernel domain models.
"""

from enum import Enum


class ArtifactType(str, Enum):
    """Types of artifacts in the Infosourceful system."""

    DECK = "deck"
    BRIEF = "brief"
    ACTION_LOG = "action_log"
    MAPPING = "mapping"
    DATASET = "dataset"


class ActorRole(str, Enum):
    """Roles that actors can have in the system."""

    OWNER = "owner"
    CONTRIBUTOR = "contributor"
    REVIEWER = "reviewer"
    STAKEHOLDER = "stakeholder"
    OBSERVER = "observer"


class DecisionStatus(str, Enum):
    """Status of decisions in the system."""

    PENDING = "pending"
    APPROVED = "approved"
    REJECTED = "rejected"
    DEFERRED = "deferred"
    IMPLEMENTED = "implemented"
