"""
Relation model for Infosourceful Kernel.
"""

from typing import Optional
from pydantic import BaseModel


class Relation(BaseModel):
    """Represents a relationship between entities in the Infosourceful ecosystem."""

    source_id: str
    target_id: str
    relation_type: str
    description: Optional[str] = None
    strength: Optional[float] = None  # 0.0 to 1.0

    class Config:
        """Pydantic configuration."""

        json_schema_extra = {
            "examples": [
                {
                    "source_id": "artifact_123",
                    "target_id": "artifact_456",
                    "relation_type": "depends_on",
                    "description": "Artifact 123 depends on artifact 456",
                    "strength": 0.8,
                }
            ]
        }
