import json
from jsonschema import Draft202012Validator
from importlib.resources import files


class MajorVersionError(Exception): ...


def validate_meta_obj(meta: dict):
    sv = str(meta.get("schema_version", "1.0.0"))
    major = sv.split(".")[0]
    schema_file = files("infosourceful_kernel.schemas").joinpath(
        f"meta-v{major}.0.json"
    )
    if not schema_file.exists():
        raise MajorVersionError(f"Unsupported schema major {major}")
    schema = json.loads(schema_file.read_text(encoding="utf-8"))
    Draft202012Validator(schema).validate(meta)
