# Generated by Django 5.2.7 on 2025-10-24 12:55

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="CentrifugoLog",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                (
                    "message_id",
                    models.CharField(
                        db_index=True,
                        help_text="Unique message identifier (UUID)",
                        max_length=100,
                        unique=True,
                    ),
                ),
                (
                    "channel",
                    models.CharField(
                        db_index=True,
                        help_text="Centrifugo channel (e.g., user#123, broadcast)",
                        max_length=200,
                    ),
                ),
                ("data", models.JSONField(help_text="Published data (JSON payload)")),
                (
                    "wait_for_ack",
                    models.BooleanField(
                        db_index=True,
                        default=False,
                        help_text="Whether this publish waited for ACK",
                    ),
                ),
                (
                    "ack_timeout",
                    models.IntegerField(blank=True, help_text="ACK timeout in seconds", null=True),
                ),
                (
                    "acks_received",
                    models.IntegerField(default=0, help_text="Number of ACKs received"),
                ),
                (
                    "acks_expected",
                    models.IntegerField(
                        blank=True, help_text="Number of ACKs expected (if known)", null=True
                    ),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("pending", "Pending"),
                            ("success", "Success"),
                            ("failed", "Failed"),
                            ("timeout", "Timeout"),
                            ("partial", "Partial Delivery"),
                        ],
                        db_index=True,
                        default="pending",
                        help_text="Current status of publish operation",
                        max_length=20,
                    ),
                ),
                (
                    "error_code",
                    models.CharField(
                        blank=True, help_text="Error code if failed", max_length=100, null=True
                    ),
                ),
                (
                    "error_message",
                    models.TextField(blank=True, help_text="Error message if failed", null=True),
                ),
                (
                    "duration_ms",
                    models.IntegerField(
                        blank=True, help_text="Total duration in milliseconds", null=True
                    ),
                ),
                (
                    "is_notification",
                    models.BooleanField(
                        db_index=True,
                        default=True,
                        help_text="Whether this is a notification (vs other pub type)",
                    ),
                ),
                (
                    "caller_ip",
                    models.GenericIPAddressField(
                        blank=True, help_text="IP address of caller", null=True
                    ),
                ),
                (
                    "user_agent",
                    models.TextField(blank=True, help_text="User agent of caller", null=True),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        auto_now_add=True, db_index=True, help_text="When publish was initiated"
                    ),
                ),
                (
                    "completed_at",
                    models.DateTimeField(
                        blank=True,
                        db_index=True,
                        help_text="When publish completed (success/failure/timeout)",
                        null=True,
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        blank=True,
                        help_text="User who triggered the publish (if applicable)",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="centrifugo_logs",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name": "Centrifugo Log",
                "verbose_name_plural": "Centrifugo Logs",
                "db_table": "django_cfg_centrifugo_log",
                "ordering": ["-created_at"],
                "indexes": [
                    models.Index(
                        fields=["channel", "-created_at"], name="django_cfg__channel_ee539b_idx"
                    ),
                    models.Index(
                        fields=["status", "-created_at"], name="django_cfg__status_73b0b0_idx"
                    ),
                    models.Index(
                        fields=["wait_for_ack", "status"], name="django_cfg__wait_fo_59bb80_idx"
                    ),
                    models.Index(
                        fields=["user", "-created_at"], name="django_cfg__user_id_5e0c7d_idx"
                    ),
                ],
            },
        ),
    ]
