# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AppSecCustomRuleArgs', 'AppSecCustomRule']

@pulumi.input_type
class AppSecCustomRuleArgs:
    def __init__(__self__, *,
                 config_id: pulumi.Input[int],
                 custom_rule: pulumi.Input[str]):
        """
        The set of arguments for constructing a AppSecCustomRule resource.
        :param pulumi.Input[int] config_id: Unique identifier of the security configuration
        :param pulumi.Input[str] custom_rule: JSON-formatted definition of the custom rule
        """
        pulumi.set(__self__, "config_id", config_id)
        pulumi.set(__self__, "custom_rule", custom_rule)

    @property
    @pulumi.getter(name="configId")
    def config_id(self) -> pulumi.Input[int]:
        """
        Unique identifier of the security configuration
        """
        return pulumi.get(self, "config_id")

    @config_id.setter
    def config_id(self, value: pulumi.Input[int]):
        pulumi.set(self, "config_id", value)

    @property
    @pulumi.getter(name="customRule")
    def custom_rule(self) -> pulumi.Input[str]:
        """
        JSON-formatted definition of the custom rule
        """
        return pulumi.get(self, "custom_rule")

    @custom_rule.setter
    def custom_rule(self, value: pulumi.Input[str]):
        pulumi.set(self, "custom_rule", value)


@pulumi.input_type
class _AppSecCustomRuleState:
    def __init__(__self__, *,
                 config_id: Optional[pulumi.Input[int]] = None,
                 custom_rule: Optional[pulumi.Input[str]] = None,
                 custom_rule_id: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering AppSecCustomRule resources.
        :param pulumi.Input[int] config_id: Unique identifier of the security configuration
        :param pulumi.Input[str] custom_rule: JSON-formatted definition of the custom rule
        """
        if config_id is not None:
            pulumi.set(__self__, "config_id", config_id)
        if custom_rule is not None:
            pulumi.set(__self__, "custom_rule", custom_rule)
        if custom_rule_id is not None:
            pulumi.set(__self__, "custom_rule_id", custom_rule_id)

    @property
    @pulumi.getter(name="configId")
    def config_id(self) -> Optional[pulumi.Input[int]]:
        """
        Unique identifier of the security configuration
        """
        return pulumi.get(self, "config_id")

    @config_id.setter
    def config_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "config_id", value)

    @property
    @pulumi.getter(name="customRule")
    def custom_rule(self) -> Optional[pulumi.Input[str]]:
        """
        JSON-formatted definition of the custom rule
        """
        return pulumi.get(self, "custom_rule")

    @custom_rule.setter
    def custom_rule(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_rule", value)

    @property
    @pulumi.getter(name="customRuleId")
    def custom_rule_id(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "custom_rule_id")

    @custom_rule_id.setter
    def custom_rule_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "custom_rule_id", value)


class AppSecCustomRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config_id: Optional[pulumi.Input[int]] = None,
                 custom_rule: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a AppSecCustomRule resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] config_id: Unique identifier of the security configuration
        :param pulumi.Input[str] custom_rule: JSON-formatted definition of the custom rule
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AppSecCustomRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a AppSecCustomRule resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param AppSecCustomRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppSecCustomRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config_id: Optional[pulumi.Input[int]] = None,
                 custom_rule: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AppSecCustomRuleArgs.__new__(AppSecCustomRuleArgs)

            if config_id is None and not opts.urn:
                raise TypeError("Missing required property 'config_id'")
            __props__.__dict__["config_id"] = config_id
            if custom_rule is None and not opts.urn:
                raise TypeError("Missing required property 'custom_rule'")
            __props__.__dict__["custom_rule"] = custom_rule
            __props__.__dict__["custom_rule_id"] = None
        super(AppSecCustomRule, __self__).__init__(
            'akamai:index/appSecCustomRule:AppSecCustomRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            config_id: Optional[pulumi.Input[int]] = None,
            custom_rule: Optional[pulumi.Input[str]] = None,
            custom_rule_id: Optional[pulumi.Input[int]] = None) -> 'AppSecCustomRule':
        """
        Get an existing AppSecCustomRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] config_id: Unique identifier of the security configuration
        :param pulumi.Input[str] custom_rule: JSON-formatted definition of the custom rule
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AppSecCustomRuleState.__new__(_AppSecCustomRuleState)

        __props__.__dict__["config_id"] = config_id
        __props__.__dict__["custom_rule"] = custom_rule
        __props__.__dict__["custom_rule_id"] = custom_rule_id
        return AppSecCustomRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="configId")
    def config_id(self) -> pulumi.Output[int]:
        """
        Unique identifier of the security configuration
        """
        return pulumi.get(self, "config_id")

    @property
    @pulumi.getter(name="customRule")
    def custom_rule(self) -> pulumi.Output[str]:
        """
        JSON-formatted definition of the custom rule
        """
        return pulumi.get(self, "custom_rule")

    @property
    @pulumi.getter(name="customRuleId")
    def custom_rule_id(self) -> pulumi.Output[int]:
        return pulumi.get(self, "custom_rule_id")

