# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AppSecMalwarePolicyArgs', 'AppSecMalwarePolicy']

@pulumi.input_type
class AppSecMalwarePolicyArgs:
    def __init__(__self__, *,
                 config_id: pulumi.Input[int],
                 malware_policy: pulumi.Input[str]):
        """
        The set of arguments for constructing a AppSecMalwarePolicy resource.
        :param pulumi.Input[int] config_id: Unique identifier of the security configuration
        :param pulumi.Input[str] malware_policy: JSON-formatted definition of the malware policy
        """
        pulumi.set(__self__, "config_id", config_id)
        pulumi.set(__self__, "malware_policy", malware_policy)

    @property
    @pulumi.getter(name="configId")
    def config_id(self) -> pulumi.Input[int]:
        """
        Unique identifier of the security configuration
        """
        return pulumi.get(self, "config_id")

    @config_id.setter
    def config_id(self, value: pulumi.Input[int]):
        pulumi.set(self, "config_id", value)

    @property
    @pulumi.getter(name="malwarePolicy")
    def malware_policy(self) -> pulumi.Input[str]:
        """
        JSON-formatted definition of the malware policy
        """
        return pulumi.get(self, "malware_policy")

    @malware_policy.setter
    def malware_policy(self, value: pulumi.Input[str]):
        pulumi.set(self, "malware_policy", value)


@pulumi.input_type
class _AppSecMalwarePolicyState:
    def __init__(__self__, *,
                 config_id: Optional[pulumi.Input[int]] = None,
                 malware_policy: Optional[pulumi.Input[str]] = None,
                 malware_policy_id: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering AppSecMalwarePolicy resources.
        :param pulumi.Input[int] config_id: Unique identifier of the security configuration
        :param pulumi.Input[str] malware_policy: JSON-formatted definition of the malware policy
        :param pulumi.Input[int] malware_policy_id: Unique identifier of the malware policy
        """
        if config_id is not None:
            pulumi.set(__self__, "config_id", config_id)
        if malware_policy is not None:
            pulumi.set(__self__, "malware_policy", malware_policy)
        if malware_policy_id is not None:
            pulumi.set(__self__, "malware_policy_id", malware_policy_id)

    @property
    @pulumi.getter(name="configId")
    def config_id(self) -> Optional[pulumi.Input[int]]:
        """
        Unique identifier of the security configuration
        """
        return pulumi.get(self, "config_id")

    @config_id.setter
    def config_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "config_id", value)

    @property
    @pulumi.getter(name="malwarePolicy")
    def malware_policy(self) -> Optional[pulumi.Input[str]]:
        """
        JSON-formatted definition of the malware policy
        """
        return pulumi.get(self, "malware_policy")

    @malware_policy.setter
    def malware_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "malware_policy", value)

    @property
    @pulumi.getter(name="malwarePolicyId")
    def malware_policy_id(self) -> Optional[pulumi.Input[int]]:
        """
        Unique identifier of the malware policy
        """
        return pulumi.get(self, "malware_policy_id")

    @malware_policy_id.setter
    def malware_policy_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "malware_policy_id", value)


class AppSecMalwarePolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config_id: Optional[pulumi.Input[int]] = None,
                 malware_policy: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a AppSecMalwarePolicy resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] config_id: Unique identifier of the security configuration
        :param pulumi.Input[str] malware_policy: JSON-formatted definition of the malware policy
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AppSecMalwarePolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a AppSecMalwarePolicy resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param AppSecMalwarePolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppSecMalwarePolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config_id: Optional[pulumi.Input[int]] = None,
                 malware_policy: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AppSecMalwarePolicyArgs.__new__(AppSecMalwarePolicyArgs)

            if config_id is None and not opts.urn:
                raise TypeError("Missing required property 'config_id'")
            __props__.__dict__["config_id"] = config_id
            if malware_policy is None and not opts.urn:
                raise TypeError("Missing required property 'malware_policy'")
            __props__.__dict__["malware_policy"] = malware_policy
            __props__.__dict__["malware_policy_id"] = None
        super(AppSecMalwarePolicy, __self__).__init__(
            'akamai:index/appSecMalwarePolicy:AppSecMalwarePolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            config_id: Optional[pulumi.Input[int]] = None,
            malware_policy: Optional[pulumi.Input[str]] = None,
            malware_policy_id: Optional[pulumi.Input[int]] = None) -> 'AppSecMalwarePolicy':
        """
        Get an existing AppSecMalwarePolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] config_id: Unique identifier of the security configuration
        :param pulumi.Input[str] malware_policy: JSON-formatted definition of the malware policy
        :param pulumi.Input[int] malware_policy_id: Unique identifier of the malware policy
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AppSecMalwarePolicyState.__new__(_AppSecMalwarePolicyState)

        __props__.__dict__["config_id"] = config_id
        __props__.__dict__["malware_policy"] = malware_policy
        __props__.__dict__["malware_policy_id"] = malware_policy_id
        return AppSecMalwarePolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="configId")
    def config_id(self) -> pulumi.Output[int]:
        """
        Unique identifier of the security configuration
        """
        return pulumi.get(self, "config_id")

    @property
    @pulumi.getter(name="malwarePolicy")
    def malware_policy(self) -> pulumi.Output[str]:
        """
        JSON-formatted definition of the malware policy
        """
        return pulumi.get(self, "malware_policy")

    @property
    @pulumi.getter(name="malwarePolicyId")
    def malware_policy_id(self) -> pulumi.Output[int]:
        """
        Unique identifier of the malware policy
        """
        return pulumi.get(self, "malware_policy_id")

