# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AppSecPenaltyBoxArgs', 'AppSecPenaltyBox']

@pulumi.input_type
class AppSecPenaltyBoxArgs:
    def __init__(__self__, *,
                 config_id: pulumi.Input[int],
                 penalty_box_action: pulumi.Input[str],
                 penalty_box_protection: pulumi.Input[bool],
                 security_policy_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a AppSecPenaltyBox resource.
        :param pulumi.Input[int] config_id: Unique identifier of the security configuration
        :param pulumi.Input[str] penalty_box_action: The action to be taken when the penalty box is triggered
        :param pulumi.Input[bool] penalty_box_protection: Whether to enable the penalty box for the specified security policy
        :param pulumi.Input[str] security_policy_id: Unique identifier of the security policy
        """
        pulumi.set(__self__, "config_id", config_id)
        pulumi.set(__self__, "penalty_box_action", penalty_box_action)
        pulumi.set(__self__, "penalty_box_protection", penalty_box_protection)
        pulumi.set(__self__, "security_policy_id", security_policy_id)

    @property
    @pulumi.getter(name="configId")
    def config_id(self) -> pulumi.Input[int]:
        """
        Unique identifier of the security configuration
        """
        return pulumi.get(self, "config_id")

    @config_id.setter
    def config_id(self, value: pulumi.Input[int]):
        pulumi.set(self, "config_id", value)

    @property
    @pulumi.getter(name="penaltyBoxAction")
    def penalty_box_action(self) -> pulumi.Input[str]:
        """
        The action to be taken when the penalty box is triggered
        """
        return pulumi.get(self, "penalty_box_action")

    @penalty_box_action.setter
    def penalty_box_action(self, value: pulumi.Input[str]):
        pulumi.set(self, "penalty_box_action", value)

    @property
    @pulumi.getter(name="penaltyBoxProtection")
    def penalty_box_protection(self) -> pulumi.Input[bool]:
        """
        Whether to enable the penalty box for the specified security policy
        """
        return pulumi.get(self, "penalty_box_protection")

    @penalty_box_protection.setter
    def penalty_box_protection(self, value: pulumi.Input[bool]):
        pulumi.set(self, "penalty_box_protection", value)

    @property
    @pulumi.getter(name="securityPolicyId")
    def security_policy_id(self) -> pulumi.Input[str]:
        """
        Unique identifier of the security policy
        """
        return pulumi.get(self, "security_policy_id")

    @security_policy_id.setter
    def security_policy_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "security_policy_id", value)


@pulumi.input_type
class _AppSecPenaltyBoxState:
    def __init__(__self__, *,
                 config_id: Optional[pulumi.Input[int]] = None,
                 penalty_box_action: Optional[pulumi.Input[str]] = None,
                 penalty_box_protection: Optional[pulumi.Input[bool]] = None,
                 security_policy_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AppSecPenaltyBox resources.
        :param pulumi.Input[int] config_id: Unique identifier of the security configuration
        :param pulumi.Input[str] penalty_box_action: The action to be taken when the penalty box is triggered
        :param pulumi.Input[bool] penalty_box_protection: Whether to enable the penalty box for the specified security policy
        :param pulumi.Input[str] security_policy_id: Unique identifier of the security policy
        """
        if config_id is not None:
            pulumi.set(__self__, "config_id", config_id)
        if penalty_box_action is not None:
            pulumi.set(__self__, "penalty_box_action", penalty_box_action)
        if penalty_box_protection is not None:
            pulumi.set(__self__, "penalty_box_protection", penalty_box_protection)
        if security_policy_id is not None:
            pulumi.set(__self__, "security_policy_id", security_policy_id)

    @property
    @pulumi.getter(name="configId")
    def config_id(self) -> Optional[pulumi.Input[int]]:
        """
        Unique identifier of the security configuration
        """
        return pulumi.get(self, "config_id")

    @config_id.setter
    def config_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "config_id", value)

    @property
    @pulumi.getter(name="penaltyBoxAction")
    def penalty_box_action(self) -> Optional[pulumi.Input[str]]:
        """
        The action to be taken when the penalty box is triggered
        """
        return pulumi.get(self, "penalty_box_action")

    @penalty_box_action.setter
    def penalty_box_action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "penalty_box_action", value)

    @property
    @pulumi.getter(name="penaltyBoxProtection")
    def penalty_box_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable the penalty box for the specified security policy
        """
        return pulumi.get(self, "penalty_box_protection")

    @penalty_box_protection.setter
    def penalty_box_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "penalty_box_protection", value)

    @property
    @pulumi.getter(name="securityPolicyId")
    def security_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier of the security policy
        """
        return pulumi.get(self, "security_policy_id")

    @security_policy_id.setter
    def security_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_policy_id", value)


class AppSecPenaltyBox(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config_id: Optional[pulumi.Input[int]] = None,
                 penalty_box_action: Optional[pulumi.Input[str]] = None,
                 penalty_box_protection: Optional[pulumi.Input[bool]] = None,
                 security_policy_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a AppSecPenaltyBox resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] config_id: Unique identifier of the security configuration
        :param pulumi.Input[str] penalty_box_action: The action to be taken when the penalty box is triggered
        :param pulumi.Input[bool] penalty_box_protection: Whether to enable the penalty box for the specified security policy
        :param pulumi.Input[str] security_policy_id: Unique identifier of the security policy
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AppSecPenaltyBoxArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a AppSecPenaltyBox resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param AppSecPenaltyBoxArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppSecPenaltyBoxArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config_id: Optional[pulumi.Input[int]] = None,
                 penalty_box_action: Optional[pulumi.Input[str]] = None,
                 penalty_box_protection: Optional[pulumi.Input[bool]] = None,
                 security_policy_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AppSecPenaltyBoxArgs.__new__(AppSecPenaltyBoxArgs)

            if config_id is None and not opts.urn:
                raise TypeError("Missing required property 'config_id'")
            __props__.__dict__["config_id"] = config_id
            if penalty_box_action is None and not opts.urn:
                raise TypeError("Missing required property 'penalty_box_action'")
            __props__.__dict__["penalty_box_action"] = penalty_box_action
            if penalty_box_protection is None and not opts.urn:
                raise TypeError("Missing required property 'penalty_box_protection'")
            __props__.__dict__["penalty_box_protection"] = penalty_box_protection
            if security_policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'security_policy_id'")
            __props__.__dict__["security_policy_id"] = security_policy_id
        super(AppSecPenaltyBox, __self__).__init__(
            'akamai:index/appSecPenaltyBox:AppSecPenaltyBox',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            config_id: Optional[pulumi.Input[int]] = None,
            penalty_box_action: Optional[pulumi.Input[str]] = None,
            penalty_box_protection: Optional[pulumi.Input[bool]] = None,
            security_policy_id: Optional[pulumi.Input[str]] = None) -> 'AppSecPenaltyBox':
        """
        Get an existing AppSecPenaltyBox resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] config_id: Unique identifier of the security configuration
        :param pulumi.Input[str] penalty_box_action: The action to be taken when the penalty box is triggered
        :param pulumi.Input[bool] penalty_box_protection: Whether to enable the penalty box for the specified security policy
        :param pulumi.Input[str] security_policy_id: Unique identifier of the security policy
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AppSecPenaltyBoxState.__new__(_AppSecPenaltyBoxState)

        __props__.__dict__["config_id"] = config_id
        __props__.__dict__["penalty_box_action"] = penalty_box_action
        __props__.__dict__["penalty_box_protection"] = penalty_box_protection
        __props__.__dict__["security_policy_id"] = security_policy_id
        return AppSecPenaltyBox(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="configId")
    def config_id(self) -> pulumi.Output[int]:
        """
        Unique identifier of the security configuration
        """
        return pulumi.get(self, "config_id")

    @property
    @pulumi.getter(name="penaltyBoxAction")
    def penalty_box_action(self) -> pulumi.Output[str]:
        """
        The action to be taken when the penalty box is triggered
        """
        return pulumi.get(self, "penalty_box_action")

    @property
    @pulumi.getter(name="penaltyBoxProtection")
    def penalty_box_protection(self) -> pulumi.Output[bool]:
        """
        Whether to enable the penalty box for the specified security policy
        """
        return pulumi.get(self, "penalty_box_protection")

    @property
    @pulumi.getter(name="securityPolicyId")
    def security_policy_id(self) -> pulumi.Output[str]:
        """
        Unique identifier of the security policy
        """
        return pulumi.get(self, "security_policy_id")

