# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AppSecSiemSettingsArgs', 'AppSecSiemSettings']

@pulumi.input_type
class AppSecSiemSettingsArgs:
    def __init__(__self__, *,
                 config_id: pulumi.Input[int],
                 enable_botman_siem: pulumi.Input[bool],
                 enable_for_all_policies: pulumi.Input[bool],
                 enable_siem: pulumi.Input[bool],
                 siem_id: pulumi.Input[int],
                 security_policy_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a AppSecSiemSettings resource.
        :param pulumi.Input[int] config_id: Unique identifier of the security configuration
        :param pulumi.Input[bool] enable_botman_siem: Whether Bot Manager events should be included in SIEM events
        :param pulumi.Input[bool] enable_for_all_policies: Whether to enable SIEM on all security policies in the security configuration
        :param pulumi.Input[bool] enable_siem: Whether to enable SIEM
        :param pulumi.Input[int] siem_id: Unique identifier of the SIEM settings being modified
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_policy_ids: List of IDs of security policy for which SIEM integration is to be enabled
        """
        pulumi.set(__self__, "config_id", config_id)
        pulumi.set(__self__, "enable_botman_siem", enable_botman_siem)
        pulumi.set(__self__, "enable_for_all_policies", enable_for_all_policies)
        pulumi.set(__self__, "enable_siem", enable_siem)
        pulumi.set(__self__, "siem_id", siem_id)
        if security_policy_ids is not None:
            pulumi.set(__self__, "security_policy_ids", security_policy_ids)

    @property
    @pulumi.getter(name="configId")
    def config_id(self) -> pulumi.Input[int]:
        """
        Unique identifier of the security configuration
        """
        return pulumi.get(self, "config_id")

    @config_id.setter
    def config_id(self, value: pulumi.Input[int]):
        pulumi.set(self, "config_id", value)

    @property
    @pulumi.getter(name="enableBotmanSiem")
    def enable_botman_siem(self) -> pulumi.Input[bool]:
        """
        Whether Bot Manager events should be included in SIEM events
        """
        return pulumi.get(self, "enable_botman_siem")

    @enable_botman_siem.setter
    def enable_botman_siem(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enable_botman_siem", value)

    @property
    @pulumi.getter(name="enableForAllPolicies")
    def enable_for_all_policies(self) -> pulumi.Input[bool]:
        """
        Whether to enable SIEM on all security policies in the security configuration
        """
        return pulumi.get(self, "enable_for_all_policies")

    @enable_for_all_policies.setter
    def enable_for_all_policies(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enable_for_all_policies", value)

    @property
    @pulumi.getter(name="enableSiem")
    def enable_siem(self) -> pulumi.Input[bool]:
        """
        Whether to enable SIEM
        """
        return pulumi.get(self, "enable_siem")

    @enable_siem.setter
    def enable_siem(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enable_siem", value)

    @property
    @pulumi.getter(name="siemId")
    def siem_id(self) -> pulumi.Input[int]:
        """
        Unique identifier of the SIEM settings being modified
        """
        return pulumi.get(self, "siem_id")

    @siem_id.setter
    def siem_id(self, value: pulumi.Input[int]):
        pulumi.set(self, "siem_id", value)

    @property
    @pulumi.getter(name="securityPolicyIds")
    def security_policy_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of IDs of security policy for which SIEM integration is to be enabled
        """
        return pulumi.get(self, "security_policy_ids")

    @security_policy_ids.setter
    def security_policy_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_policy_ids", value)


@pulumi.input_type
class _AppSecSiemSettingsState:
    def __init__(__self__, *,
                 config_id: Optional[pulumi.Input[int]] = None,
                 enable_botman_siem: Optional[pulumi.Input[bool]] = None,
                 enable_for_all_policies: Optional[pulumi.Input[bool]] = None,
                 enable_siem: Optional[pulumi.Input[bool]] = None,
                 security_policy_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 siem_id: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering AppSecSiemSettings resources.
        :param pulumi.Input[int] config_id: Unique identifier of the security configuration
        :param pulumi.Input[bool] enable_botman_siem: Whether Bot Manager events should be included in SIEM events
        :param pulumi.Input[bool] enable_for_all_policies: Whether to enable SIEM on all security policies in the security configuration
        :param pulumi.Input[bool] enable_siem: Whether to enable SIEM
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_policy_ids: List of IDs of security policy for which SIEM integration is to be enabled
        :param pulumi.Input[int] siem_id: Unique identifier of the SIEM settings being modified
        """
        if config_id is not None:
            pulumi.set(__self__, "config_id", config_id)
        if enable_botman_siem is not None:
            pulumi.set(__self__, "enable_botman_siem", enable_botman_siem)
        if enable_for_all_policies is not None:
            pulumi.set(__self__, "enable_for_all_policies", enable_for_all_policies)
        if enable_siem is not None:
            pulumi.set(__self__, "enable_siem", enable_siem)
        if security_policy_ids is not None:
            pulumi.set(__self__, "security_policy_ids", security_policy_ids)
        if siem_id is not None:
            pulumi.set(__self__, "siem_id", siem_id)

    @property
    @pulumi.getter(name="configId")
    def config_id(self) -> Optional[pulumi.Input[int]]:
        """
        Unique identifier of the security configuration
        """
        return pulumi.get(self, "config_id")

    @config_id.setter
    def config_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "config_id", value)

    @property
    @pulumi.getter(name="enableBotmanSiem")
    def enable_botman_siem(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether Bot Manager events should be included in SIEM events
        """
        return pulumi.get(self, "enable_botman_siem")

    @enable_botman_siem.setter
    def enable_botman_siem(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_botman_siem", value)

    @property
    @pulumi.getter(name="enableForAllPolicies")
    def enable_for_all_policies(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable SIEM on all security policies in the security configuration
        """
        return pulumi.get(self, "enable_for_all_policies")

    @enable_for_all_policies.setter
    def enable_for_all_policies(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_for_all_policies", value)

    @property
    @pulumi.getter(name="enableSiem")
    def enable_siem(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable SIEM
        """
        return pulumi.get(self, "enable_siem")

    @enable_siem.setter
    def enable_siem(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_siem", value)

    @property
    @pulumi.getter(name="securityPolicyIds")
    def security_policy_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of IDs of security policy for which SIEM integration is to be enabled
        """
        return pulumi.get(self, "security_policy_ids")

    @security_policy_ids.setter
    def security_policy_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_policy_ids", value)

    @property
    @pulumi.getter(name="siemId")
    def siem_id(self) -> Optional[pulumi.Input[int]]:
        """
        Unique identifier of the SIEM settings being modified
        """
        return pulumi.get(self, "siem_id")

    @siem_id.setter
    def siem_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "siem_id", value)


class AppSecSiemSettings(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config_id: Optional[pulumi.Input[int]] = None,
                 enable_botman_siem: Optional[pulumi.Input[bool]] = None,
                 enable_for_all_policies: Optional[pulumi.Input[bool]] = None,
                 enable_siem: Optional[pulumi.Input[bool]] = None,
                 security_policy_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 siem_id: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Create a AppSecSiemSettings resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] config_id: Unique identifier of the security configuration
        :param pulumi.Input[bool] enable_botman_siem: Whether Bot Manager events should be included in SIEM events
        :param pulumi.Input[bool] enable_for_all_policies: Whether to enable SIEM on all security policies in the security configuration
        :param pulumi.Input[bool] enable_siem: Whether to enable SIEM
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_policy_ids: List of IDs of security policy for which SIEM integration is to be enabled
        :param pulumi.Input[int] siem_id: Unique identifier of the SIEM settings being modified
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AppSecSiemSettingsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a AppSecSiemSettings resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param AppSecSiemSettingsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppSecSiemSettingsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config_id: Optional[pulumi.Input[int]] = None,
                 enable_botman_siem: Optional[pulumi.Input[bool]] = None,
                 enable_for_all_policies: Optional[pulumi.Input[bool]] = None,
                 enable_siem: Optional[pulumi.Input[bool]] = None,
                 security_policy_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 siem_id: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AppSecSiemSettingsArgs.__new__(AppSecSiemSettingsArgs)

            if config_id is None and not opts.urn:
                raise TypeError("Missing required property 'config_id'")
            __props__.__dict__["config_id"] = config_id
            if enable_botman_siem is None and not opts.urn:
                raise TypeError("Missing required property 'enable_botman_siem'")
            __props__.__dict__["enable_botman_siem"] = enable_botman_siem
            if enable_for_all_policies is None and not opts.urn:
                raise TypeError("Missing required property 'enable_for_all_policies'")
            __props__.__dict__["enable_for_all_policies"] = enable_for_all_policies
            if enable_siem is None and not opts.urn:
                raise TypeError("Missing required property 'enable_siem'")
            __props__.__dict__["enable_siem"] = enable_siem
            __props__.__dict__["security_policy_ids"] = security_policy_ids
            if siem_id is None and not opts.urn:
                raise TypeError("Missing required property 'siem_id'")
            __props__.__dict__["siem_id"] = siem_id
        super(AppSecSiemSettings, __self__).__init__(
            'akamai:index/appSecSiemSettings:AppSecSiemSettings',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            config_id: Optional[pulumi.Input[int]] = None,
            enable_botman_siem: Optional[pulumi.Input[bool]] = None,
            enable_for_all_policies: Optional[pulumi.Input[bool]] = None,
            enable_siem: Optional[pulumi.Input[bool]] = None,
            security_policy_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            siem_id: Optional[pulumi.Input[int]] = None) -> 'AppSecSiemSettings':
        """
        Get an existing AppSecSiemSettings resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] config_id: Unique identifier of the security configuration
        :param pulumi.Input[bool] enable_botman_siem: Whether Bot Manager events should be included in SIEM events
        :param pulumi.Input[bool] enable_for_all_policies: Whether to enable SIEM on all security policies in the security configuration
        :param pulumi.Input[bool] enable_siem: Whether to enable SIEM
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_policy_ids: List of IDs of security policy for which SIEM integration is to be enabled
        :param pulumi.Input[int] siem_id: Unique identifier of the SIEM settings being modified
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AppSecSiemSettingsState.__new__(_AppSecSiemSettingsState)

        __props__.__dict__["config_id"] = config_id
        __props__.__dict__["enable_botman_siem"] = enable_botman_siem
        __props__.__dict__["enable_for_all_policies"] = enable_for_all_policies
        __props__.__dict__["enable_siem"] = enable_siem
        __props__.__dict__["security_policy_ids"] = security_policy_ids
        __props__.__dict__["siem_id"] = siem_id
        return AppSecSiemSettings(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="configId")
    def config_id(self) -> pulumi.Output[int]:
        """
        Unique identifier of the security configuration
        """
        return pulumi.get(self, "config_id")

    @property
    @pulumi.getter(name="enableBotmanSiem")
    def enable_botman_siem(self) -> pulumi.Output[bool]:
        """
        Whether Bot Manager events should be included in SIEM events
        """
        return pulumi.get(self, "enable_botman_siem")

    @property
    @pulumi.getter(name="enableForAllPolicies")
    def enable_for_all_policies(self) -> pulumi.Output[bool]:
        """
        Whether to enable SIEM on all security policies in the security configuration
        """
        return pulumi.get(self, "enable_for_all_policies")

    @property
    @pulumi.getter(name="enableSiem")
    def enable_siem(self) -> pulumi.Output[bool]:
        """
        Whether to enable SIEM
        """
        return pulumi.get(self, "enable_siem")

    @property
    @pulumi.getter(name="securityPolicyIds")
    def security_policy_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of IDs of security policy for which SIEM integration is to be enabled
        """
        return pulumi.get(self, "security_policy_ids")

    @property
    @pulumi.getter(name="siemId")
    def siem_id(self) -> pulumi.Output[int]:
        """
        Unique identifier of the SIEM settings being modified
        """
        return pulumi.get(self, "siem_id")

