# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CloudletsApplicationLoadBalancerArgs', 'CloudletsApplicationLoadBalancer']

@pulumi.input_type
class CloudletsApplicationLoadBalancerArgs:
    def __init__(__self__, *,
                 data_centers: pulumi.Input[Sequence[pulumi.Input['CloudletsApplicationLoadBalancerDataCenterArgs']]],
                 origin_id: pulumi.Input[str],
                 balancing_type: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 liveness_settings: Optional[pulumi.Input['CloudletsApplicationLoadBalancerLivenessSettingsArgs']] = None):
        """
        The set of arguments for constructing a CloudletsApplicationLoadBalancer resource.
        :param pulumi.Input[Sequence[pulumi.Input['CloudletsApplicationLoadBalancerDataCenterArgs']]] data_centers: The object containing information on conditional origins being used as data centers for an Application Load Balancer
               implementation. Only Conditional Origins with an originType of CUSTOMER or NETSTORAGE can be used as data centers in an
               application load balancer configuration.
        :param pulumi.Input[str] origin_id: The conditional origin’s unique identifier
        :param pulumi.Input[str] balancing_type: The type of load balancing being performed. Options include WEIGHTED and PERFORMANCE
        :param pulumi.Input[str] description: The load balancer configuration description
        """
        pulumi.set(__self__, "data_centers", data_centers)
        pulumi.set(__self__, "origin_id", origin_id)
        if balancing_type is not None:
            pulumi.set(__self__, "balancing_type", balancing_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if liveness_settings is not None:
            pulumi.set(__self__, "liveness_settings", liveness_settings)

    @property
    @pulumi.getter(name="dataCenters")
    def data_centers(self) -> pulumi.Input[Sequence[pulumi.Input['CloudletsApplicationLoadBalancerDataCenterArgs']]]:
        """
        The object containing information on conditional origins being used as data centers for an Application Load Balancer
        implementation. Only Conditional Origins with an originType of CUSTOMER or NETSTORAGE can be used as data centers in an
        application load balancer configuration.
        """
        return pulumi.get(self, "data_centers")

    @data_centers.setter
    def data_centers(self, value: pulumi.Input[Sequence[pulumi.Input['CloudletsApplicationLoadBalancerDataCenterArgs']]]):
        pulumi.set(self, "data_centers", value)

    @property
    @pulumi.getter(name="originId")
    def origin_id(self) -> pulumi.Input[str]:
        """
        The conditional origin’s unique identifier
        """
        return pulumi.get(self, "origin_id")

    @origin_id.setter
    def origin_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "origin_id", value)

    @property
    @pulumi.getter(name="balancingType")
    def balancing_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of load balancing being performed. Options include WEIGHTED and PERFORMANCE
        """
        return pulumi.get(self, "balancing_type")

    @balancing_type.setter
    def balancing_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "balancing_type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The load balancer configuration description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="livenessSettings")
    def liveness_settings(self) -> Optional[pulumi.Input['CloudletsApplicationLoadBalancerLivenessSettingsArgs']]:
        return pulumi.get(self, "liveness_settings")

    @liveness_settings.setter
    def liveness_settings(self, value: Optional[pulumi.Input['CloudletsApplicationLoadBalancerLivenessSettingsArgs']]):
        pulumi.set(self, "liveness_settings", value)


@pulumi.input_type
class _CloudletsApplicationLoadBalancerState:
    def __init__(__self__, *,
                 balancing_type: Optional[pulumi.Input[str]] = None,
                 data_centers: Optional[pulumi.Input[Sequence[pulumi.Input['CloudletsApplicationLoadBalancerDataCenterArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 liveness_settings: Optional[pulumi.Input['CloudletsApplicationLoadBalancerLivenessSettingsArgs']] = None,
                 origin_id: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[int]] = None,
                 warnings: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering CloudletsApplicationLoadBalancer resources.
        :param pulumi.Input[str] balancing_type: The type of load balancing being performed. Options include WEIGHTED and PERFORMANCE
        :param pulumi.Input[Sequence[pulumi.Input['CloudletsApplicationLoadBalancerDataCenterArgs']]] data_centers: The object containing information on conditional origins being used as data centers for an Application Load Balancer
               implementation. Only Conditional Origins with an originType of CUSTOMER or NETSTORAGE can be used as data centers in an
               application load balancer configuration.
        :param pulumi.Input[str] description: The load balancer configuration description
        :param pulumi.Input[str] origin_id: The conditional origin’s unique identifier
        :param pulumi.Input[int] version: The load balancer configuration version
        :param pulumi.Input[str] warnings: Describes warnings during activation of load balancer configuration
        """
        if balancing_type is not None:
            pulumi.set(__self__, "balancing_type", balancing_type)
        if data_centers is not None:
            pulumi.set(__self__, "data_centers", data_centers)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if liveness_settings is not None:
            pulumi.set(__self__, "liveness_settings", liveness_settings)
        if origin_id is not None:
            pulumi.set(__self__, "origin_id", origin_id)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if warnings is not None:
            pulumi.set(__self__, "warnings", warnings)

    @property
    @pulumi.getter(name="balancingType")
    def balancing_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of load balancing being performed. Options include WEIGHTED and PERFORMANCE
        """
        return pulumi.get(self, "balancing_type")

    @balancing_type.setter
    def balancing_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "balancing_type", value)

    @property
    @pulumi.getter(name="dataCenters")
    def data_centers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CloudletsApplicationLoadBalancerDataCenterArgs']]]]:
        """
        The object containing information on conditional origins being used as data centers for an Application Load Balancer
        implementation. Only Conditional Origins with an originType of CUSTOMER or NETSTORAGE can be used as data centers in an
        application load balancer configuration.
        """
        return pulumi.get(self, "data_centers")

    @data_centers.setter
    def data_centers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CloudletsApplicationLoadBalancerDataCenterArgs']]]]):
        pulumi.set(self, "data_centers", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The load balancer configuration description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="livenessSettings")
    def liveness_settings(self) -> Optional[pulumi.Input['CloudletsApplicationLoadBalancerLivenessSettingsArgs']]:
        return pulumi.get(self, "liveness_settings")

    @liveness_settings.setter
    def liveness_settings(self, value: Optional[pulumi.Input['CloudletsApplicationLoadBalancerLivenessSettingsArgs']]):
        pulumi.set(self, "liveness_settings", value)

    @property
    @pulumi.getter(name="originId")
    def origin_id(self) -> Optional[pulumi.Input[str]]:
        """
        The conditional origin’s unique identifier
        """
        return pulumi.get(self, "origin_id")

    @origin_id.setter
    def origin_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "origin_id", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[int]]:
        """
        The load balancer configuration version
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter
    def warnings(self) -> Optional[pulumi.Input[str]]:
        """
        Describes warnings during activation of load balancer configuration
        """
        return pulumi.get(self, "warnings")

    @warnings.setter
    def warnings(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "warnings", value)


class CloudletsApplicationLoadBalancer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 balancing_type: Optional[pulumi.Input[str]] = None,
                 data_centers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CloudletsApplicationLoadBalancerDataCenterArgs']]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 liveness_settings: Optional[pulumi.Input[pulumi.InputType['CloudletsApplicationLoadBalancerLivenessSettingsArgs']]] = None,
                 origin_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a CloudletsApplicationLoadBalancer resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] balancing_type: The type of load balancing being performed. Options include WEIGHTED and PERFORMANCE
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CloudletsApplicationLoadBalancerDataCenterArgs']]]] data_centers: The object containing information on conditional origins being used as data centers for an Application Load Balancer
               implementation. Only Conditional Origins with an originType of CUSTOMER or NETSTORAGE can be used as data centers in an
               application load balancer configuration.
        :param pulumi.Input[str] description: The load balancer configuration description
        :param pulumi.Input[str] origin_id: The conditional origin’s unique identifier
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CloudletsApplicationLoadBalancerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a CloudletsApplicationLoadBalancer resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param CloudletsApplicationLoadBalancerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CloudletsApplicationLoadBalancerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 balancing_type: Optional[pulumi.Input[str]] = None,
                 data_centers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CloudletsApplicationLoadBalancerDataCenterArgs']]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 liveness_settings: Optional[pulumi.Input[pulumi.InputType['CloudletsApplicationLoadBalancerLivenessSettingsArgs']]] = None,
                 origin_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CloudletsApplicationLoadBalancerArgs.__new__(CloudletsApplicationLoadBalancerArgs)

            __props__.__dict__["balancing_type"] = balancing_type
            if data_centers is None and not opts.urn:
                raise TypeError("Missing required property 'data_centers'")
            __props__.__dict__["data_centers"] = data_centers
            __props__.__dict__["description"] = description
            __props__.__dict__["liveness_settings"] = liveness_settings
            if origin_id is None and not opts.urn:
                raise TypeError("Missing required property 'origin_id'")
            __props__.__dict__["origin_id"] = origin_id
            __props__.__dict__["version"] = None
            __props__.__dict__["warnings"] = None
        super(CloudletsApplicationLoadBalancer, __self__).__init__(
            'akamai:index/cloudletsApplicationLoadBalancer:CloudletsApplicationLoadBalancer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            balancing_type: Optional[pulumi.Input[str]] = None,
            data_centers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CloudletsApplicationLoadBalancerDataCenterArgs']]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            liveness_settings: Optional[pulumi.Input[pulumi.InputType['CloudletsApplicationLoadBalancerLivenessSettingsArgs']]] = None,
            origin_id: Optional[pulumi.Input[str]] = None,
            version: Optional[pulumi.Input[int]] = None,
            warnings: Optional[pulumi.Input[str]] = None) -> 'CloudletsApplicationLoadBalancer':
        """
        Get an existing CloudletsApplicationLoadBalancer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] balancing_type: The type of load balancing being performed. Options include WEIGHTED and PERFORMANCE
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CloudletsApplicationLoadBalancerDataCenterArgs']]]] data_centers: The object containing information on conditional origins being used as data centers for an Application Load Balancer
               implementation. Only Conditional Origins with an originType of CUSTOMER or NETSTORAGE can be used as data centers in an
               application load balancer configuration.
        :param pulumi.Input[str] description: The load balancer configuration description
        :param pulumi.Input[str] origin_id: The conditional origin’s unique identifier
        :param pulumi.Input[int] version: The load balancer configuration version
        :param pulumi.Input[str] warnings: Describes warnings during activation of load balancer configuration
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CloudletsApplicationLoadBalancerState.__new__(_CloudletsApplicationLoadBalancerState)

        __props__.__dict__["balancing_type"] = balancing_type
        __props__.__dict__["data_centers"] = data_centers
        __props__.__dict__["description"] = description
        __props__.__dict__["liveness_settings"] = liveness_settings
        __props__.__dict__["origin_id"] = origin_id
        __props__.__dict__["version"] = version
        __props__.__dict__["warnings"] = warnings
        return CloudletsApplicationLoadBalancer(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="balancingType")
    def balancing_type(self) -> pulumi.Output[Optional[str]]:
        """
        The type of load balancing being performed. Options include WEIGHTED and PERFORMANCE
        """
        return pulumi.get(self, "balancing_type")

    @property
    @pulumi.getter(name="dataCenters")
    def data_centers(self) -> pulumi.Output[Sequence['outputs.CloudletsApplicationLoadBalancerDataCenter']]:
        """
        The object containing information on conditional origins being used as data centers for an Application Load Balancer
        implementation. Only Conditional Origins with an originType of CUSTOMER or NETSTORAGE can be used as data centers in an
        application load balancer configuration.
        """
        return pulumi.get(self, "data_centers")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The load balancer configuration description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="livenessSettings")
    def liveness_settings(self) -> pulumi.Output[Optional['outputs.CloudletsApplicationLoadBalancerLivenessSettings']]:
        return pulumi.get(self, "liveness_settings")

    @property
    @pulumi.getter(name="originId")
    def origin_id(self) -> pulumi.Output[str]:
        """
        The conditional origin’s unique identifier
        """
        return pulumi.get(self, "origin_id")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[int]:
        """
        The load balancer configuration version
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter
    def warnings(self) -> pulumi.Output[str]:
        """
        Describes warnings during activation of load balancer configuration
        """
        return pulumi.get(self, "warnings")

