# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CpsThirdPartyEnrollmentArgs', 'CpsThirdPartyEnrollment']

@pulumi.input_type
class CpsThirdPartyEnrollmentArgs:
    def __init__(__self__, *,
                 admin_contact: pulumi.Input['CpsThirdPartyEnrollmentAdminContactArgs'],
                 common_name: pulumi.Input[str],
                 contract_id: pulumi.Input[str],
                 csr: pulumi.Input['CpsThirdPartyEnrollmentCsrArgs'],
                 network_configuration: pulumi.Input['CpsThirdPartyEnrollmentNetworkConfigurationArgs'],
                 organization: pulumi.Input['CpsThirdPartyEnrollmentOrganizationArgs'],
                 secure_network: pulumi.Input[str],
                 sni_only: pulumi.Input[bool],
                 tech_contact: pulumi.Input['CpsThirdPartyEnrollmentTechContactArgs'],
                 acknowledge_pre_verification_warnings: Optional[pulumi.Input[bool]] = None,
                 allow_duplicate_common_name: Optional[pulumi.Input[bool]] = None,
                 auto_approve_warnings: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 certificate_chain_type: Optional[pulumi.Input[str]] = None,
                 change_management: Optional[pulumi.Input[bool]] = None,
                 exclude_sans: Optional[pulumi.Input[bool]] = None,
                 sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 signature_algorithm: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a CpsThirdPartyEnrollment resource.
        :param pulumi.Input['CpsThirdPartyEnrollmentAdminContactArgs'] admin_contact: Contact information for the certificate administrator to use at organization
        :param pulumi.Input[str] common_name: Common name used for enrollment
        :param pulumi.Input[str] contract_id: Contract ID for which enrollment is retrieved
        :param pulumi.Input['CpsThirdPartyEnrollmentCsrArgs'] csr: Data used for generation of Certificate Signing Request
        :param pulumi.Input['CpsThirdPartyEnrollmentNetworkConfigurationArgs'] network_configuration: Settings containing network information and TLS metadata used by CPS
        :param pulumi.Input['CpsThirdPartyEnrollmentOrganizationArgs'] organization: Organization information
        :param pulumi.Input[str] secure_network: Type of TLS deployment network
        :param pulumi.Input[bool] sni_only: Whether Server Name Indication is used for enrollment
        :param pulumi.Input['CpsThirdPartyEnrollmentTechContactArgs'] tech_contact: Contact information for an administrator at Akamai
        :param pulumi.Input[bool] acknowledge_pre_verification_warnings: Whether acknowledge warnings before certificate verification
        :param pulumi.Input[bool] allow_duplicate_common_name: Allow to duplicate common name
        :param pulumi.Input[Sequence[pulumi.Input[str]]] auto_approve_warnings: List of warnings to be automatically approved
        :param pulumi.Input[str] certificate_chain_type: Certificate trust chain type
        :param pulumi.Input[bool] change_management: When set to false, the certificate will be deployed to both staging and production networks
        :param pulumi.Input[bool] exclude_sans: When true, SANs are excluded from the CSR
        :param pulumi.Input[Sequence[pulumi.Input[str]]] sans: List of SANs
        :param pulumi.Input[str] signature_algorithm: The SHA function. Changing this value may require running terraform destroy, terraform apply
        """
        pulumi.set(__self__, "admin_contact", admin_contact)
        pulumi.set(__self__, "common_name", common_name)
        pulumi.set(__self__, "contract_id", contract_id)
        pulumi.set(__self__, "csr", csr)
        pulumi.set(__self__, "network_configuration", network_configuration)
        pulumi.set(__self__, "organization", organization)
        pulumi.set(__self__, "secure_network", secure_network)
        pulumi.set(__self__, "sni_only", sni_only)
        pulumi.set(__self__, "tech_contact", tech_contact)
        if acknowledge_pre_verification_warnings is not None:
            pulumi.set(__self__, "acknowledge_pre_verification_warnings", acknowledge_pre_verification_warnings)
        if allow_duplicate_common_name is not None:
            pulumi.set(__self__, "allow_duplicate_common_name", allow_duplicate_common_name)
        if auto_approve_warnings is not None:
            pulumi.set(__self__, "auto_approve_warnings", auto_approve_warnings)
        if certificate_chain_type is not None:
            pulumi.set(__self__, "certificate_chain_type", certificate_chain_type)
        if change_management is not None:
            pulumi.set(__self__, "change_management", change_management)
        if exclude_sans is not None:
            pulumi.set(__self__, "exclude_sans", exclude_sans)
        if sans is not None:
            pulumi.set(__self__, "sans", sans)
        if signature_algorithm is not None:
            pulumi.set(__self__, "signature_algorithm", signature_algorithm)

    @property
    @pulumi.getter(name="adminContact")
    def admin_contact(self) -> pulumi.Input['CpsThirdPartyEnrollmentAdminContactArgs']:
        """
        Contact information for the certificate administrator to use at organization
        """
        return pulumi.get(self, "admin_contact")

    @admin_contact.setter
    def admin_contact(self, value: pulumi.Input['CpsThirdPartyEnrollmentAdminContactArgs']):
        pulumi.set(self, "admin_contact", value)

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> pulumi.Input[str]:
        """
        Common name used for enrollment
        """
        return pulumi.get(self, "common_name")

    @common_name.setter
    def common_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "common_name", value)

    @property
    @pulumi.getter(name="contractId")
    def contract_id(self) -> pulumi.Input[str]:
        """
        Contract ID for which enrollment is retrieved
        """
        return pulumi.get(self, "contract_id")

    @contract_id.setter
    def contract_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "contract_id", value)

    @property
    @pulumi.getter
    def csr(self) -> pulumi.Input['CpsThirdPartyEnrollmentCsrArgs']:
        """
        Data used for generation of Certificate Signing Request
        """
        return pulumi.get(self, "csr")

    @csr.setter
    def csr(self, value: pulumi.Input['CpsThirdPartyEnrollmentCsrArgs']):
        pulumi.set(self, "csr", value)

    @property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> pulumi.Input['CpsThirdPartyEnrollmentNetworkConfigurationArgs']:
        """
        Settings containing network information and TLS metadata used by CPS
        """
        return pulumi.get(self, "network_configuration")

    @network_configuration.setter
    def network_configuration(self, value: pulumi.Input['CpsThirdPartyEnrollmentNetworkConfigurationArgs']):
        pulumi.set(self, "network_configuration", value)

    @property
    @pulumi.getter
    def organization(self) -> pulumi.Input['CpsThirdPartyEnrollmentOrganizationArgs']:
        """
        Organization information
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: pulumi.Input['CpsThirdPartyEnrollmentOrganizationArgs']):
        pulumi.set(self, "organization", value)

    @property
    @pulumi.getter(name="secureNetwork")
    def secure_network(self) -> pulumi.Input[str]:
        """
        Type of TLS deployment network
        """
        return pulumi.get(self, "secure_network")

    @secure_network.setter
    def secure_network(self, value: pulumi.Input[str]):
        pulumi.set(self, "secure_network", value)

    @property
    @pulumi.getter(name="sniOnly")
    def sni_only(self) -> pulumi.Input[bool]:
        """
        Whether Server Name Indication is used for enrollment
        """
        return pulumi.get(self, "sni_only")

    @sni_only.setter
    def sni_only(self, value: pulumi.Input[bool]):
        pulumi.set(self, "sni_only", value)

    @property
    @pulumi.getter(name="techContact")
    def tech_contact(self) -> pulumi.Input['CpsThirdPartyEnrollmentTechContactArgs']:
        """
        Contact information for an administrator at Akamai
        """
        return pulumi.get(self, "tech_contact")

    @tech_contact.setter
    def tech_contact(self, value: pulumi.Input['CpsThirdPartyEnrollmentTechContactArgs']):
        pulumi.set(self, "tech_contact", value)

    @property
    @pulumi.getter(name="acknowledgePreVerificationWarnings")
    def acknowledge_pre_verification_warnings(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether acknowledge warnings before certificate verification
        """
        return pulumi.get(self, "acknowledge_pre_verification_warnings")

    @acknowledge_pre_verification_warnings.setter
    def acknowledge_pre_verification_warnings(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "acknowledge_pre_verification_warnings", value)

    @property
    @pulumi.getter(name="allowDuplicateCommonName")
    def allow_duplicate_common_name(self) -> Optional[pulumi.Input[bool]]:
        """
        Allow to duplicate common name
        """
        return pulumi.get(self, "allow_duplicate_common_name")

    @allow_duplicate_common_name.setter
    def allow_duplicate_common_name(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_duplicate_common_name", value)

    @property
    @pulumi.getter(name="autoApproveWarnings")
    def auto_approve_warnings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of warnings to be automatically approved
        """
        return pulumi.get(self, "auto_approve_warnings")

    @auto_approve_warnings.setter
    def auto_approve_warnings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "auto_approve_warnings", value)

    @property
    @pulumi.getter(name="certificateChainType")
    def certificate_chain_type(self) -> Optional[pulumi.Input[str]]:
        """
        Certificate trust chain type
        """
        return pulumi.get(self, "certificate_chain_type")

    @certificate_chain_type.setter
    def certificate_chain_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_chain_type", value)

    @property
    @pulumi.getter(name="changeManagement")
    def change_management(self) -> Optional[pulumi.Input[bool]]:
        """
        When set to false, the certificate will be deployed to both staging and production networks
        """
        return pulumi.get(self, "change_management")

    @change_management.setter
    def change_management(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "change_management", value)

    @property
    @pulumi.getter(name="excludeSans")
    def exclude_sans(self) -> Optional[pulumi.Input[bool]]:
        """
        When true, SANs are excluded from the CSR
        """
        return pulumi.get(self, "exclude_sans")

    @exclude_sans.setter
    def exclude_sans(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "exclude_sans", value)

    @property
    @pulumi.getter
    def sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of SANs
        """
        return pulumi.get(self, "sans")

    @sans.setter
    def sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "sans", value)

    @property
    @pulumi.getter(name="signatureAlgorithm")
    def signature_algorithm(self) -> Optional[pulumi.Input[str]]:
        """
        The SHA function. Changing this value may require running terraform destroy, terraform apply
        """
        return pulumi.get(self, "signature_algorithm")

    @signature_algorithm.setter
    def signature_algorithm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "signature_algorithm", value)


@pulumi.input_type
class _CpsThirdPartyEnrollmentState:
    def __init__(__self__, *,
                 acknowledge_pre_verification_warnings: Optional[pulumi.Input[bool]] = None,
                 admin_contact: Optional[pulumi.Input['CpsThirdPartyEnrollmentAdminContactArgs']] = None,
                 allow_duplicate_common_name: Optional[pulumi.Input[bool]] = None,
                 auto_approve_warnings: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 certificate_chain_type: Optional[pulumi.Input[str]] = None,
                 change_management: Optional[pulumi.Input[bool]] = None,
                 common_name: Optional[pulumi.Input[str]] = None,
                 contract_id: Optional[pulumi.Input[str]] = None,
                 csr: Optional[pulumi.Input['CpsThirdPartyEnrollmentCsrArgs']] = None,
                 exclude_sans: Optional[pulumi.Input[bool]] = None,
                 network_configuration: Optional[pulumi.Input['CpsThirdPartyEnrollmentNetworkConfigurationArgs']] = None,
                 organization: Optional[pulumi.Input['CpsThirdPartyEnrollmentOrganizationArgs']] = None,
                 sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 secure_network: Optional[pulumi.Input[str]] = None,
                 signature_algorithm: Optional[pulumi.Input[str]] = None,
                 sni_only: Optional[pulumi.Input[bool]] = None,
                 tech_contact: Optional[pulumi.Input['CpsThirdPartyEnrollmentTechContactArgs']] = None):
        """
        Input properties used for looking up and filtering CpsThirdPartyEnrollment resources.
        :param pulumi.Input[bool] acknowledge_pre_verification_warnings: Whether acknowledge warnings before certificate verification
        :param pulumi.Input['CpsThirdPartyEnrollmentAdminContactArgs'] admin_contact: Contact information for the certificate administrator to use at organization
        :param pulumi.Input[bool] allow_duplicate_common_name: Allow to duplicate common name
        :param pulumi.Input[Sequence[pulumi.Input[str]]] auto_approve_warnings: List of warnings to be automatically approved
        :param pulumi.Input[str] certificate_chain_type: Certificate trust chain type
        :param pulumi.Input[bool] change_management: When set to false, the certificate will be deployed to both staging and production networks
        :param pulumi.Input[str] common_name: Common name used for enrollment
        :param pulumi.Input[str] contract_id: Contract ID for which enrollment is retrieved
        :param pulumi.Input['CpsThirdPartyEnrollmentCsrArgs'] csr: Data used for generation of Certificate Signing Request
        :param pulumi.Input[bool] exclude_sans: When true, SANs are excluded from the CSR
        :param pulumi.Input['CpsThirdPartyEnrollmentNetworkConfigurationArgs'] network_configuration: Settings containing network information and TLS metadata used by CPS
        :param pulumi.Input['CpsThirdPartyEnrollmentOrganizationArgs'] organization: Organization information
        :param pulumi.Input[Sequence[pulumi.Input[str]]] sans: List of SANs
        :param pulumi.Input[str] secure_network: Type of TLS deployment network
        :param pulumi.Input[str] signature_algorithm: The SHA function. Changing this value may require running terraform destroy, terraform apply
        :param pulumi.Input[bool] sni_only: Whether Server Name Indication is used for enrollment
        :param pulumi.Input['CpsThirdPartyEnrollmentTechContactArgs'] tech_contact: Contact information for an administrator at Akamai
        """
        if acknowledge_pre_verification_warnings is not None:
            pulumi.set(__self__, "acknowledge_pre_verification_warnings", acknowledge_pre_verification_warnings)
        if admin_contact is not None:
            pulumi.set(__self__, "admin_contact", admin_contact)
        if allow_duplicate_common_name is not None:
            pulumi.set(__self__, "allow_duplicate_common_name", allow_duplicate_common_name)
        if auto_approve_warnings is not None:
            pulumi.set(__self__, "auto_approve_warnings", auto_approve_warnings)
        if certificate_chain_type is not None:
            pulumi.set(__self__, "certificate_chain_type", certificate_chain_type)
        if change_management is not None:
            pulumi.set(__self__, "change_management", change_management)
        if common_name is not None:
            pulumi.set(__self__, "common_name", common_name)
        if contract_id is not None:
            pulumi.set(__self__, "contract_id", contract_id)
        if csr is not None:
            pulumi.set(__self__, "csr", csr)
        if exclude_sans is not None:
            pulumi.set(__self__, "exclude_sans", exclude_sans)
        if network_configuration is not None:
            pulumi.set(__self__, "network_configuration", network_configuration)
        if organization is not None:
            pulumi.set(__self__, "organization", organization)
        if sans is not None:
            pulumi.set(__self__, "sans", sans)
        if secure_network is not None:
            pulumi.set(__self__, "secure_network", secure_network)
        if signature_algorithm is not None:
            pulumi.set(__self__, "signature_algorithm", signature_algorithm)
        if sni_only is not None:
            pulumi.set(__self__, "sni_only", sni_only)
        if tech_contact is not None:
            pulumi.set(__self__, "tech_contact", tech_contact)

    @property
    @pulumi.getter(name="acknowledgePreVerificationWarnings")
    def acknowledge_pre_verification_warnings(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether acknowledge warnings before certificate verification
        """
        return pulumi.get(self, "acknowledge_pre_verification_warnings")

    @acknowledge_pre_verification_warnings.setter
    def acknowledge_pre_verification_warnings(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "acknowledge_pre_verification_warnings", value)

    @property
    @pulumi.getter(name="adminContact")
    def admin_contact(self) -> Optional[pulumi.Input['CpsThirdPartyEnrollmentAdminContactArgs']]:
        """
        Contact information for the certificate administrator to use at organization
        """
        return pulumi.get(self, "admin_contact")

    @admin_contact.setter
    def admin_contact(self, value: Optional[pulumi.Input['CpsThirdPartyEnrollmentAdminContactArgs']]):
        pulumi.set(self, "admin_contact", value)

    @property
    @pulumi.getter(name="allowDuplicateCommonName")
    def allow_duplicate_common_name(self) -> Optional[pulumi.Input[bool]]:
        """
        Allow to duplicate common name
        """
        return pulumi.get(self, "allow_duplicate_common_name")

    @allow_duplicate_common_name.setter
    def allow_duplicate_common_name(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_duplicate_common_name", value)

    @property
    @pulumi.getter(name="autoApproveWarnings")
    def auto_approve_warnings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of warnings to be automatically approved
        """
        return pulumi.get(self, "auto_approve_warnings")

    @auto_approve_warnings.setter
    def auto_approve_warnings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "auto_approve_warnings", value)

    @property
    @pulumi.getter(name="certificateChainType")
    def certificate_chain_type(self) -> Optional[pulumi.Input[str]]:
        """
        Certificate trust chain type
        """
        return pulumi.get(self, "certificate_chain_type")

    @certificate_chain_type.setter
    def certificate_chain_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_chain_type", value)

    @property
    @pulumi.getter(name="changeManagement")
    def change_management(self) -> Optional[pulumi.Input[bool]]:
        """
        When set to false, the certificate will be deployed to both staging and production networks
        """
        return pulumi.get(self, "change_management")

    @change_management.setter
    def change_management(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "change_management", value)

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> Optional[pulumi.Input[str]]:
        """
        Common name used for enrollment
        """
        return pulumi.get(self, "common_name")

    @common_name.setter
    def common_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "common_name", value)

    @property
    @pulumi.getter(name="contractId")
    def contract_id(self) -> Optional[pulumi.Input[str]]:
        """
        Contract ID for which enrollment is retrieved
        """
        return pulumi.get(self, "contract_id")

    @contract_id.setter
    def contract_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "contract_id", value)

    @property
    @pulumi.getter
    def csr(self) -> Optional[pulumi.Input['CpsThirdPartyEnrollmentCsrArgs']]:
        """
        Data used for generation of Certificate Signing Request
        """
        return pulumi.get(self, "csr")

    @csr.setter
    def csr(self, value: Optional[pulumi.Input['CpsThirdPartyEnrollmentCsrArgs']]):
        pulumi.set(self, "csr", value)

    @property
    @pulumi.getter(name="excludeSans")
    def exclude_sans(self) -> Optional[pulumi.Input[bool]]:
        """
        When true, SANs are excluded from the CSR
        """
        return pulumi.get(self, "exclude_sans")

    @exclude_sans.setter
    def exclude_sans(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "exclude_sans", value)

    @property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> Optional[pulumi.Input['CpsThirdPartyEnrollmentNetworkConfigurationArgs']]:
        """
        Settings containing network information and TLS metadata used by CPS
        """
        return pulumi.get(self, "network_configuration")

    @network_configuration.setter
    def network_configuration(self, value: Optional[pulumi.Input['CpsThirdPartyEnrollmentNetworkConfigurationArgs']]):
        pulumi.set(self, "network_configuration", value)

    @property
    @pulumi.getter
    def organization(self) -> Optional[pulumi.Input['CpsThirdPartyEnrollmentOrganizationArgs']]:
        """
        Organization information
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: Optional[pulumi.Input['CpsThirdPartyEnrollmentOrganizationArgs']]):
        pulumi.set(self, "organization", value)

    @property
    @pulumi.getter
    def sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of SANs
        """
        return pulumi.get(self, "sans")

    @sans.setter
    def sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "sans", value)

    @property
    @pulumi.getter(name="secureNetwork")
    def secure_network(self) -> Optional[pulumi.Input[str]]:
        """
        Type of TLS deployment network
        """
        return pulumi.get(self, "secure_network")

    @secure_network.setter
    def secure_network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secure_network", value)

    @property
    @pulumi.getter(name="signatureAlgorithm")
    def signature_algorithm(self) -> Optional[pulumi.Input[str]]:
        """
        The SHA function. Changing this value may require running terraform destroy, terraform apply
        """
        return pulumi.get(self, "signature_algorithm")

    @signature_algorithm.setter
    def signature_algorithm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "signature_algorithm", value)

    @property
    @pulumi.getter(name="sniOnly")
    def sni_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether Server Name Indication is used for enrollment
        """
        return pulumi.get(self, "sni_only")

    @sni_only.setter
    def sni_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "sni_only", value)

    @property
    @pulumi.getter(name="techContact")
    def tech_contact(self) -> Optional[pulumi.Input['CpsThirdPartyEnrollmentTechContactArgs']]:
        """
        Contact information for an administrator at Akamai
        """
        return pulumi.get(self, "tech_contact")

    @tech_contact.setter
    def tech_contact(self, value: Optional[pulumi.Input['CpsThirdPartyEnrollmentTechContactArgs']]):
        pulumi.set(self, "tech_contact", value)


class CpsThirdPartyEnrollment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acknowledge_pre_verification_warnings: Optional[pulumi.Input[bool]] = None,
                 admin_contact: Optional[pulumi.Input[pulumi.InputType['CpsThirdPartyEnrollmentAdminContactArgs']]] = None,
                 allow_duplicate_common_name: Optional[pulumi.Input[bool]] = None,
                 auto_approve_warnings: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 certificate_chain_type: Optional[pulumi.Input[str]] = None,
                 change_management: Optional[pulumi.Input[bool]] = None,
                 common_name: Optional[pulumi.Input[str]] = None,
                 contract_id: Optional[pulumi.Input[str]] = None,
                 csr: Optional[pulumi.Input[pulumi.InputType['CpsThirdPartyEnrollmentCsrArgs']]] = None,
                 exclude_sans: Optional[pulumi.Input[bool]] = None,
                 network_configuration: Optional[pulumi.Input[pulumi.InputType['CpsThirdPartyEnrollmentNetworkConfigurationArgs']]] = None,
                 organization: Optional[pulumi.Input[pulumi.InputType['CpsThirdPartyEnrollmentOrganizationArgs']]] = None,
                 sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 secure_network: Optional[pulumi.Input[str]] = None,
                 signature_algorithm: Optional[pulumi.Input[str]] = None,
                 sni_only: Optional[pulumi.Input[bool]] = None,
                 tech_contact: Optional[pulumi.Input[pulumi.InputType['CpsThirdPartyEnrollmentTechContactArgs']]] = None,
                 __props__=None):
        """
        Create a CpsThirdPartyEnrollment resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] acknowledge_pre_verification_warnings: Whether acknowledge warnings before certificate verification
        :param pulumi.Input[pulumi.InputType['CpsThirdPartyEnrollmentAdminContactArgs']] admin_contact: Contact information for the certificate administrator to use at organization
        :param pulumi.Input[bool] allow_duplicate_common_name: Allow to duplicate common name
        :param pulumi.Input[Sequence[pulumi.Input[str]]] auto_approve_warnings: List of warnings to be automatically approved
        :param pulumi.Input[str] certificate_chain_type: Certificate trust chain type
        :param pulumi.Input[bool] change_management: When set to false, the certificate will be deployed to both staging and production networks
        :param pulumi.Input[str] common_name: Common name used for enrollment
        :param pulumi.Input[str] contract_id: Contract ID for which enrollment is retrieved
        :param pulumi.Input[pulumi.InputType['CpsThirdPartyEnrollmentCsrArgs']] csr: Data used for generation of Certificate Signing Request
        :param pulumi.Input[bool] exclude_sans: When true, SANs are excluded from the CSR
        :param pulumi.Input[pulumi.InputType['CpsThirdPartyEnrollmentNetworkConfigurationArgs']] network_configuration: Settings containing network information and TLS metadata used by CPS
        :param pulumi.Input[pulumi.InputType['CpsThirdPartyEnrollmentOrganizationArgs']] organization: Organization information
        :param pulumi.Input[Sequence[pulumi.Input[str]]] sans: List of SANs
        :param pulumi.Input[str] secure_network: Type of TLS deployment network
        :param pulumi.Input[str] signature_algorithm: The SHA function. Changing this value may require running terraform destroy, terraform apply
        :param pulumi.Input[bool] sni_only: Whether Server Name Indication is used for enrollment
        :param pulumi.Input[pulumi.InputType['CpsThirdPartyEnrollmentTechContactArgs']] tech_contact: Contact information for an administrator at Akamai
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CpsThirdPartyEnrollmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a CpsThirdPartyEnrollment resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param CpsThirdPartyEnrollmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CpsThirdPartyEnrollmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acknowledge_pre_verification_warnings: Optional[pulumi.Input[bool]] = None,
                 admin_contact: Optional[pulumi.Input[pulumi.InputType['CpsThirdPartyEnrollmentAdminContactArgs']]] = None,
                 allow_duplicate_common_name: Optional[pulumi.Input[bool]] = None,
                 auto_approve_warnings: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 certificate_chain_type: Optional[pulumi.Input[str]] = None,
                 change_management: Optional[pulumi.Input[bool]] = None,
                 common_name: Optional[pulumi.Input[str]] = None,
                 contract_id: Optional[pulumi.Input[str]] = None,
                 csr: Optional[pulumi.Input[pulumi.InputType['CpsThirdPartyEnrollmentCsrArgs']]] = None,
                 exclude_sans: Optional[pulumi.Input[bool]] = None,
                 network_configuration: Optional[pulumi.Input[pulumi.InputType['CpsThirdPartyEnrollmentNetworkConfigurationArgs']]] = None,
                 organization: Optional[pulumi.Input[pulumi.InputType['CpsThirdPartyEnrollmentOrganizationArgs']]] = None,
                 sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 secure_network: Optional[pulumi.Input[str]] = None,
                 signature_algorithm: Optional[pulumi.Input[str]] = None,
                 sni_only: Optional[pulumi.Input[bool]] = None,
                 tech_contact: Optional[pulumi.Input[pulumi.InputType['CpsThirdPartyEnrollmentTechContactArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CpsThirdPartyEnrollmentArgs.__new__(CpsThirdPartyEnrollmentArgs)

            __props__.__dict__["acknowledge_pre_verification_warnings"] = acknowledge_pre_verification_warnings
            if admin_contact is None and not opts.urn:
                raise TypeError("Missing required property 'admin_contact'")
            __props__.__dict__["admin_contact"] = admin_contact
            __props__.__dict__["allow_duplicate_common_name"] = allow_duplicate_common_name
            __props__.__dict__["auto_approve_warnings"] = auto_approve_warnings
            __props__.__dict__["certificate_chain_type"] = certificate_chain_type
            __props__.__dict__["change_management"] = change_management
            if common_name is None and not opts.urn:
                raise TypeError("Missing required property 'common_name'")
            __props__.__dict__["common_name"] = common_name
            if contract_id is None and not opts.urn:
                raise TypeError("Missing required property 'contract_id'")
            __props__.__dict__["contract_id"] = contract_id
            if csr is None and not opts.urn:
                raise TypeError("Missing required property 'csr'")
            __props__.__dict__["csr"] = csr
            __props__.__dict__["exclude_sans"] = exclude_sans
            if network_configuration is None and not opts.urn:
                raise TypeError("Missing required property 'network_configuration'")
            __props__.__dict__["network_configuration"] = network_configuration
            if organization is None and not opts.urn:
                raise TypeError("Missing required property 'organization'")
            __props__.__dict__["organization"] = organization
            __props__.__dict__["sans"] = sans
            if secure_network is None and not opts.urn:
                raise TypeError("Missing required property 'secure_network'")
            __props__.__dict__["secure_network"] = secure_network
            __props__.__dict__["signature_algorithm"] = signature_algorithm
            if sni_only is None and not opts.urn:
                raise TypeError("Missing required property 'sni_only'")
            __props__.__dict__["sni_only"] = sni_only
            if tech_contact is None and not opts.urn:
                raise TypeError("Missing required property 'tech_contact'")
            __props__.__dict__["tech_contact"] = tech_contact
        super(CpsThirdPartyEnrollment, __self__).__init__(
            'akamai:index/cpsThirdPartyEnrollment:CpsThirdPartyEnrollment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acknowledge_pre_verification_warnings: Optional[pulumi.Input[bool]] = None,
            admin_contact: Optional[pulumi.Input[pulumi.InputType['CpsThirdPartyEnrollmentAdminContactArgs']]] = None,
            allow_duplicate_common_name: Optional[pulumi.Input[bool]] = None,
            auto_approve_warnings: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            certificate_chain_type: Optional[pulumi.Input[str]] = None,
            change_management: Optional[pulumi.Input[bool]] = None,
            common_name: Optional[pulumi.Input[str]] = None,
            contract_id: Optional[pulumi.Input[str]] = None,
            csr: Optional[pulumi.Input[pulumi.InputType['CpsThirdPartyEnrollmentCsrArgs']]] = None,
            exclude_sans: Optional[pulumi.Input[bool]] = None,
            network_configuration: Optional[pulumi.Input[pulumi.InputType['CpsThirdPartyEnrollmentNetworkConfigurationArgs']]] = None,
            organization: Optional[pulumi.Input[pulumi.InputType['CpsThirdPartyEnrollmentOrganizationArgs']]] = None,
            sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            secure_network: Optional[pulumi.Input[str]] = None,
            signature_algorithm: Optional[pulumi.Input[str]] = None,
            sni_only: Optional[pulumi.Input[bool]] = None,
            tech_contact: Optional[pulumi.Input[pulumi.InputType['CpsThirdPartyEnrollmentTechContactArgs']]] = None) -> 'CpsThirdPartyEnrollment':
        """
        Get an existing CpsThirdPartyEnrollment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] acknowledge_pre_verification_warnings: Whether acknowledge warnings before certificate verification
        :param pulumi.Input[pulumi.InputType['CpsThirdPartyEnrollmentAdminContactArgs']] admin_contact: Contact information for the certificate administrator to use at organization
        :param pulumi.Input[bool] allow_duplicate_common_name: Allow to duplicate common name
        :param pulumi.Input[Sequence[pulumi.Input[str]]] auto_approve_warnings: List of warnings to be automatically approved
        :param pulumi.Input[str] certificate_chain_type: Certificate trust chain type
        :param pulumi.Input[bool] change_management: When set to false, the certificate will be deployed to both staging and production networks
        :param pulumi.Input[str] common_name: Common name used for enrollment
        :param pulumi.Input[str] contract_id: Contract ID for which enrollment is retrieved
        :param pulumi.Input[pulumi.InputType['CpsThirdPartyEnrollmentCsrArgs']] csr: Data used for generation of Certificate Signing Request
        :param pulumi.Input[bool] exclude_sans: When true, SANs are excluded from the CSR
        :param pulumi.Input[pulumi.InputType['CpsThirdPartyEnrollmentNetworkConfigurationArgs']] network_configuration: Settings containing network information and TLS metadata used by CPS
        :param pulumi.Input[pulumi.InputType['CpsThirdPartyEnrollmentOrganizationArgs']] organization: Organization information
        :param pulumi.Input[Sequence[pulumi.Input[str]]] sans: List of SANs
        :param pulumi.Input[str] secure_network: Type of TLS deployment network
        :param pulumi.Input[str] signature_algorithm: The SHA function. Changing this value may require running terraform destroy, terraform apply
        :param pulumi.Input[bool] sni_only: Whether Server Name Indication is used for enrollment
        :param pulumi.Input[pulumi.InputType['CpsThirdPartyEnrollmentTechContactArgs']] tech_contact: Contact information for an administrator at Akamai
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CpsThirdPartyEnrollmentState.__new__(_CpsThirdPartyEnrollmentState)

        __props__.__dict__["acknowledge_pre_verification_warnings"] = acknowledge_pre_verification_warnings
        __props__.__dict__["admin_contact"] = admin_contact
        __props__.__dict__["allow_duplicate_common_name"] = allow_duplicate_common_name
        __props__.__dict__["auto_approve_warnings"] = auto_approve_warnings
        __props__.__dict__["certificate_chain_type"] = certificate_chain_type
        __props__.__dict__["change_management"] = change_management
        __props__.__dict__["common_name"] = common_name
        __props__.__dict__["contract_id"] = contract_id
        __props__.__dict__["csr"] = csr
        __props__.__dict__["exclude_sans"] = exclude_sans
        __props__.__dict__["network_configuration"] = network_configuration
        __props__.__dict__["organization"] = organization
        __props__.__dict__["sans"] = sans
        __props__.__dict__["secure_network"] = secure_network
        __props__.__dict__["signature_algorithm"] = signature_algorithm
        __props__.__dict__["sni_only"] = sni_only
        __props__.__dict__["tech_contact"] = tech_contact
        return CpsThirdPartyEnrollment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="acknowledgePreVerificationWarnings")
    def acknowledge_pre_verification_warnings(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether acknowledge warnings before certificate verification
        """
        return pulumi.get(self, "acknowledge_pre_verification_warnings")

    @property
    @pulumi.getter(name="adminContact")
    def admin_contact(self) -> pulumi.Output['outputs.CpsThirdPartyEnrollmentAdminContact']:
        """
        Contact information for the certificate administrator to use at organization
        """
        return pulumi.get(self, "admin_contact")

    @property
    @pulumi.getter(name="allowDuplicateCommonName")
    def allow_duplicate_common_name(self) -> pulumi.Output[Optional[bool]]:
        """
        Allow to duplicate common name
        """
        return pulumi.get(self, "allow_duplicate_common_name")

    @property
    @pulumi.getter(name="autoApproveWarnings")
    def auto_approve_warnings(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of warnings to be automatically approved
        """
        return pulumi.get(self, "auto_approve_warnings")

    @property
    @pulumi.getter(name="certificateChainType")
    def certificate_chain_type(self) -> pulumi.Output[Optional[str]]:
        """
        Certificate trust chain type
        """
        return pulumi.get(self, "certificate_chain_type")

    @property
    @pulumi.getter(name="changeManagement")
    def change_management(self) -> pulumi.Output[Optional[bool]]:
        """
        When set to false, the certificate will be deployed to both staging and production networks
        """
        return pulumi.get(self, "change_management")

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> pulumi.Output[str]:
        """
        Common name used for enrollment
        """
        return pulumi.get(self, "common_name")

    @property
    @pulumi.getter(name="contractId")
    def contract_id(self) -> pulumi.Output[str]:
        """
        Contract ID for which enrollment is retrieved
        """
        return pulumi.get(self, "contract_id")

    @property
    @pulumi.getter
    def csr(self) -> pulumi.Output['outputs.CpsThirdPartyEnrollmentCsr']:
        """
        Data used for generation of Certificate Signing Request
        """
        return pulumi.get(self, "csr")

    @property
    @pulumi.getter(name="excludeSans")
    def exclude_sans(self) -> pulumi.Output[Optional[bool]]:
        """
        When true, SANs are excluded from the CSR
        """
        return pulumi.get(self, "exclude_sans")

    @property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> pulumi.Output['outputs.CpsThirdPartyEnrollmentNetworkConfiguration']:
        """
        Settings containing network information and TLS metadata used by CPS
        """
        return pulumi.get(self, "network_configuration")

    @property
    @pulumi.getter
    def organization(self) -> pulumi.Output['outputs.CpsThirdPartyEnrollmentOrganization']:
        """
        Organization information
        """
        return pulumi.get(self, "organization")

    @property
    @pulumi.getter
    def sans(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of SANs
        """
        return pulumi.get(self, "sans")

    @property
    @pulumi.getter(name="secureNetwork")
    def secure_network(self) -> pulumi.Output[str]:
        """
        Type of TLS deployment network
        """
        return pulumi.get(self, "secure_network")

    @property
    @pulumi.getter(name="signatureAlgorithm")
    def signature_algorithm(self) -> pulumi.Output[Optional[str]]:
        """
        The SHA function. Changing this value may require running terraform destroy, terraform apply
        """
        return pulumi.get(self, "signature_algorithm")

    @property
    @pulumi.getter(name="sniOnly")
    def sni_only(self) -> pulumi.Output[bool]:
        """
        Whether Server Name Indication is used for enrollment
        """
        return pulumi.get(self, "sni_only")

    @property
    @pulumi.getter(name="techContact")
    def tech_contact(self) -> pulumi.Output['outputs.CpsThirdPartyEnrollmentTechContact']:
        """
        Contact information for an administrator at Akamai
        """
        return pulumi.get(self, "tech_contact")

