# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['EdgeHostNameArgs', 'EdgeHostName']

@pulumi.input_type
class EdgeHostNameArgs:
    def __init__(__self__, *,
                 contract_id: pulumi.Input[str],
                 edge_hostname: pulumi.Input[str],
                 group_id: pulumi.Input[str],
                 ip_behavior: pulumi.Input[str],
                 certificate: Optional[pulumi.Input[int]] = None,
                 product_id: Optional[pulumi.Input[str]] = None,
                 status_update_emails: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 use_cases: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a EdgeHostName resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] status_update_emails: Email address that should receive updates on the IP behavior update request. Required for update operation.
        :param pulumi.Input[str] use_cases: A JSON encoded list of use cases
        """
        pulumi.set(__self__, "contract_id", contract_id)
        pulumi.set(__self__, "edge_hostname", edge_hostname)
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "ip_behavior", ip_behavior)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if product_id is not None:
            pulumi.set(__self__, "product_id", product_id)
        if status_update_emails is not None:
            pulumi.set(__self__, "status_update_emails", status_update_emails)
        if use_cases is not None:
            pulumi.set(__self__, "use_cases", use_cases)

    @property
    @pulumi.getter(name="contractId")
    def contract_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "contract_id")

    @contract_id.setter
    def contract_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "contract_id", value)

    @property
    @pulumi.getter(name="edgeHostname")
    def edge_hostname(self) -> pulumi.Input[str]:
        return pulumi.get(self, "edge_hostname")

    @edge_hostname.setter
    def edge_hostname(self, value: pulumi.Input[str]):
        pulumi.set(self, "edge_hostname", value)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "group_id", value)

    @property
    @pulumi.getter(name="ipBehavior")
    def ip_behavior(self) -> pulumi.Input[str]:
        return pulumi.get(self, "ip_behavior")

    @ip_behavior.setter
    def ip_behavior(self, value: pulumi.Input[str]):
        pulumi.set(self, "ip_behavior", value)

    @property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "certificate", value)

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "product_id")

    @product_id.setter
    def product_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "product_id", value)

    @property
    @pulumi.getter(name="statusUpdateEmails")
    def status_update_emails(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Email address that should receive updates on the IP behavior update request. Required for update operation.
        """
        return pulumi.get(self, "status_update_emails")

    @status_update_emails.setter
    def status_update_emails(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "status_update_emails", value)

    @property
    @pulumi.getter(name="useCases")
    def use_cases(self) -> Optional[pulumi.Input[str]]:
        """
        A JSON encoded list of use cases
        """
        return pulumi.get(self, "use_cases")

    @use_cases.setter
    def use_cases(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "use_cases", value)


@pulumi.input_type
class _EdgeHostNameState:
    def __init__(__self__, *,
                 certificate: Optional[pulumi.Input[int]] = None,
                 contract_id: Optional[pulumi.Input[str]] = None,
                 edge_hostname: Optional[pulumi.Input[str]] = None,
                 group_id: Optional[pulumi.Input[str]] = None,
                 ip_behavior: Optional[pulumi.Input[str]] = None,
                 product_id: Optional[pulumi.Input[str]] = None,
                 status_update_emails: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 use_cases: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering EdgeHostName resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] status_update_emails: Email address that should receive updates on the IP behavior update request. Required for update operation.
        :param pulumi.Input[str] use_cases: A JSON encoded list of use cases
        """
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if contract_id is not None:
            pulumi.set(__self__, "contract_id", contract_id)
        if edge_hostname is not None:
            pulumi.set(__self__, "edge_hostname", edge_hostname)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if ip_behavior is not None:
            pulumi.set(__self__, "ip_behavior", ip_behavior)
        if product_id is not None:
            pulumi.set(__self__, "product_id", product_id)
        if status_update_emails is not None:
            pulumi.set(__self__, "status_update_emails", status_update_emails)
        if use_cases is not None:
            pulumi.set(__self__, "use_cases", use_cases)

    @property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "certificate", value)

    @property
    @pulumi.getter(name="contractId")
    def contract_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "contract_id")

    @contract_id.setter
    def contract_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "contract_id", value)

    @property
    @pulumi.getter(name="edgeHostname")
    def edge_hostname(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "edge_hostname")

    @edge_hostname.setter
    def edge_hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "edge_hostname", value)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_id", value)

    @property
    @pulumi.getter(name="ipBehavior")
    def ip_behavior(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "ip_behavior")

    @ip_behavior.setter
    def ip_behavior(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_behavior", value)

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "product_id")

    @product_id.setter
    def product_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "product_id", value)

    @property
    @pulumi.getter(name="statusUpdateEmails")
    def status_update_emails(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Email address that should receive updates on the IP behavior update request. Required for update operation.
        """
        return pulumi.get(self, "status_update_emails")

    @status_update_emails.setter
    def status_update_emails(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "status_update_emails", value)

    @property
    @pulumi.getter(name="useCases")
    def use_cases(self) -> Optional[pulumi.Input[str]]:
        """
        A JSON encoded list of use cases
        """
        return pulumi.get(self, "use_cases")

    @use_cases.setter
    def use_cases(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "use_cases", value)


class EdgeHostName(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate: Optional[pulumi.Input[int]] = None,
                 contract_id: Optional[pulumi.Input[str]] = None,
                 edge_hostname: Optional[pulumi.Input[str]] = None,
                 group_id: Optional[pulumi.Input[str]] = None,
                 ip_behavior: Optional[pulumi.Input[str]] = None,
                 product_id: Optional[pulumi.Input[str]] = None,
                 status_update_emails: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 use_cases: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a EdgeHostName resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] status_update_emails: Email address that should receive updates on the IP behavior update request. Required for update operation.
        :param pulumi.Input[str] use_cases: A JSON encoded list of use cases
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EdgeHostNameArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a EdgeHostName resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param EdgeHostNameArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EdgeHostNameArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate: Optional[pulumi.Input[int]] = None,
                 contract_id: Optional[pulumi.Input[str]] = None,
                 edge_hostname: Optional[pulumi.Input[str]] = None,
                 group_id: Optional[pulumi.Input[str]] = None,
                 ip_behavior: Optional[pulumi.Input[str]] = None,
                 product_id: Optional[pulumi.Input[str]] = None,
                 status_update_emails: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 use_cases: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EdgeHostNameArgs.__new__(EdgeHostNameArgs)

            __props__.__dict__["certificate"] = certificate
            if contract_id is None and not opts.urn:
                raise TypeError("Missing required property 'contract_id'")
            __props__.__dict__["contract_id"] = contract_id
            if edge_hostname is None and not opts.urn:
                raise TypeError("Missing required property 'edge_hostname'")
            __props__.__dict__["edge_hostname"] = edge_hostname
            if group_id is None and not opts.urn:
                raise TypeError("Missing required property 'group_id'")
            __props__.__dict__["group_id"] = group_id
            if ip_behavior is None and not opts.urn:
                raise TypeError("Missing required property 'ip_behavior'")
            __props__.__dict__["ip_behavior"] = ip_behavior
            __props__.__dict__["product_id"] = product_id
            __props__.__dict__["status_update_emails"] = status_update_emails
            __props__.__dict__["use_cases"] = use_cases
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="akamai:properties/edgeHostName:EdgeHostName")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(EdgeHostName, __self__).__init__(
            'akamai:index/edgeHostName:EdgeHostName',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            certificate: Optional[pulumi.Input[int]] = None,
            contract_id: Optional[pulumi.Input[str]] = None,
            edge_hostname: Optional[pulumi.Input[str]] = None,
            group_id: Optional[pulumi.Input[str]] = None,
            ip_behavior: Optional[pulumi.Input[str]] = None,
            product_id: Optional[pulumi.Input[str]] = None,
            status_update_emails: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            use_cases: Optional[pulumi.Input[str]] = None) -> 'EdgeHostName':
        """
        Get an existing EdgeHostName resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] status_update_emails: Email address that should receive updates on the IP behavior update request. Required for update operation.
        :param pulumi.Input[str] use_cases: A JSON encoded list of use cases
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EdgeHostNameState.__new__(_EdgeHostNameState)

        __props__.__dict__["certificate"] = certificate
        __props__.__dict__["contract_id"] = contract_id
        __props__.__dict__["edge_hostname"] = edge_hostname
        __props__.__dict__["group_id"] = group_id
        __props__.__dict__["ip_behavior"] = ip_behavior
        __props__.__dict__["product_id"] = product_id
        __props__.__dict__["status_update_emails"] = status_update_emails
        __props__.__dict__["use_cases"] = use_cases
        return EdgeHostName(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def certificate(self) -> pulumi.Output[Optional[int]]:
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter(name="contractId")
    def contract_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "contract_id")

    @property
    @pulumi.getter(name="edgeHostname")
    def edge_hostname(self) -> pulumi.Output[str]:
        return pulumi.get(self, "edge_hostname")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter(name="ipBehavior")
    def ip_behavior(self) -> pulumi.Output[str]:
        return pulumi.get(self, "ip_behavior")

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "product_id")

    @property
    @pulumi.getter(name="statusUpdateEmails")
    def status_update_emails(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Email address that should receive updates on the IP behavior update request. Required for update operation.
        """
        return pulumi.get(self, "status_update_emails")

    @property
    @pulumi.getter(name="useCases")
    def use_cases(self) -> pulumi.Output[Optional[str]]:
        """
        A JSON encoded list of use cases
        """
        return pulumi.get(self, "use_cases")

