# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EdgeKvArgs', 'EdgeKv']

@pulumi.input_type
class EdgeKvArgs:
    def __init__(__self__, *,
                 group_id: pulumi.Input[int],
                 namespace_name: pulumi.Input[str],
                 network: pulumi.Input[str],
                 retention_in_seconds: pulumi.Input[int],
                 geo_location: Optional[pulumi.Input[str]] = None,
                 initial_datas: Optional[pulumi.Input[Sequence[pulumi.Input['EdgeKvInitialDataArgs']]]] = None):
        """
        The set of arguments for constructing a EdgeKv resource.
        :param pulumi.Input[int] group_id: Namespace ACC group ID. It will be used in EdgeKV API v2. Not updatable.
        :param pulumi.Input[str] namespace_name: Name for the EKV namespace
        :param pulumi.Input[str] network: The network on which the namespace will be activated
        :param pulumi.Input[int] retention_in_seconds: Retention period for data in this namespace. An update of this value will just affect new EKV items.
        :param pulumi.Input[str] geo_location: Storage location for data
        :param pulumi.Input[Sequence[pulumi.Input['EdgeKvInitialDataArgs']]] initial_datas: List of pairs to initialize the namespace. Just meaningful for creation, updates will be ignored.
        """
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "namespace_name", namespace_name)
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "retention_in_seconds", retention_in_seconds)
        if geo_location is not None:
            pulumi.set(__self__, "geo_location", geo_location)
        if initial_datas is not None:
            warnings.warn("""The attribute 'initial_data' has been deprecated. To manage edgeKV items use 'akamai_edgekv_group_items' resource instead.""", DeprecationWarning)
            pulumi.log.warn("""initial_datas is deprecated: The attribute 'initial_data' has been deprecated. To manage edgeKV items use 'akamai_edgekv_group_items' resource instead.""")
        if initial_datas is not None:
            pulumi.set(__self__, "initial_datas", initial_datas)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Input[int]:
        """
        Namespace ACC group ID. It will be used in EdgeKV API v2. Not updatable.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: pulumi.Input[int]):
        pulumi.set(self, "group_id", value)

    @property
    @pulumi.getter(name="namespaceName")
    def namespace_name(self) -> pulumi.Input[str]:
        """
        Name for the EKV namespace
        """
        return pulumi.get(self, "namespace_name")

    @namespace_name.setter
    def namespace_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "namespace_name", value)

    @property
    @pulumi.getter
    def network(self) -> pulumi.Input[str]:
        """
        The network on which the namespace will be activated
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: pulumi.Input[str]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="retentionInSeconds")
    def retention_in_seconds(self) -> pulumi.Input[int]:
        """
        Retention period for data in this namespace. An update of this value will just affect new EKV items.
        """
        return pulumi.get(self, "retention_in_seconds")

    @retention_in_seconds.setter
    def retention_in_seconds(self, value: pulumi.Input[int]):
        pulumi.set(self, "retention_in_seconds", value)

    @property
    @pulumi.getter(name="geoLocation")
    def geo_location(self) -> Optional[pulumi.Input[str]]:
        """
        Storage location for data
        """
        return pulumi.get(self, "geo_location")

    @geo_location.setter
    def geo_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "geo_location", value)

    @property
    @pulumi.getter(name="initialDatas")
    def initial_datas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EdgeKvInitialDataArgs']]]]:
        """
        List of pairs to initialize the namespace. Just meaningful for creation, updates will be ignored.
        """
        warnings.warn("""The attribute 'initial_data' has been deprecated. To manage edgeKV items use 'akamai_edgekv_group_items' resource instead.""", DeprecationWarning)
        pulumi.log.warn("""initial_datas is deprecated: The attribute 'initial_data' has been deprecated. To manage edgeKV items use 'akamai_edgekv_group_items' resource instead.""")

        return pulumi.get(self, "initial_datas")

    @initial_datas.setter
    def initial_datas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EdgeKvInitialDataArgs']]]]):
        pulumi.set(self, "initial_datas", value)


@pulumi.input_type
class _EdgeKvState:
    def __init__(__self__, *,
                 geo_location: Optional[pulumi.Input[str]] = None,
                 group_id: Optional[pulumi.Input[int]] = None,
                 initial_datas: Optional[pulumi.Input[Sequence[pulumi.Input['EdgeKvInitialDataArgs']]]] = None,
                 namespace_name: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 retention_in_seconds: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering EdgeKv resources.
        :param pulumi.Input[str] geo_location: Storage location for data
        :param pulumi.Input[int] group_id: Namespace ACC group ID. It will be used in EdgeKV API v2. Not updatable.
        :param pulumi.Input[Sequence[pulumi.Input['EdgeKvInitialDataArgs']]] initial_datas: List of pairs to initialize the namespace. Just meaningful for creation, updates will be ignored.
        :param pulumi.Input[str] namespace_name: Name for the EKV namespace
        :param pulumi.Input[str] network: The network on which the namespace will be activated
        :param pulumi.Input[int] retention_in_seconds: Retention period for data in this namespace. An update of this value will just affect new EKV items.
        """
        if geo_location is not None:
            pulumi.set(__self__, "geo_location", geo_location)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if initial_datas is not None:
            warnings.warn("""The attribute 'initial_data' has been deprecated. To manage edgeKV items use 'akamai_edgekv_group_items' resource instead.""", DeprecationWarning)
            pulumi.log.warn("""initial_datas is deprecated: The attribute 'initial_data' has been deprecated. To manage edgeKV items use 'akamai_edgekv_group_items' resource instead.""")
        if initial_datas is not None:
            pulumi.set(__self__, "initial_datas", initial_datas)
        if namespace_name is not None:
            pulumi.set(__self__, "namespace_name", namespace_name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if retention_in_seconds is not None:
            pulumi.set(__self__, "retention_in_seconds", retention_in_seconds)

    @property
    @pulumi.getter(name="geoLocation")
    def geo_location(self) -> Optional[pulumi.Input[str]]:
        """
        Storage location for data
        """
        return pulumi.get(self, "geo_location")

    @geo_location.setter
    def geo_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "geo_location", value)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[int]]:
        """
        Namespace ACC group ID. It will be used in EdgeKV API v2. Not updatable.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "group_id", value)

    @property
    @pulumi.getter(name="initialDatas")
    def initial_datas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EdgeKvInitialDataArgs']]]]:
        """
        List of pairs to initialize the namespace. Just meaningful for creation, updates will be ignored.
        """
        warnings.warn("""The attribute 'initial_data' has been deprecated. To manage edgeKV items use 'akamai_edgekv_group_items' resource instead.""", DeprecationWarning)
        pulumi.log.warn("""initial_datas is deprecated: The attribute 'initial_data' has been deprecated. To manage edgeKV items use 'akamai_edgekv_group_items' resource instead.""")

        return pulumi.get(self, "initial_datas")

    @initial_datas.setter
    def initial_datas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EdgeKvInitialDataArgs']]]]):
        pulumi.set(self, "initial_datas", value)

    @property
    @pulumi.getter(name="namespaceName")
    def namespace_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name for the EKV namespace
        """
        return pulumi.get(self, "namespace_name")

    @namespace_name.setter
    def namespace_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace_name", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[str]]:
        """
        The network on which the namespace will be activated
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="retentionInSeconds")
    def retention_in_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Retention period for data in this namespace. An update of this value will just affect new EKV items.
        """
        return pulumi.get(self, "retention_in_seconds")

    @retention_in_seconds.setter
    def retention_in_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retention_in_seconds", value)


class EdgeKv(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 geo_location: Optional[pulumi.Input[str]] = None,
                 group_id: Optional[pulumi.Input[int]] = None,
                 initial_datas: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EdgeKvInitialDataArgs']]]]] = None,
                 namespace_name: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 retention_in_seconds: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Create a EdgeKv resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] geo_location: Storage location for data
        :param pulumi.Input[int] group_id: Namespace ACC group ID. It will be used in EdgeKV API v2. Not updatable.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EdgeKvInitialDataArgs']]]] initial_datas: List of pairs to initialize the namespace. Just meaningful for creation, updates will be ignored.
        :param pulumi.Input[str] namespace_name: Name for the EKV namespace
        :param pulumi.Input[str] network: The network on which the namespace will be activated
        :param pulumi.Input[int] retention_in_seconds: Retention period for data in this namespace. An update of this value will just affect new EKV items.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EdgeKvArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a EdgeKv resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param EdgeKvArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EdgeKvArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 geo_location: Optional[pulumi.Input[str]] = None,
                 group_id: Optional[pulumi.Input[int]] = None,
                 initial_datas: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EdgeKvInitialDataArgs']]]]] = None,
                 namespace_name: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 retention_in_seconds: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EdgeKvArgs.__new__(EdgeKvArgs)

            __props__.__dict__["geo_location"] = geo_location
            if group_id is None and not opts.urn:
                raise TypeError("Missing required property 'group_id'")
            __props__.__dict__["group_id"] = group_id
            if initial_datas is not None and not opts.urn:
                warnings.warn("""The attribute 'initial_data' has been deprecated. To manage edgeKV items use 'akamai_edgekv_group_items' resource instead.""", DeprecationWarning)
                pulumi.log.warn("""initial_datas is deprecated: The attribute 'initial_data' has been deprecated. To manage edgeKV items use 'akamai_edgekv_group_items' resource instead.""")
            __props__.__dict__["initial_datas"] = initial_datas
            if namespace_name is None and not opts.urn:
                raise TypeError("Missing required property 'namespace_name'")
            __props__.__dict__["namespace_name"] = namespace_name
            if network is None and not opts.urn:
                raise TypeError("Missing required property 'network'")
            __props__.__dict__["network"] = network
            if retention_in_seconds is None and not opts.urn:
                raise TypeError("Missing required property 'retention_in_seconds'")
            __props__.__dict__["retention_in_seconds"] = retention_in_seconds
        super(EdgeKv, __self__).__init__(
            'akamai:index/edgeKv:EdgeKv',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            geo_location: Optional[pulumi.Input[str]] = None,
            group_id: Optional[pulumi.Input[int]] = None,
            initial_datas: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EdgeKvInitialDataArgs']]]]] = None,
            namespace_name: Optional[pulumi.Input[str]] = None,
            network: Optional[pulumi.Input[str]] = None,
            retention_in_seconds: Optional[pulumi.Input[int]] = None) -> 'EdgeKv':
        """
        Get an existing EdgeKv resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] geo_location: Storage location for data
        :param pulumi.Input[int] group_id: Namespace ACC group ID. It will be used in EdgeKV API v2. Not updatable.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EdgeKvInitialDataArgs']]]] initial_datas: List of pairs to initialize the namespace. Just meaningful for creation, updates will be ignored.
        :param pulumi.Input[str] namespace_name: Name for the EKV namespace
        :param pulumi.Input[str] network: The network on which the namespace will be activated
        :param pulumi.Input[int] retention_in_seconds: Retention period for data in this namespace. An update of this value will just affect new EKV items.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EdgeKvState.__new__(_EdgeKvState)

        __props__.__dict__["geo_location"] = geo_location
        __props__.__dict__["group_id"] = group_id
        __props__.__dict__["initial_datas"] = initial_datas
        __props__.__dict__["namespace_name"] = namespace_name
        __props__.__dict__["network"] = network
        __props__.__dict__["retention_in_seconds"] = retention_in_seconds
        return EdgeKv(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="geoLocation")
    def geo_location(self) -> pulumi.Output[Optional[str]]:
        """
        Storage location for data
        """
        return pulumi.get(self, "geo_location")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Output[int]:
        """
        Namespace ACC group ID. It will be used in EdgeKV API v2. Not updatable.
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter(name="initialDatas")
    def initial_datas(self) -> pulumi.Output[Optional[Sequence['outputs.EdgeKvInitialData']]]:
        """
        List of pairs to initialize the namespace. Just meaningful for creation, updates will be ignored.
        """
        warnings.warn("""The attribute 'initial_data' has been deprecated. To manage edgeKV items use 'akamai_edgekv_group_items' resource instead.""", DeprecationWarning)
        pulumi.log.warn("""initial_datas is deprecated: The attribute 'initial_data' has been deprecated. To manage edgeKV items use 'akamai_edgekv_group_items' resource instead.""")

        return pulumi.get(self, "initial_datas")

    @property
    @pulumi.getter(name="namespaceName")
    def namespace_name(self) -> pulumi.Output[str]:
        """
        Name for the EKV namespace
        """
        return pulumi.get(self, "namespace_name")

    @property
    @pulumi.getter
    def network(self) -> pulumi.Output[str]:
        """
        The network on which the namespace will be activated
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="retentionInSeconds")
    def retention_in_seconds(self) -> pulumi.Output[int]:
        """
        Retention period for data in this namespace. An update of this value will just affect new EKV items.
        """
        return pulumi.get(self, "retention_in_seconds")

