# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['IamRoleArgs', 'IamRole']

@pulumi.input_type
class IamRoleArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[str],
                 granted_roles: pulumi.Input[Sequence[pulumi.Input[int]]],
                 name: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a IamRole resource.
        :param pulumi.Input[str] description: The description for a role
        :param pulumi.Input[Sequence[pulumi.Input[int]]] granted_roles: The list of existing unique identifiers for the granted roles
        :param pulumi.Input[str] name: The name you supply for a role
        :param pulumi.Input[str] type: The role type which indicates whether it's a standard role provided by Akamai or a custom role for the account
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "granted_roles", granted_roles)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[str]:
        """
        The description for a role
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="grantedRoles")
    def granted_roles(self) -> pulumi.Input[Sequence[pulumi.Input[int]]]:
        """
        The list of existing unique identifiers for the granted roles
        """
        return pulumi.get(self, "granted_roles")

    @granted_roles.setter
    def granted_roles(self, value: pulumi.Input[Sequence[pulumi.Input[int]]]):
        pulumi.set(self, "granted_roles", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name you supply for a role
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The role type which indicates whether it's a standard role provided by Akamai or a custom role for the account
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _IamRoleState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 granted_roles: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering IamRole resources.
        :param pulumi.Input[str] description: The description for a role
        :param pulumi.Input[Sequence[pulumi.Input[int]]] granted_roles: The list of existing unique identifiers for the granted roles
        :param pulumi.Input[str] name: The name you supply for a role
        :param pulumi.Input[str] type: The role type which indicates whether it's a standard role provided by Akamai or a custom role for the account
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if granted_roles is not None:
            pulumi.set(__self__, "granted_roles", granted_roles)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description for a role
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="grantedRoles")
    def granted_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        The list of existing unique identifiers for the granted roles
        """
        return pulumi.get(self, "granted_roles")

    @granted_roles.setter
    def granted_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "granted_roles", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name you supply for a role
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The role type which indicates whether it's a standard role provided by Akamai or a custom role for the account
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


class IamRole(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 granted_roles: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a IamRole resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description for a role
        :param pulumi.Input[Sequence[pulumi.Input[int]]] granted_roles: The list of existing unique identifiers for the granted roles
        :param pulumi.Input[str] name: The name you supply for a role
        :param pulumi.Input[str] type: The role type which indicates whether it's a standard role provided by Akamai or a custom role for the account
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IamRoleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a IamRole resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param IamRoleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IamRoleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 granted_roles: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IamRoleArgs.__new__(IamRoleArgs)

            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            if granted_roles is None and not opts.urn:
                raise TypeError("Missing required property 'granted_roles'")
            __props__.__dict__["granted_roles"] = granted_roles
            __props__.__dict__["name"] = name
            __props__.__dict__["type"] = type
        super(IamRole, __self__).__init__(
            'akamai:index/iamRole:IamRole',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            granted_roles: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None) -> 'IamRole':
        """
        Get an existing IamRole resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description for a role
        :param pulumi.Input[Sequence[pulumi.Input[int]]] granted_roles: The list of existing unique identifiers for the granted roles
        :param pulumi.Input[str] name: The name you supply for a role
        :param pulumi.Input[str] type: The role type which indicates whether it's a standard role provided by Akamai or a custom role for the account
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IamRoleState.__new__(_IamRoleState)

        __props__.__dict__["description"] = description
        __props__.__dict__["granted_roles"] = granted_roles
        __props__.__dict__["name"] = name
        __props__.__dict__["type"] = type
        return IamRole(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The description for a role
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="grantedRoles")
    def granted_roles(self) -> pulumi.Output[Sequence[int]]:
        """
        The list of existing unique identifiers for the granted roles
        """
        return pulumi.get(self, "granted_roles")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name you supply for a role
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The role type which indicates whether it's a standard role provided by Akamai or a custom role for the account
        """
        return pulumi.get(self, "type")

