# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['IamUserArgs', 'IamUser']

@pulumi.input_type
class IamUserArgs:
    def __init__(__self__, *,
                 auth_grants_json: pulumi.Input[str],
                 country: pulumi.Input[str],
                 email: pulumi.Input[str],
                 enable_tfa: pulumi.Input[bool],
                 first_name: pulumi.Input[str],
                 last_name: pulumi.Input[str],
                 phone: pulumi.Input[str],
                 address: Optional[pulumi.Input[str]] = None,
                 city: Optional[pulumi.Input[str]] = None,
                 contact_type: Optional[pulumi.Input[str]] = None,
                 job_title: Optional[pulumi.Input[str]] = None,
                 lock: Optional[pulumi.Input[bool]] = None,
                 mobile_phone: Optional[pulumi.Input[str]] = None,
                 preferred_language: Optional[pulumi.Input[str]] = None,
                 secondary_email: Optional[pulumi.Input[str]] = None,
                 session_timeout: Optional[pulumi.Input[int]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None,
                 zip_code: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a IamUser resource.
        :param pulumi.Input[str] auth_grants_json: A user's per-group role assignments, in JSON form
        :param pulumi.Input[str] country: As part of the user's location, the value can be any that are available from the view-supported-countries operation
        :param pulumi.Input[str] email: The user's email address
        :param pulumi.Input[bool] enable_tfa: Indicates whether two-factor authentication is allowed
        :param pulumi.Input[str] first_name: The user's first name
        :param pulumi.Input[str] last_name: The user's surname
        :param pulumi.Input[str] phone: The user's main phone number
        :param pulumi.Input[str] address: The user's street address
        :param pulumi.Input[str] city: The user's city
        :param pulumi.Input[str] contact_type: To help characterize the user, the value can be any that are available from the view-contact-types operation
        :param pulumi.Input[str] job_title: The user's position at your company
        :param pulumi.Input[bool] lock: Flag to block a user account
        :param pulumi.Input[str] mobile_phone: The user's mobile phone number
        :param pulumi.Input[str] preferred_language: The value can be any that are available from the view-languages operation
        :param pulumi.Input[str] secondary_email: The user's secondary email address
        :param pulumi.Input[int] session_timeout: The number of seconds it takes for the user's Control Center session to time out if there hasn't been any activity
        :param pulumi.Input[str] state: The user's state
        :param pulumi.Input[str] time_zone: The user's time zone. The value can be any that are available from the view-time-zones operation
        :param pulumi.Input[str] zip_code: The user's five-digit ZIP code
        """
        pulumi.set(__self__, "auth_grants_json", auth_grants_json)
        pulumi.set(__self__, "country", country)
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "enable_tfa", enable_tfa)
        pulumi.set(__self__, "first_name", first_name)
        pulumi.set(__self__, "last_name", last_name)
        pulumi.set(__self__, "phone", phone)
        if address is not None:
            pulumi.set(__self__, "address", address)
        if city is not None:
            pulumi.set(__self__, "city", city)
        if contact_type is not None:
            pulumi.set(__self__, "contact_type", contact_type)
        if job_title is not None:
            pulumi.set(__self__, "job_title", job_title)
        if lock is not None:
            pulumi.set(__self__, "lock", lock)
        if mobile_phone is not None:
            pulumi.set(__self__, "mobile_phone", mobile_phone)
        if preferred_language is not None:
            pulumi.set(__self__, "preferred_language", preferred_language)
        if secondary_email is not None:
            pulumi.set(__self__, "secondary_email", secondary_email)
        if session_timeout is not None:
            pulumi.set(__self__, "session_timeout", session_timeout)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if zip_code is not None:
            pulumi.set(__self__, "zip_code", zip_code)

    @property
    @pulumi.getter(name="authGrantsJson")
    def auth_grants_json(self) -> pulumi.Input[str]:
        """
        A user's per-group role assignments, in JSON form
        """
        return pulumi.get(self, "auth_grants_json")

    @auth_grants_json.setter
    def auth_grants_json(self, value: pulumi.Input[str]):
        pulumi.set(self, "auth_grants_json", value)

    @property
    @pulumi.getter
    def country(self) -> pulumi.Input[str]:
        """
        As part of the user's location, the value can be any that are available from the view-supported-countries operation
        """
        return pulumi.get(self, "country")

    @country.setter
    def country(self, value: pulumi.Input[str]):
        pulumi.set(self, "country", value)

    @property
    @pulumi.getter
    def email(self) -> pulumi.Input[str]:
        """
        The user's email address
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: pulumi.Input[str]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter(name="enableTfa")
    def enable_tfa(self) -> pulumi.Input[bool]:
        """
        Indicates whether two-factor authentication is allowed
        """
        return pulumi.get(self, "enable_tfa")

    @enable_tfa.setter
    def enable_tfa(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enable_tfa", value)

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> pulumi.Input[str]:
        """
        The user's first name
        """
        return pulumi.get(self, "first_name")

    @first_name.setter
    def first_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "first_name", value)

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> pulumi.Input[str]:
        """
        The user's surname
        """
        return pulumi.get(self, "last_name")

    @last_name.setter
    def last_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "last_name", value)

    @property
    @pulumi.getter
    def phone(self) -> pulumi.Input[str]:
        """
        The user's main phone number
        """
        return pulumi.get(self, "phone")

    @phone.setter
    def phone(self, value: pulumi.Input[str]):
        pulumi.set(self, "phone", value)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        """
        The user's street address
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def city(self) -> Optional[pulumi.Input[str]]:
        """
        The user's city
        """
        return pulumi.get(self, "city")

    @city.setter
    def city(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "city", value)

    @property
    @pulumi.getter(name="contactType")
    def contact_type(self) -> Optional[pulumi.Input[str]]:
        """
        To help characterize the user, the value can be any that are available from the view-contact-types operation
        """
        return pulumi.get(self, "contact_type")

    @contact_type.setter
    def contact_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "contact_type", value)

    @property
    @pulumi.getter(name="jobTitle")
    def job_title(self) -> Optional[pulumi.Input[str]]:
        """
        The user's position at your company
        """
        return pulumi.get(self, "job_title")

    @job_title.setter
    def job_title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "job_title", value)

    @property
    @pulumi.getter
    def lock(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to block a user account
        """
        return pulumi.get(self, "lock")

    @lock.setter
    def lock(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "lock", value)

    @property
    @pulumi.getter(name="mobilePhone")
    def mobile_phone(self) -> Optional[pulumi.Input[str]]:
        """
        The user's mobile phone number
        """
        return pulumi.get(self, "mobile_phone")

    @mobile_phone.setter
    def mobile_phone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mobile_phone", value)

    @property
    @pulumi.getter(name="preferredLanguage")
    def preferred_language(self) -> Optional[pulumi.Input[str]]:
        """
        The value can be any that are available from the view-languages operation
        """
        return pulumi.get(self, "preferred_language")

    @preferred_language.setter
    def preferred_language(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preferred_language", value)

    @property
    @pulumi.getter(name="secondaryEmail")
    def secondary_email(self) -> Optional[pulumi.Input[str]]:
        """
        The user's secondary email address
        """
        return pulumi.get(self, "secondary_email")

    @secondary_email.setter
    def secondary_email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secondary_email", value)

    @property
    @pulumi.getter(name="sessionTimeout")
    def session_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The number of seconds it takes for the user's Control Center session to time out if there hasn't been any activity
        """
        return pulumi.get(self, "session_timeout")

    @session_timeout.setter
    def session_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "session_timeout", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The user's state
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[str]]:
        """
        The user's time zone. The value can be any that are available from the view-time-zones operation
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_zone", value)

    @property
    @pulumi.getter(name="zipCode")
    def zip_code(self) -> Optional[pulumi.Input[str]]:
        """
        The user's five-digit ZIP code
        """
        return pulumi.get(self, "zip_code")

    @zip_code.setter
    def zip_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zip_code", value)


@pulumi.input_type
class _IamUserState:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[str]] = None,
                 auth_grants_json: Optional[pulumi.Input[str]] = None,
                 city: Optional[pulumi.Input[str]] = None,
                 contact_type: Optional[pulumi.Input[str]] = None,
                 country: Optional[pulumi.Input[str]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 email_update_pending: Optional[pulumi.Input[bool]] = None,
                 enable_tfa: Optional[pulumi.Input[bool]] = None,
                 first_name: Optional[pulumi.Input[str]] = None,
                 job_title: Optional[pulumi.Input[str]] = None,
                 last_login: Optional[pulumi.Input[str]] = None,
                 last_name: Optional[pulumi.Input[str]] = None,
                 lock: Optional[pulumi.Input[bool]] = None,
                 mobile_phone: Optional[pulumi.Input[str]] = None,
                 password_expired_after: Optional[pulumi.Input[str]] = None,
                 phone: Optional[pulumi.Input[str]] = None,
                 preferred_language: Optional[pulumi.Input[str]] = None,
                 secondary_email: Optional[pulumi.Input[str]] = None,
                 session_timeout: Optional[pulumi.Input[int]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 tfa_configured: Optional[pulumi.Input[bool]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None,
                 user_name: Optional[pulumi.Input[str]] = None,
                 zip_code: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering IamUser resources.
        :param pulumi.Input[str] address: The user's street address
        :param pulumi.Input[str] auth_grants_json: A user's per-group role assignments, in JSON form
        :param pulumi.Input[str] city: The user's city
        :param pulumi.Input[str] contact_type: To help characterize the user, the value can be any that are available from the view-contact-types operation
        :param pulumi.Input[str] country: As part of the user's location, the value can be any that are available from the view-supported-countries operation
        :param pulumi.Input[str] email: The user's email address
        :param pulumi.Input[bool] email_update_pending: Indicates whether email update is pending
        :param pulumi.Input[bool] enable_tfa: Indicates whether two-factor authentication is allowed
        :param pulumi.Input[str] first_name: The user's first name
        :param pulumi.Input[str] job_title: The user's position at your company
        :param pulumi.Input[str] last_login: ISO 8601 timestamp indicating when the user last logged in
        :param pulumi.Input[str] last_name: The user's surname
        :param pulumi.Input[bool] lock: Flag to block a user account
        :param pulumi.Input[str] mobile_phone: The user's mobile phone number
        :param pulumi.Input[str] password_expired_after: The date a user's password expires
        :param pulumi.Input[str] phone: The user's main phone number
        :param pulumi.Input[str] preferred_language: The value can be any that are available from the view-languages operation
        :param pulumi.Input[str] secondary_email: The user's secondary email address
        :param pulumi.Input[int] session_timeout: The number of seconds it takes for the user's Control Center session to time out if there hasn't been any activity
        :param pulumi.Input[str] state: The user's state
        :param pulumi.Input[bool] tfa_configured: Indicates whether two-factor authentication is configured
        :param pulumi.Input[str] time_zone: The user's time zone. The value can be any that are available from the view-time-zones operation
        :param pulumi.Input[str] user_name: A user's `loginId`. Typically, a user's email address
        :param pulumi.Input[str] zip_code: The user's five-digit ZIP code
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if auth_grants_json is not None:
            pulumi.set(__self__, "auth_grants_json", auth_grants_json)
        if city is not None:
            pulumi.set(__self__, "city", city)
        if contact_type is not None:
            pulumi.set(__self__, "contact_type", contact_type)
        if country is not None:
            pulumi.set(__self__, "country", country)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if email_update_pending is not None:
            pulumi.set(__self__, "email_update_pending", email_update_pending)
        if enable_tfa is not None:
            pulumi.set(__self__, "enable_tfa", enable_tfa)
        if first_name is not None:
            pulumi.set(__self__, "first_name", first_name)
        if job_title is not None:
            pulumi.set(__self__, "job_title", job_title)
        if last_login is not None:
            pulumi.set(__self__, "last_login", last_login)
        if last_name is not None:
            pulumi.set(__self__, "last_name", last_name)
        if lock is not None:
            pulumi.set(__self__, "lock", lock)
        if mobile_phone is not None:
            pulumi.set(__self__, "mobile_phone", mobile_phone)
        if password_expired_after is not None:
            pulumi.set(__self__, "password_expired_after", password_expired_after)
        if phone is not None:
            pulumi.set(__self__, "phone", phone)
        if preferred_language is not None:
            pulumi.set(__self__, "preferred_language", preferred_language)
        if secondary_email is not None:
            pulumi.set(__self__, "secondary_email", secondary_email)
        if session_timeout is not None:
            pulumi.set(__self__, "session_timeout", session_timeout)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if tfa_configured is not None:
            pulumi.set(__self__, "tfa_configured", tfa_configured)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)
        if zip_code is not None:
            pulumi.set(__self__, "zip_code", zip_code)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        """
        The user's street address
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter(name="authGrantsJson")
    def auth_grants_json(self) -> Optional[pulumi.Input[str]]:
        """
        A user's per-group role assignments, in JSON form
        """
        return pulumi.get(self, "auth_grants_json")

    @auth_grants_json.setter
    def auth_grants_json(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auth_grants_json", value)

    @property
    @pulumi.getter
    def city(self) -> Optional[pulumi.Input[str]]:
        """
        The user's city
        """
        return pulumi.get(self, "city")

    @city.setter
    def city(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "city", value)

    @property
    @pulumi.getter(name="contactType")
    def contact_type(self) -> Optional[pulumi.Input[str]]:
        """
        To help characterize the user, the value can be any that are available from the view-contact-types operation
        """
        return pulumi.get(self, "contact_type")

    @contact_type.setter
    def contact_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "contact_type", value)

    @property
    @pulumi.getter
    def country(self) -> Optional[pulumi.Input[str]]:
        """
        As part of the user's location, the value can be any that are available from the view-supported-countries operation
        """
        return pulumi.get(self, "country")

    @country.setter
    def country(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "country", value)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[str]]:
        """
        The user's email address
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter(name="emailUpdatePending")
    def email_update_pending(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether email update is pending
        """
        return pulumi.get(self, "email_update_pending")

    @email_update_pending.setter
    def email_update_pending(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "email_update_pending", value)

    @property
    @pulumi.getter(name="enableTfa")
    def enable_tfa(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether two-factor authentication is allowed
        """
        return pulumi.get(self, "enable_tfa")

    @enable_tfa.setter
    def enable_tfa(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_tfa", value)

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> Optional[pulumi.Input[str]]:
        """
        The user's first name
        """
        return pulumi.get(self, "first_name")

    @first_name.setter
    def first_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "first_name", value)

    @property
    @pulumi.getter(name="jobTitle")
    def job_title(self) -> Optional[pulumi.Input[str]]:
        """
        The user's position at your company
        """
        return pulumi.get(self, "job_title")

    @job_title.setter
    def job_title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "job_title", value)

    @property
    @pulumi.getter(name="lastLogin")
    def last_login(self) -> Optional[pulumi.Input[str]]:
        """
        ISO 8601 timestamp indicating when the user last logged in
        """
        return pulumi.get(self, "last_login")

    @last_login.setter
    def last_login(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_login", value)

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> Optional[pulumi.Input[str]]:
        """
        The user's surname
        """
        return pulumi.get(self, "last_name")

    @last_name.setter
    def last_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_name", value)

    @property
    @pulumi.getter
    def lock(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to block a user account
        """
        return pulumi.get(self, "lock")

    @lock.setter
    def lock(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "lock", value)

    @property
    @pulumi.getter(name="mobilePhone")
    def mobile_phone(self) -> Optional[pulumi.Input[str]]:
        """
        The user's mobile phone number
        """
        return pulumi.get(self, "mobile_phone")

    @mobile_phone.setter
    def mobile_phone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mobile_phone", value)

    @property
    @pulumi.getter(name="passwordExpiredAfter")
    def password_expired_after(self) -> Optional[pulumi.Input[str]]:
        """
        The date a user's password expires
        """
        return pulumi.get(self, "password_expired_after")

    @password_expired_after.setter
    def password_expired_after(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password_expired_after", value)

    @property
    @pulumi.getter
    def phone(self) -> Optional[pulumi.Input[str]]:
        """
        The user's main phone number
        """
        return pulumi.get(self, "phone")

    @phone.setter
    def phone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "phone", value)

    @property
    @pulumi.getter(name="preferredLanguage")
    def preferred_language(self) -> Optional[pulumi.Input[str]]:
        """
        The value can be any that are available from the view-languages operation
        """
        return pulumi.get(self, "preferred_language")

    @preferred_language.setter
    def preferred_language(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preferred_language", value)

    @property
    @pulumi.getter(name="secondaryEmail")
    def secondary_email(self) -> Optional[pulumi.Input[str]]:
        """
        The user's secondary email address
        """
        return pulumi.get(self, "secondary_email")

    @secondary_email.setter
    def secondary_email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secondary_email", value)

    @property
    @pulumi.getter(name="sessionTimeout")
    def session_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The number of seconds it takes for the user's Control Center session to time out if there hasn't been any activity
        """
        return pulumi.get(self, "session_timeout")

    @session_timeout.setter
    def session_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "session_timeout", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The user's state
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="tfaConfigured")
    def tfa_configured(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether two-factor authentication is configured
        """
        return pulumi.get(self, "tfa_configured")

    @tfa_configured.setter
    def tfa_configured(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "tfa_configured", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[str]]:
        """
        The user's time zone. The value can be any that are available from the view-time-zones operation
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_zone", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[str]]:
        """
        A user's `loginId`. Typically, a user's email address
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name", value)

    @property
    @pulumi.getter(name="zipCode")
    def zip_code(self) -> Optional[pulumi.Input[str]]:
        """
        The user's five-digit ZIP code
        """
        return pulumi.get(self, "zip_code")

    @zip_code.setter
    def zip_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zip_code", value)


class IamUser(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address: Optional[pulumi.Input[str]] = None,
                 auth_grants_json: Optional[pulumi.Input[str]] = None,
                 city: Optional[pulumi.Input[str]] = None,
                 contact_type: Optional[pulumi.Input[str]] = None,
                 country: Optional[pulumi.Input[str]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 enable_tfa: Optional[pulumi.Input[bool]] = None,
                 first_name: Optional[pulumi.Input[str]] = None,
                 job_title: Optional[pulumi.Input[str]] = None,
                 last_name: Optional[pulumi.Input[str]] = None,
                 lock: Optional[pulumi.Input[bool]] = None,
                 mobile_phone: Optional[pulumi.Input[str]] = None,
                 phone: Optional[pulumi.Input[str]] = None,
                 preferred_language: Optional[pulumi.Input[str]] = None,
                 secondary_email: Optional[pulumi.Input[str]] = None,
                 session_timeout: Optional[pulumi.Input[int]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None,
                 zip_code: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a IamUser resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] address: The user's street address
        :param pulumi.Input[str] auth_grants_json: A user's per-group role assignments, in JSON form
        :param pulumi.Input[str] city: The user's city
        :param pulumi.Input[str] contact_type: To help characterize the user, the value can be any that are available from the view-contact-types operation
        :param pulumi.Input[str] country: As part of the user's location, the value can be any that are available from the view-supported-countries operation
        :param pulumi.Input[str] email: The user's email address
        :param pulumi.Input[bool] enable_tfa: Indicates whether two-factor authentication is allowed
        :param pulumi.Input[str] first_name: The user's first name
        :param pulumi.Input[str] job_title: The user's position at your company
        :param pulumi.Input[str] last_name: The user's surname
        :param pulumi.Input[bool] lock: Flag to block a user account
        :param pulumi.Input[str] mobile_phone: The user's mobile phone number
        :param pulumi.Input[str] phone: The user's main phone number
        :param pulumi.Input[str] preferred_language: The value can be any that are available from the view-languages operation
        :param pulumi.Input[str] secondary_email: The user's secondary email address
        :param pulumi.Input[int] session_timeout: The number of seconds it takes for the user's Control Center session to time out if there hasn't been any activity
        :param pulumi.Input[str] state: The user's state
        :param pulumi.Input[str] time_zone: The user's time zone. The value can be any that are available from the view-time-zones operation
        :param pulumi.Input[str] zip_code: The user's five-digit ZIP code
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IamUserArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a IamUser resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param IamUserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IamUserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address: Optional[pulumi.Input[str]] = None,
                 auth_grants_json: Optional[pulumi.Input[str]] = None,
                 city: Optional[pulumi.Input[str]] = None,
                 contact_type: Optional[pulumi.Input[str]] = None,
                 country: Optional[pulumi.Input[str]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 enable_tfa: Optional[pulumi.Input[bool]] = None,
                 first_name: Optional[pulumi.Input[str]] = None,
                 job_title: Optional[pulumi.Input[str]] = None,
                 last_name: Optional[pulumi.Input[str]] = None,
                 lock: Optional[pulumi.Input[bool]] = None,
                 mobile_phone: Optional[pulumi.Input[str]] = None,
                 phone: Optional[pulumi.Input[str]] = None,
                 preferred_language: Optional[pulumi.Input[str]] = None,
                 secondary_email: Optional[pulumi.Input[str]] = None,
                 session_timeout: Optional[pulumi.Input[int]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None,
                 zip_code: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IamUserArgs.__new__(IamUserArgs)

            __props__.__dict__["address"] = address
            if auth_grants_json is None and not opts.urn:
                raise TypeError("Missing required property 'auth_grants_json'")
            __props__.__dict__["auth_grants_json"] = auth_grants_json
            __props__.__dict__["city"] = city
            __props__.__dict__["contact_type"] = contact_type
            if country is None and not opts.urn:
                raise TypeError("Missing required property 'country'")
            __props__.__dict__["country"] = country
            if email is None and not opts.urn:
                raise TypeError("Missing required property 'email'")
            __props__.__dict__["email"] = email
            if enable_tfa is None and not opts.urn:
                raise TypeError("Missing required property 'enable_tfa'")
            __props__.__dict__["enable_tfa"] = enable_tfa
            if first_name is None and not opts.urn:
                raise TypeError("Missing required property 'first_name'")
            __props__.__dict__["first_name"] = first_name
            __props__.__dict__["job_title"] = job_title
            if last_name is None and not opts.urn:
                raise TypeError("Missing required property 'last_name'")
            __props__.__dict__["last_name"] = last_name
            __props__.__dict__["lock"] = lock
            __props__.__dict__["mobile_phone"] = mobile_phone
            if phone is None and not opts.urn:
                raise TypeError("Missing required property 'phone'")
            __props__.__dict__["phone"] = phone
            __props__.__dict__["preferred_language"] = preferred_language
            __props__.__dict__["secondary_email"] = secondary_email
            __props__.__dict__["session_timeout"] = session_timeout
            __props__.__dict__["state"] = state
            __props__.__dict__["time_zone"] = time_zone
            __props__.__dict__["zip_code"] = zip_code
            __props__.__dict__["email_update_pending"] = None
            __props__.__dict__["last_login"] = None
            __props__.__dict__["password_expired_after"] = None
            __props__.__dict__["tfa_configured"] = None
            __props__.__dict__["user_name"] = None
        super(IamUser, __self__).__init__(
            'akamai:index/iamUser:IamUser',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            address: Optional[pulumi.Input[str]] = None,
            auth_grants_json: Optional[pulumi.Input[str]] = None,
            city: Optional[pulumi.Input[str]] = None,
            contact_type: Optional[pulumi.Input[str]] = None,
            country: Optional[pulumi.Input[str]] = None,
            email: Optional[pulumi.Input[str]] = None,
            email_update_pending: Optional[pulumi.Input[bool]] = None,
            enable_tfa: Optional[pulumi.Input[bool]] = None,
            first_name: Optional[pulumi.Input[str]] = None,
            job_title: Optional[pulumi.Input[str]] = None,
            last_login: Optional[pulumi.Input[str]] = None,
            last_name: Optional[pulumi.Input[str]] = None,
            lock: Optional[pulumi.Input[bool]] = None,
            mobile_phone: Optional[pulumi.Input[str]] = None,
            password_expired_after: Optional[pulumi.Input[str]] = None,
            phone: Optional[pulumi.Input[str]] = None,
            preferred_language: Optional[pulumi.Input[str]] = None,
            secondary_email: Optional[pulumi.Input[str]] = None,
            session_timeout: Optional[pulumi.Input[int]] = None,
            state: Optional[pulumi.Input[str]] = None,
            tfa_configured: Optional[pulumi.Input[bool]] = None,
            time_zone: Optional[pulumi.Input[str]] = None,
            user_name: Optional[pulumi.Input[str]] = None,
            zip_code: Optional[pulumi.Input[str]] = None) -> 'IamUser':
        """
        Get an existing IamUser resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] address: The user's street address
        :param pulumi.Input[str] auth_grants_json: A user's per-group role assignments, in JSON form
        :param pulumi.Input[str] city: The user's city
        :param pulumi.Input[str] contact_type: To help characterize the user, the value can be any that are available from the view-contact-types operation
        :param pulumi.Input[str] country: As part of the user's location, the value can be any that are available from the view-supported-countries operation
        :param pulumi.Input[str] email: The user's email address
        :param pulumi.Input[bool] email_update_pending: Indicates whether email update is pending
        :param pulumi.Input[bool] enable_tfa: Indicates whether two-factor authentication is allowed
        :param pulumi.Input[str] first_name: The user's first name
        :param pulumi.Input[str] job_title: The user's position at your company
        :param pulumi.Input[str] last_login: ISO 8601 timestamp indicating when the user last logged in
        :param pulumi.Input[str] last_name: The user's surname
        :param pulumi.Input[bool] lock: Flag to block a user account
        :param pulumi.Input[str] mobile_phone: The user's mobile phone number
        :param pulumi.Input[str] password_expired_after: The date a user's password expires
        :param pulumi.Input[str] phone: The user's main phone number
        :param pulumi.Input[str] preferred_language: The value can be any that are available from the view-languages operation
        :param pulumi.Input[str] secondary_email: The user's secondary email address
        :param pulumi.Input[int] session_timeout: The number of seconds it takes for the user's Control Center session to time out if there hasn't been any activity
        :param pulumi.Input[str] state: The user's state
        :param pulumi.Input[bool] tfa_configured: Indicates whether two-factor authentication is configured
        :param pulumi.Input[str] time_zone: The user's time zone. The value can be any that are available from the view-time-zones operation
        :param pulumi.Input[str] user_name: A user's `loginId`. Typically, a user's email address
        :param pulumi.Input[str] zip_code: The user's five-digit ZIP code
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IamUserState.__new__(_IamUserState)

        __props__.__dict__["address"] = address
        __props__.__dict__["auth_grants_json"] = auth_grants_json
        __props__.__dict__["city"] = city
        __props__.__dict__["contact_type"] = contact_type
        __props__.__dict__["country"] = country
        __props__.__dict__["email"] = email
        __props__.__dict__["email_update_pending"] = email_update_pending
        __props__.__dict__["enable_tfa"] = enable_tfa
        __props__.__dict__["first_name"] = first_name
        __props__.__dict__["job_title"] = job_title
        __props__.__dict__["last_login"] = last_login
        __props__.__dict__["last_name"] = last_name
        __props__.__dict__["lock"] = lock
        __props__.__dict__["mobile_phone"] = mobile_phone
        __props__.__dict__["password_expired_after"] = password_expired_after
        __props__.__dict__["phone"] = phone
        __props__.__dict__["preferred_language"] = preferred_language
        __props__.__dict__["secondary_email"] = secondary_email
        __props__.__dict__["session_timeout"] = session_timeout
        __props__.__dict__["state"] = state
        __props__.__dict__["tfa_configured"] = tfa_configured
        __props__.__dict__["time_zone"] = time_zone
        __props__.__dict__["user_name"] = user_name
        __props__.__dict__["zip_code"] = zip_code
        return IamUser(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def address(self) -> pulumi.Output[str]:
        """
        The user's street address
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="authGrantsJson")
    def auth_grants_json(self) -> pulumi.Output[str]:
        """
        A user's per-group role assignments, in JSON form
        """
        return pulumi.get(self, "auth_grants_json")

    @property
    @pulumi.getter
    def city(self) -> pulumi.Output[Optional[str]]:
        """
        The user's city
        """
        return pulumi.get(self, "city")

    @property
    @pulumi.getter(name="contactType")
    def contact_type(self) -> pulumi.Output[str]:
        """
        To help characterize the user, the value can be any that are available from the view-contact-types operation
        """
        return pulumi.get(self, "contact_type")

    @property
    @pulumi.getter
    def country(self) -> pulumi.Output[str]:
        """
        As part of the user's location, the value can be any that are available from the view-supported-countries operation
        """
        return pulumi.get(self, "country")

    @property
    @pulumi.getter
    def email(self) -> pulumi.Output[str]:
        """
        The user's email address
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="emailUpdatePending")
    def email_update_pending(self) -> pulumi.Output[bool]:
        """
        Indicates whether email update is pending
        """
        return pulumi.get(self, "email_update_pending")

    @property
    @pulumi.getter(name="enableTfa")
    def enable_tfa(self) -> pulumi.Output[bool]:
        """
        Indicates whether two-factor authentication is allowed
        """
        return pulumi.get(self, "enable_tfa")

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> pulumi.Output[str]:
        """
        The user's first name
        """
        return pulumi.get(self, "first_name")

    @property
    @pulumi.getter(name="jobTitle")
    def job_title(self) -> pulumi.Output[Optional[str]]:
        """
        The user's position at your company
        """
        return pulumi.get(self, "job_title")

    @property
    @pulumi.getter(name="lastLogin")
    def last_login(self) -> pulumi.Output[str]:
        """
        ISO 8601 timestamp indicating when the user last logged in
        """
        return pulumi.get(self, "last_login")

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> pulumi.Output[str]:
        """
        The user's surname
        """
        return pulumi.get(self, "last_name")

    @property
    @pulumi.getter
    def lock(self) -> pulumi.Output[Optional[bool]]:
        """
        Flag to block a user account
        """
        return pulumi.get(self, "lock")

    @property
    @pulumi.getter(name="mobilePhone")
    def mobile_phone(self) -> pulumi.Output[Optional[str]]:
        """
        The user's mobile phone number
        """
        return pulumi.get(self, "mobile_phone")

    @property
    @pulumi.getter(name="passwordExpiredAfter")
    def password_expired_after(self) -> pulumi.Output[str]:
        """
        The date a user's password expires
        """
        return pulumi.get(self, "password_expired_after")

    @property
    @pulumi.getter
    def phone(self) -> pulumi.Output[str]:
        """
        The user's main phone number
        """
        return pulumi.get(self, "phone")

    @property
    @pulumi.getter(name="preferredLanguage")
    def preferred_language(self) -> pulumi.Output[str]:
        """
        The value can be any that are available from the view-languages operation
        """
        return pulumi.get(self, "preferred_language")

    @property
    @pulumi.getter(name="secondaryEmail")
    def secondary_email(self) -> pulumi.Output[Optional[str]]:
        """
        The user's secondary email address
        """
        return pulumi.get(self, "secondary_email")

    @property
    @pulumi.getter(name="sessionTimeout")
    def session_timeout(self) -> pulumi.Output[int]:
        """
        The number of seconds it takes for the user's Control Center session to time out if there hasn't been any activity
        """
        return pulumi.get(self, "session_timeout")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[Optional[str]]:
        """
        The user's state
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="tfaConfigured")
    def tfa_configured(self) -> pulumi.Output[bool]:
        """
        Indicates whether two-factor authentication is configured
        """
        return pulumi.get(self, "tfa_configured")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Output[str]:
        """
        The user's time zone. The value can be any that are available from the view-time-zones operation
        """
        return pulumi.get(self, "time_zone")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Output[str]:
        """
        A user's `loginId`. Typically, a user's email address
        """
        return pulumi.get(self, "user_name")

    @property
    @pulumi.getter(name="zipCode")
    def zip_code(self) -> pulumi.Output[Optional[str]]:
        """
        The user's five-digit ZIP code
        """
        return pulumi.get(self, "zip_code")

