# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['ImagingPolicySetArgs', 'ImagingPolicySet']

@pulumi.input_type
class ImagingPolicySetArgs:
    def __init__(__self__, *,
                 contract_id: pulumi.Input[str],
                 region: pulumi.Input[str],
                 type: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ImagingPolicySet resource.
        :param pulumi.Input[str] contract_id: The unique identifier for the Akamai Contract containing the Policy Set(s)
        :param pulumi.Input[str] region: The geographic region which media using this Policy Set is optimized for
        :param pulumi.Input[str] type: The type of media this Policy Set manages
        :param pulumi.Input[str] name: A friendly name for the Policy Set
        """
        pulumi.set(__self__, "contract_id", contract_id)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "type", type)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="contractId")
    def contract_id(self) -> pulumi.Input[str]:
        """
        The unique identifier for the Akamai Contract containing the Policy Set(s)
        """
        return pulumi.get(self, "contract_id")

    @contract_id.setter
    def contract_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "contract_id", value)

    @property
    @pulumi.getter
    def region(self) -> pulumi.Input[str]:
        """
        The geographic region which media using this Policy Set is optimized for
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[str]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of media this Policy Set manages
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A friendly name for the Policy Set
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _ImagingPolicySetState:
    def __init__(__self__, *,
                 contract_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ImagingPolicySet resources.
        :param pulumi.Input[str] contract_id: The unique identifier for the Akamai Contract containing the Policy Set(s)
        :param pulumi.Input[str] name: A friendly name for the Policy Set
        :param pulumi.Input[str] region: The geographic region which media using this Policy Set is optimized for
        :param pulumi.Input[str] type: The type of media this Policy Set manages
        """
        if contract_id is not None:
            pulumi.set(__self__, "contract_id", contract_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="contractId")
    def contract_id(self) -> Optional[pulumi.Input[str]]:
        """
        The unique identifier for the Akamai Contract containing the Policy Set(s)
        """
        return pulumi.get(self, "contract_id")

    @contract_id.setter
    def contract_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "contract_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A friendly name for the Policy Set
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The geographic region which media using this Policy Set is optimized for
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of media this Policy Set manages
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


class ImagingPolicySet(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 contract_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a ImagingPolicySet resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] contract_id: The unique identifier for the Akamai Contract containing the Policy Set(s)
        :param pulumi.Input[str] name: A friendly name for the Policy Set
        :param pulumi.Input[str] region: The geographic region which media using this Policy Set is optimized for
        :param pulumi.Input[str] type: The type of media this Policy Set manages
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ImagingPolicySetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a ImagingPolicySet resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param ImagingPolicySetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ImagingPolicySetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 contract_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ImagingPolicySetArgs.__new__(ImagingPolicySetArgs)

            if contract_id is None and not opts.urn:
                raise TypeError("Missing required property 'contract_id'")
            __props__.__dict__["contract_id"] = contract_id
            __props__.__dict__["name"] = name
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
        super(ImagingPolicySet, __self__).__init__(
            'akamai:index/imagingPolicySet:ImagingPolicySet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            contract_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None) -> 'ImagingPolicySet':
        """
        Get an existing ImagingPolicySet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] contract_id: The unique identifier for the Akamai Contract containing the Policy Set(s)
        :param pulumi.Input[str] name: A friendly name for the Policy Set
        :param pulumi.Input[str] region: The geographic region which media using this Policy Set is optimized for
        :param pulumi.Input[str] type: The type of media this Policy Set manages
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ImagingPolicySetState.__new__(_ImagingPolicySetState)

        __props__.__dict__["contract_id"] = contract_id
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["type"] = type
        return ImagingPolicySet(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="contractId")
    def contract_id(self) -> pulumi.Output[str]:
        """
        The unique identifier for the Akamai Contract containing the Policy Set(s)
        """
        return pulumi.get(self, "contract_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        A friendly name for the Policy Set
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The geographic region which media using this Policy Set is optimized for
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of media this Policy Set manages
        """
        return pulumi.get(self, "type")

