# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['NetworkListArgs', 'NetworkList']

@pulumi.input_type
class NetworkListArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[str],
                 mode: pulumi.Input[str],
                 type: pulumi.Input[str],
                 contract_id: Optional[pulumi.Input[str]] = None,
                 group_id: Optional[pulumi.Input[int]] = None,
                 lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a NetworkList resource.
        :param pulumi.Input[str] description: A description of the network list
        :param pulumi.Input[str] mode: A string specifying the interpretation of the `list` parameter. Must be 'APPEND', 'REPLACE', or 'REMOVE'
        :param pulumi.Input[str] type: The type of the network list; must be either 'IP' or 'GEO'
        :param pulumi.Input[str] contract_id: contract ID
        :param pulumi.Input[int] group_id: group ID
        :param pulumi.Input[Sequence[pulumi.Input[str]]] lists: A list of IP addresses or locations to be included in the list, added to an existing list, or removed from an existing
               list
        :param pulumi.Input[str] name: The name to be assigned to the network list
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "type", type)
        if contract_id is not None:
            pulumi.set(__self__, "contract_id", contract_id)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if lists is not None:
            pulumi.set(__self__, "lists", lists)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[str]:
        """
        A description of the network list
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def mode(self) -> pulumi.Input[str]:
        """
        A string specifying the interpretation of the `list` parameter. Must be 'APPEND', 'REPLACE', or 'REMOVE'
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: pulumi.Input[str]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of the network list; must be either 'IP' or 'GEO'
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="contractId")
    def contract_id(self) -> Optional[pulumi.Input[str]]:
        """
        contract ID
        """
        return pulumi.get(self, "contract_id")

    @contract_id.setter
    def contract_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "contract_id", value)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[int]]:
        """
        group ID
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "group_id", value)

    @property
    @pulumi.getter
    def lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of IP addresses or locations to be included in the list, added to an existing list, or removed from an existing
        list
        """
        return pulumi.get(self, "lists")

    @lists.setter
    def lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "lists", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name to be assigned to the network list
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _NetworkListState:
    def __init__(__self__, *,
                 contract_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 group_id: Optional[pulumi.Input[int]] = None,
                 lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 mode: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_list_id: Optional[pulumi.Input[str]] = None,
                 sync_point: Optional[pulumi.Input[int]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 uniqueid: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering NetworkList resources.
        :param pulumi.Input[str] contract_id: contract ID
        :param pulumi.Input[str] description: A description of the network list
        :param pulumi.Input[int] group_id: group ID
        :param pulumi.Input[Sequence[pulumi.Input[str]]] lists: A list of IP addresses or locations to be included in the list, added to an existing list, or removed from an existing
               list
        :param pulumi.Input[str] mode: A string specifying the interpretation of the `list` parameter. Must be 'APPEND', 'REPLACE', or 'REMOVE'
        :param pulumi.Input[str] name: The name to be assigned to the network list
        :param pulumi.Input[str] network_list_id: network list ID
        :param pulumi.Input[int] sync_point: sync point
        :param pulumi.Input[str] type: The type of the network list; must be either 'IP' or 'GEO'
        :param pulumi.Input[str] uniqueid: unique ID
        """
        if contract_id is not None:
            pulumi.set(__self__, "contract_id", contract_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if lists is not None:
            pulumi.set(__self__, "lists", lists)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_list_id is not None:
            pulumi.set(__self__, "network_list_id", network_list_id)
        if sync_point is not None:
            pulumi.set(__self__, "sync_point", sync_point)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if uniqueid is not None:
            pulumi.set(__self__, "uniqueid", uniqueid)

    @property
    @pulumi.getter(name="contractId")
    def contract_id(self) -> Optional[pulumi.Input[str]]:
        """
        contract ID
        """
        return pulumi.get(self, "contract_id")

    @contract_id.setter
    def contract_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "contract_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description of the network list
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[int]]:
        """
        group ID
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "group_id", value)

    @property
    @pulumi.getter
    def lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of IP addresses or locations to be included in the list, added to an existing list, or removed from an existing
        list
        """
        return pulumi.get(self, "lists")

    @lists.setter
    def lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "lists", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[str]]:
        """
        A string specifying the interpretation of the `list` parameter. Must be 'APPEND', 'REPLACE', or 'REMOVE'
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name to be assigned to the network list
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkListId")
    def network_list_id(self) -> Optional[pulumi.Input[str]]:
        """
        network list ID
        """
        return pulumi.get(self, "network_list_id")

    @network_list_id.setter
    def network_list_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_list_id", value)

    @property
    @pulumi.getter(name="syncPoint")
    def sync_point(self) -> Optional[pulumi.Input[int]]:
        """
        sync point
        """
        return pulumi.get(self, "sync_point")

    @sync_point.setter
    def sync_point(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "sync_point", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the network list; must be either 'IP' or 'GEO'
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def uniqueid(self) -> Optional[pulumi.Input[str]]:
        """
        unique ID
        """
        return pulumi.get(self, "uniqueid")

    @uniqueid.setter
    def uniqueid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uniqueid", value)


class NetworkList(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 contract_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 group_id: Optional[pulumi.Input[int]] = None,
                 lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 mode: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a NetworkList resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] contract_id: contract ID
        :param pulumi.Input[str] description: A description of the network list
        :param pulumi.Input[int] group_id: group ID
        :param pulumi.Input[Sequence[pulumi.Input[str]]] lists: A list of IP addresses or locations to be included in the list, added to an existing list, or removed from an existing
               list
        :param pulumi.Input[str] mode: A string specifying the interpretation of the `list` parameter. Must be 'APPEND', 'REPLACE', or 'REMOVE'
        :param pulumi.Input[str] name: The name to be assigned to the network list
        :param pulumi.Input[str] type: The type of the network list; must be either 'IP' or 'GEO'
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkListArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a NetworkList resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param NetworkListArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkListArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 contract_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 group_id: Optional[pulumi.Input[int]] = None,
                 lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 mode: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkListArgs.__new__(NetworkListArgs)

            __props__.__dict__["contract_id"] = contract_id
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            __props__.__dict__["group_id"] = group_id
            __props__.__dict__["lists"] = lists
            if mode is None and not opts.urn:
                raise TypeError("Missing required property 'mode'")
            __props__.__dict__["mode"] = mode
            __props__.__dict__["name"] = name
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["network_list_id"] = None
            __props__.__dict__["sync_point"] = None
            __props__.__dict__["uniqueid"] = None
        super(NetworkList, __self__).__init__(
            'akamai:index/networkList:NetworkList',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            contract_id: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            group_id: Optional[pulumi.Input[int]] = None,
            lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            mode: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            network_list_id: Optional[pulumi.Input[str]] = None,
            sync_point: Optional[pulumi.Input[int]] = None,
            type: Optional[pulumi.Input[str]] = None,
            uniqueid: Optional[pulumi.Input[str]] = None) -> 'NetworkList':
        """
        Get an existing NetworkList resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] contract_id: contract ID
        :param pulumi.Input[str] description: A description of the network list
        :param pulumi.Input[int] group_id: group ID
        :param pulumi.Input[Sequence[pulumi.Input[str]]] lists: A list of IP addresses or locations to be included in the list, added to an existing list, or removed from an existing
               list
        :param pulumi.Input[str] mode: A string specifying the interpretation of the `list` parameter. Must be 'APPEND', 'REPLACE', or 'REMOVE'
        :param pulumi.Input[str] name: The name to be assigned to the network list
        :param pulumi.Input[str] network_list_id: network list ID
        :param pulumi.Input[int] sync_point: sync point
        :param pulumi.Input[str] type: The type of the network list; must be either 'IP' or 'GEO'
        :param pulumi.Input[str] uniqueid: unique ID
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkListState.__new__(_NetworkListState)

        __props__.__dict__["contract_id"] = contract_id
        __props__.__dict__["description"] = description
        __props__.__dict__["group_id"] = group_id
        __props__.__dict__["lists"] = lists
        __props__.__dict__["mode"] = mode
        __props__.__dict__["name"] = name
        __props__.__dict__["network_list_id"] = network_list_id
        __props__.__dict__["sync_point"] = sync_point
        __props__.__dict__["type"] = type
        __props__.__dict__["uniqueid"] = uniqueid
        return NetworkList(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="contractId")
    def contract_id(self) -> pulumi.Output[Optional[str]]:
        """
        contract ID
        """
        return pulumi.get(self, "contract_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        A description of the network list
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Output[Optional[int]]:
        """
        group ID
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter
    def lists(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of IP addresses or locations to be included in the list, added to an existing list, or removed from an existing
        list
        """
        return pulumi.get(self, "lists")

    @property
    @pulumi.getter
    def mode(self) -> pulumi.Output[str]:
        """
        A string specifying the interpretation of the `list` parameter. Must be 'APPEND', 'REPLACE', or 'REMOVE'
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name to be assigned to the network list
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkListId")
    def network_list_id(self) -> pulumi.Output[str]:
        """
        network list ID
        """
        return pulumi.get(self, "network_list_id")

    @property
    @pulumi.getter(name="syncPoint")
    def sync_point(self) -> pulumi.Output[int]:
        """
        sync point
        """
        return pulumi.get(self, "sync_point")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the network list; must be either 'IP' or 'GEO'
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def uniqueid(self) -> pulumi.Output[str]:
        """
        unique ID
        """
        return pulumi.get(self, "uniqueid")

