# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['NetworkListActivationsArgs', 'NetworkListActivations']

@pulumi.input_type
class NetworkListActivationsArgs:
    def __init__(__self__, *,
                 network_list_id: pulumi.Input[str],
                 notification_emails: pulumi.Input[Sequence[pulumi.Input[str]]],
                 sync_point: pulumi.Input[int],
                 network: Optional[pulumi.Input[str]] = None,
                 notes: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a NetworkListActivations resource.
        :param pulumi.Input[str] network_list_id: Unique identifier of the network list
        :param pulumi.Input[Sequence[pulumi.Input[str]]] notification_emails: List of email addresses of Control Center users who receive an email when activation of this list is complete
        :param pulumi.Input[int] sync_point: Identifies the sync point of the network list to be activated
        :param pulumi.Input[str] network: The Akamai network on which the list is activated: STAGING or PRODUCTION
        :param pulumi.Input[str] notes: Descriptive text to accompany the activation
        """
        pulumi.set(__self__, "network_list_id", network_list_id)
        pulumi.set(__self__, "notification_emails", notification_emails)
        pulumi.set(__self__, "sync_point", sync_point)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if notes is not None:
            pulumi.set(__self__, "notes", notes)

    @property
    @pulumi.getter(name="networkListId")
    def network_list_id(self) -> pulumi.Input[str]:
        """
        Unique identifier of the network list
        """
        return pulumi.get(self, "network_list_id")

    @network_list_id.setter
    def network_list_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_list_id", value)

    @property
    @pulumi.getter(name="notificationEmails")
    def notification_emails(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of email addresses of Control Center users who receive an email when activation of this list is complete
        """
        return pulumi.get(self, "notification_emails")

    @notification_emails.setter
    def notification_emails(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "notification_emails", value)

    @property
    @pulumi.getter(name="syncPoint")
    def sync_point(self) -> pulumi.Input[int]:
        """
        Identifies the sync point of the network list to be activated
        """
        return pulumi.get(self, "sync_point")

    @sync_point.setter
    def sync_point(self, value: pulumi.Input[int]):
        pulumi.set(self, "sync_point", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[str]]:
        """
        The Akamai network on which the list is activated: STAGING or PRODUCTION
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter
    def notes(self) -> Optional[pulumi.Input[str]]:
        """
        Descriptive text to accompany the activation
        """
        return pulumi.get(self, "notes")

    @notes.setter
    def notes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "notes", value)


@pulumi.input_type
class _NetworkListActivationsState:
    def __init__(__self__, *,
                 network: Optional[pulumi.Input[str]] = None,
                 network_list_id: Optional[pulumi.Input[str]] = None,
                 notes: Optional[pulumi.Input[str]] = None,
                 notification_emails: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 sync_point: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering NetworkListActivations resources.
        :param pulumi.Input[str] network: The Akamai network on which the list is activated: STAGING or PRODUCTION
        :param pulumi.Input[str] network_list_id: Unique identifier of the network list
        :param pulumi.Input[str] notes: Descriptive text to accompany the activation
        :param pulumi.Input[Sequence[pulumi.Input[str]]] notification_emails: List of email addresses of Control Center users who receive an email when activation of this list is complete
        :param pulumi.Input[str] status: This network list's current activation status in the environment specified by the "network" attribute
        :param pulumi.Input[int] sync_point: Identifies the sync point of the network list to be activated
        """
        if network is not None:
            pulumi.set(__self__, "network", network)
        if network_list_id is not None:
            pulumi.set(__self__, "network_list_id", network_list_id)
        if notes is not None:
            pulumi.set(__self__, "notes", notes)
        if notification_emails is not None:
            pulumi.set(__self__, "notification_emails", notification_emails)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if sync_point is not None:
            pulumi.set(__self__, "sync_point", sync_point)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[str]]:
        """
        The Akamai network on which the list is activated: STAGING or PRODUCTION
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="networkListId")
    def network_list_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier of the network list
        """
        return pulumi.get(self, "network_list_id")

    @network_list_id.setter
    def network_list_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_list_id", value)

    @property
    @pulumi.getter
    def notes(self) -> Optional[pulumi.Input[str]]:
        """
        Descriptive text to accompany the activation
        """
        return pulumi.get(self, "notes")

    @notes.setter
    def notes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "notes", value)

    @property
    @pulumi.getter(name="notificationEmails")
    def notification_emails(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of email addresses of Control Center users who receive an email when activation of this list is complete
        """
        return pulumi.get(self, "notification_emails")

    @notification_emails.setter
    def notification_emails(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "notification_emails", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        This network list's current activation status in the environment specified by the "network" attribute
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="syncPoint")
    def sync_point(self) -> Optional[pulumi.Input[int]]:
        """
        Identifies the sync point of the network list to be activated
        """
        return pulumi.get(self, "sync_point")

    @sync_point.setter
    def sync_point(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "sync_point", value)


class NetworkListActivations(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 network_list_id: Optional[pulumi.Input[str]] = None,
                 notes: Optional[pulumi.Input[str]] = None,
                 notification_emails: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 sync_point: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Create a NetworkListActivations resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] network: The Akamai network on which the list is activated: STAGING or PRODUCTION
        :param pulumi.Input[str] network_list_id: Unique identifier of the network list
        :param pulumi.Input[str] notes: Descriptive text to accompany the activation
        :param pulumi.Input[Sequence[pulumi.Input[str]]] notification_emails: List of email addresses of Control Center users who receive an email when activation of this list is complete
        :param pulumi.Input[int] sync_point: Identifies the sync point of the network list to be activated
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkListActivationsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a NetworkListActivations resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param NetworkListActivationsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkListActivationsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 network_list_id: Optional[pulumi.Input[str]] = None,
                 notes: Optional[pulumi.Input[str]] = None,
                 notification_emails: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 sync_point: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkListActivationsArgs.__new__(NetworkListActivationsArgs)

            __props__.__dict__["network"] = network
            if network_list_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_list_id'")
            __props__.__dict__["network_list_id"] = network_list_id
            __props__.__dict__["notes"] = notes
            if notification_emails is None and not opts.urn:
                raise TypeError("Missing required property 'notification_emails'")
            __props__.__dict__["notification_emails"] = notification_emails
            if sync_point is None and not opts.urn:
                raise TypeError("Missing required property 'sync_point'")
            __props__.__dict__["sync_point"] = sync_point
            __props__.__dict__["status"] = None
        super(NetworkListActivations, __self__).__init__(
            'akamai:index/networkListActivations:NetworkListActivations',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            network: Optional[pulumi.Input[str]] = None,
            network_list_id: Optional[pulumi.Input[str]] = None,
            notes: Optional[pulumi.Input[str]] = None,
            notification_emails: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            status: Optional[pulumi.Input[str]] = None,
            sync_point: Optional[pulumi.Input[int]] = None) -> 'NetworkListActivations':
        """
        Get an existing NetworkListActivations resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] network: The Akamai network on which the list is activated: STAGING or PRODUCTION
        :param pulumi.Input[str] network_list_id: Unique identifier of the network list
        :param pulumi.Input[str] notes: Descriptive text to accompany the activation
        :param pulumi.Input[Sequence[pulumi.Input[str]]] notification_emails: List of email addresses of Control Center users who receive an email when activation of this list is complete
        :param pulumi.Input[str] status: This network list's current activation status in the environment specified by the "network" attribute
        :param pulumi.Input[int] sync_point: Identifies the sync point of the network list to be activated
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkListActivationsState.__new__(_NetworkListActivationsState)

        __props__.__dict__["network"] = network
        __props__.__dict__["network_list_id"] = network_list_id
        __props__.__dict__["notes"] = notes
        __props__.__dict__["notification_emails"] = notification_emails
        __props__.__dict__["status"] = status
        __props__.__dict__["sync_point"] = sync_point
        return NetworkListActivations(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def network(self) -> pulumi.Output[Optional[str]]:
        """
        The Akamai network on which the list is activated: STAGING or PRODUCTION
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="networkListId")
    def network_list_id(self) -> pulumi.Output[str]:
        """
        Unique identifier of the network list
        """
        return pulumi.get(self, "network_list_id")

    @property
    @pulumi.getter
    def notes(self) -> pulumi.Output[Optional[str]]:
        """
        Descriptive text to accompany the activation
        """
        return pulumi.get(self, "notes")

    @property
    @pulumi.getter(name="notificationEmails")
    def notification_emails(self) -> pulumi.Output[Sequence[str]]:
        """
        List of email addresses of Control Center users who receive an email when activation of this list is complete
        """
        return pulumi.get(self, "notification_emails")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        This network list's current activation status in the environment specified by the "network" attribute
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="syncPoint")
    def sync_point(self) -> pulumi.Output[int]:
        """
        Identifies the sync point of the network list to be activated
        """
        return pulumi.get(self, "sync_point")

