# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PropertyArgs', 'Property']

@pulumi.input_type
class PropertyArgs:
    def __init__(__self__, *,
                 contract_id: pulumi.Input[str],
                 group_id: pulumi.Input[str],
                 product_id: pulumi.Input[str],
                 hostnames: Optional[pulumi.Input[Sequence[pulumi.Input['PropertyHostnameArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 rule_format: Optional[pulumi.Input[str]] = None,
                 rules: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Property resource.
        :param pulumi.Input[str] contract_id: Contract ID to be assigned to the Property
        :param pulumi.Input[str] group_id: Group ID to be assigned to the Property
        :param pulumi.Input[str] product_id: Product ID to be assigned to the Property
        :param pulumi.Input[str] name: Name to give to the Property (must be unique)
        :param pulumi.Input[str] rule_format: Specify the rule format version (defaults to latest version available when created)
        :param pulumi.Input[str] rules: Property Rules as JSON
        """
        pulumi.set(__self__, "contract_id", contract_id)
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "product_id", product_id)
        if hostnames is not None:
            pulumi.set(__self__, "hostnames", hostnames)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rule_format is not None:
            pulumi.set(__self__, "rule_format", rule_format)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter(name="contractId")
    def contract_id(self) -> pulumi.Input[str]:
        """
        Contract ID to be assigned to the Property
        """
        return pulumi.get(self, "contract_id")

    @contract_id.setter
    def contract_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "contract_id", value)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Input[str]:
        """
        Group ID to be assigned to the Property
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "group_id", value)

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> pulumi.Input[str]:
        """
        Product ID to be assigned to the Property
        """
        return pulumi.get(self, "product_id")

    @product_id.setter
    def product_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "product_id", value)

    @property
    @pulumi.getter
    def hostnames(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PropertyHostnameArgs']]]]:
        return pulumi.get(self, "hostnames")

    @hostnames.setter
    def hostnames(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PropertyHostnameArgs']]]]):
        pulumi.set(self, "hostnames", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name to give to the Property (must be unique)
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="ruleFormat")
    def rule_format(self) -> Optional[pulumi.Input[str]]:
        """
        Specify the rule format version (defaults to latest version available when created)
        """
        return pulumi.get(self, "rule_format")

    @rule_format.setter
    def rule_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rule_format", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[str]]:
        """
        Property Rules as JSON
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rules", value)


@pulumi.input_type
class _PropertyState:
    def __init__(__self__, *,
                 contract_id: Optional[pulumi.Input[str]] = None,
                 group_id: Optional[pulumi.Input[str]] = None,
                 hostnames: Optional[pulumi.Input[Sequence[pulumi.Input['PropertyHostnameArgs']]]] = None,
                 latest_version: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 product_id: Optional[pulumi.Input[str]] = None,
                 production_version: Optional[pulumi.Input[int]] = None,
                 read_version: Optional[pulumi.Input[int]] = None,
                 rule_errors: Optional[pulumi.Input[Sequence[pulumi.Input['PropertyRuleErrorArgs']]]] = None,
                 rule_format: Optional[pulumi.Input[str]] = None,
                 rules: Optional[pulumi.Input[str]] = None,
                 staging_version: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering Property resources.
        :param pulumi.Input[str] contract_id: Contract ID to be assigned to the Property
        :param pulumi.Input[str] group_id: Group ID to be assigned to the Property
        :param pulumi.Input[int] latest_version: Property's current latest version number
        :param pulumi.Input[str] name: Name to give to the Property (must be unique)
        :param pulumi.Input[str] product_id: Product ID to be assigned to the Property
        :param pulumi.Input[int] production_version: Property's version currently activated in production (zero when not active in production)
        :param pulumi.Input[int] read_version: Required property's version to be read
        :param pulumi.Input[str] rule_format: Specify the rule format version (defaults to latest version available when created)
        :param pulumi.Input[str] rules: Property Rules as JSON
        :param pulumi.Input[int] staging_version: Property's version currently activated in staging (zero when not active in staging)
        """
        if contract_id is not None:
            pulumi.set(__self__, "contract_id", contract_id)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if hostnames is not None:
            pulumi.set(__self__, "hostnames", hostnames)
        if latest_version is not None:
            pulumi.set(__self__, "latest_version", latest_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if product_id is not None:
            pulumi.set(__self__, "product_id", product_id)
        if production_version is not None:
            pulumi.set(__self__, "production_version", production_version)
        if read_version is not None:
            pulumi.set(__self__, "read_version", read_version)
        if rule_errors is not None:
            pulumi.set(__self__, "rule_errors", rule_errors)
        if rule_format is not None:
            pulumi.set(__self__, "rule_format", rule_format)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if staging_version is not None:
            pulumi.set(__self__, "staging_version", staging_version)

    @property
    @pulumi.getter(name="contractId")
    def contract_id(self) -> Optional[pulumi.Input[str]]:
        """
        Contract ID to be assigned to the Property
        """
        return pulumi.get(self, "contract_id")

    @contract_id.setter
    def contract_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "contract_id", value)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[str]]:
        """
        Group ID to be assigned to the Property
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_id", value)

    @property
    @pulumi.getter
    def hostnames(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PropertyHostnameArgs']]]]:
        return pulumi.get(self, "hostnames")

    @hostnames.setter
    def hostnames(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PropertyHostnameArgs']]]]):
        pulumi.set(self, "hostnames", value)

    @property
    @pulumi.getter(name="latestVersion")
    def latest_version(self) -> Optional[pulumi.Input[int]]:
        """
        Property's current latest version number
        """
        return pulumi.get(self, "latest_version")

    @latest_version.setter
    def latest_version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "latest_version", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name to give to the Property (must be unique)
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> Optional[pulumi.Input[str]]:
        """
        Product ID to be assigned to the Property
        """
        return pulumi.get(self, "product_id")

    @product_id.setter
    def product_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "product_id", value)

    @property
    @pulumi.getter(name="productionVersion")
    def production_version(self) -> Optional[pulumi.Input[int]]:
        """
        Property's version currently activated in production (zero when not active in production)
        """
        return pulumi.get(self, "production_version")

    @production_version.setter
    def production_version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "production_version", value)

    @property
    @pulumi.getter(name="readVersion")
    def read_version(self) -> Optional[pulumi.Input[int]]:
        """
        Required property's version to be read
        """
        return pulumi.get(self, "read_version")

    @read_version.setter
    def read_version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "read_version", value)

    @property
    @pulumi.getter(name="ruleErrors")
    def rule_errors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PropertyRuleErrorArgs']]]]:
        return pulumi.get(self, "rule_errors")

    @rule_errors.setter
    def rule_errors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PropertyRuleErrorArgs']]]]):
        pulumi.set(self, "rule_errors", value)

    @property
    @pulumi.getter(name="ruleFormat")
    def rule_format(self) -> Optional[pulumi.Input[str]]:
        """
        Specify the rule format version (defaults to latest version available when created)
        """
        return pulumi.get(self, "rule_format")

    @rule_format.setter
    def rule_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rule_format", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[str]]:
        """
        Property Rules as JSON
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rules", value)

    @property
    @pulumi.getter(name="stagingVersion")
    def staging_version(self) -> Optional[pulumi.Input[int]]:
        """
        Property's version currently activated in staging (zero when not active in staging)
        """
        return pulumi.get(self, "staging_version")

    @staging_version.setter
    def staging_version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "staging_version", value)


class Property(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 contract_id: Optional[pulumi.Input[str]] = None,
                 group_id: Optional[pulumi.Input[str]] = None,
                 hostnames: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PropertyHostnameArgs']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 product_id: Optional[pulumi.Input[str]] = None,
                 rule_format: Optional[pulumi.Input[str]] = None,
                 rules: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a Property resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] contract_id: Contract ID to be assigned to the Property
        :param pulumi.Input[str] group_id: Group ID to be assigned to the Property
        :param pulumi.Input[str] name: Name to give to the Property (must be unique)
        :param pulumi.Input[str] product_id: Product ID to be assigned to the Property
        :param pulumi.Input[str] rule_format: Specify the rule format version (defaults to latest version available when created)
        :param pulumi.Input[str] rules: Property Rules as JSON
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PropertyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a Property resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param PropertyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PropertyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 contract_id: Optional[pulumi.Input[str]] = None,
                 group_id: Optional[pulumi.Input[str]] = None,
                 hostnames: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PropertyHostnameArgs']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 product_id: Optional[pulumi.Input[str]] = None,
                 rule_format: Optional[pulumi.Input[str]] = None,
                 rules: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PropertyArgs.__new__(PropertyArgs)

            if contract_id is None and not opts.urn:
                raise TypeError("Missing required property 'contract_id'")
            __props__.__dict__["contract_id"] = contract_id
            if group_id is None and not opts.urn:
                raise TypeError("Missing required property 'group_id'")
            __props__.__dict__["group_id"] = group_id
            __props__.__dict__["hostnames"] = hostnames
            __props__.__dict__["name"] = name
            if product_id is None and not opts.urn:
                raise TypeError("Missing required property 'product_id'")
            __props__.__dict__["product_id"] = product_id
            __props__.__dict__["rule_format"] = rule_format
            __props__.__dict__["rules"] = rules
            __props__.__dict__["latest_version"] = None
            __props__.__dict__["production_version"] = None
            __props__.__dict__["read_version"] = None
            __props__.__dict__["rule_errors"] = None
            __props__.__dict__["staging_version"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="akamai:properties/property:Property")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(Property, __self__).__init__(
            'akamai:index/property:Property',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            contract_id: Optional[pulumi.Input[str]] = None,
            group_id: Optional[pulumi.Input[str]] = None,
            hostnames: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PropertyHostnameArgs']]]]] = None,
            latest_version: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            product_id: Optional[pulumi.Input[str]] = None,
            production_version: Optional[pulumi.Input[int]] = None,
            read_version: Optional[pulumi.Input[int]] = None,
            rule_errors: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PropertyRuleErrorArgs']]]]] = None,
            rule_format: Optional[pulumi.Input[str]] = None,
            rules: Optional[pulumi.Input[str]] = None,
            staging_version: Optional[pulumi.Input[int]] = None) -> 'Property':
        """
        Get an existing Property resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] contract_id: Contract ID to be assigned to the Property
        :param pulumi.Input[str] group_id: Group ID to be assigned to the Property
        :param pulumi.Input[int] latest_version: Property's current latest version number
        :param pulumi.Input[str] name: Name to give to the Property (must be unique)
        :param pulumi.Input[str] product_id: Product ID to be assigned to the Property
        :param pulumi.Input[int] production_version: Property's version currently activated in production (zero when not active in production)
        :param pulumi.Input[int] read_version: Required property's version to be read
        :param pulumi.Input[str] rule_format: Specify the rule format version (defaults to latest version available when created)
        :param pulumi.Input[str] rules: Property Rules as JSON
        :param pulumi.Input[int] staging_version: Property's version currently activated in staging (zero when not active in staging)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PropertyState.__new__(_PropertyState)

        __props__.__dict__["contract_id"] = contract_id
        __props__.__dict__["group_id"] = group_id
        __props__.__dict__["hostnames"] = hostnames
        __props__.__dict__["latest_version"] = latest_version
        __props__.__dict__["name"] = name
        __props__.__dict__["product_id"] = product_id
        __props__.__dict__["production_version"] = production_version
        __props__.__dict__["read_version"] = read_version
        __props__.__dict__["rule_errors"] = rule_errors
        __props__.__dict__["rule_format"] = rule_format
        __props__.__dict__["rules"] = rules
        __props__.__dict__["staging_version"] = staging_version
        return Property(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="contractId")
    def contract_id(self) -> pulumi.Output[str]:
        """
        Contract ID to be assigned to the Property
        """
        return pulumi.get(self, "contract_id")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Output[str]:
        """
        Group ID to be assigned to the Property
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter
    def hostnames(self) -> pulumi.Output[Optional[Sequence['outputs.PropertyHostname']]]:
        return pulumi.get(self, "hostnames")

    @property
    @pulumi.getter(name="latestVersion")
    def latest_version(self) -> pulumi.Output[int]:
        """
        Property's current latest version number
        """
        return pulumi.get(self, "latest_version")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name to give to the Property (must be unique)
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> pulumi.Output[str]:
        """
        Product ID to be assigned to the Property
        """
        return pulumi.get(self, "product_id")

    @property
    @pulumi.getter(name="productionVersion")
    def production_version(self) -> pulumi.Output[int]:
        """
        Property's version currently activated in production (zero when not active in production)
        """
        return pulumi.get(self, "production_version")

    @property
    @pulumi.getter(name="readVersion")
    def read_version(self) -> pulumi.Output[int]:
        """
        Required property's version to be read
        """
        return pulumi.get(self, "read_version")

    @property
    @pulumi.getter(name="ruleErrors")
    def rule_errors(self) -> pulumi.Output[Sequence['outputs.PropertyRuleError']]:
        return pulumi.get(self, "rule_errors")

    @property
    @pulumi.getter(name="ruleFormat")
    def rule_format(self) -> pulumi.Output[str]:
        """
        Specify the rule format version (defaults to latest version available when created)
        """
        return pulumi.get(self, "rule_format")

    @property
    @pulumi.getter
    def rules(self) -> pulumi.Output[str]:
        """
        Property Rules as JSON
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter(name="stagingVersion")
    def staging_version(self) -> pulumi.Output[int]:
        """
        Property's version currently activated in staging (zero when not active in staging)
        """
        return pulumi.get(self, "staging_version")

