# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PropertyActivationArgs', 'PropertyActivation']

@pulumi.input_type
class PropertyActivationArgs:
    def __init__(__self__, *,
                 contacts: pulumi.Input[Sequence[pulumi.Input[str]]],
                 property_id: pulumi.Input[str],
                 version: pulumi.Input[int],
                 activation_id: Optional[pulumi.Input[str]] = None,
                 auto_acknowledge_rule_warnings: Optional[pulumi.Input[bool]] = None,
                 compliance_record: Optional[pulumi.Input['PropertyActivationComplianceRecordArgs']] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 note: Optional[pulumi.Input[str]] = None,
                 rule_errors: Optional[pulumi.Input[Sequence[pulumi.Input['PropertyActivationRuleErrorArgs']]]] = None):
        """
        The set of arguments for constructing a PropertyActivation resource.
        :param pulumi.Input[bool] auto_acknowledge_rule_warnings: Automatically acknowledge all rule warnings for activation to continue. Default is false
        :param pulumi.Input['PropertyActivationComplianceRecordArgs'] compliance_record: Provides an audit record when activating on a production network
        :param pulumi.Input[str] note: assigns a log message to the activation request
        """
        pulumi.set(__self__, "contacts", contacts)
        pulumi.set(__self__, "property_id", property_id)
        pulumi.set(__self__, "version", version)
        if activation_id is not None:
            pulumi.set(__self__, "activation_id", activation_id)
        if auto_acknowledge_rule_warnings is not None:
            pulumi.set(__self__, "auto_acknowledge_rule_warnings", auto_acknowledge_rule_warnings)
        if compliance_record is not None:
            pulumi.set(__self__, "compliance_record", compliance_record)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if note is not None:
            pulumi.set(__self__, "note", note)
        if rule_errors is not None:
            pulumi.set(__self__, "rule_errors", rule_errors)

    @property
    @pulumi.getter
    def contacts(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        return pulumi.get(self, "contacts")

    @contacts.setter
    def contacts(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "contacts", value)

    @property
    @pulumi.getter(name="propertyId")
    def property_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "property_id")

    @property_id.setter
    def property_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "property_id", value)

    @property
    @pulumi.getter
    def version(self) -> pulumi.Input[int]:
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[int]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="activationId")
    def activation_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "activation_id")

    @activation_id.setter
    def activation_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "activation_id", value)

    @property
    @pulumi.getter(name="autoAcknowledgeRuleWarnings")
    def auto_acknowledge_rule_warnings(self) -> Optional[pulumi.Input[bool]]:
        """
        Automatically acknowledge all rule warnings for activation to continue. Default is false
        """
        return pulumi.get(self, "auto_acknowledge_rule_warnings")

    @auto_acknowledge_rule_warnings.setter
    def auto_acknowledge_rule_warnings(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_acknowledge_rule_warnings", value)

    @property
    @pulumi.getter(name="complianceRecord")
    def compliance_record(self) -> Optional[pulumi.Input['PropertyActivationComplianceRecordArgs']]:
        """
        Provides an audit record when activating on a production network
        """
        return pulumi.get(self, "compliance_record")

    @compliance_record.setter
    def compliance_record(self, value: Optional[pulumi.Input['PropertyActivationComplianceRecordArgs']]):
        pulumi.set(self, "compliance_record", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter
    def note(self) -> Optional[pulumi.Input[str]]:
        """
        assigns a log message to the activation request
        """
        return pulumi.get(self, "note")

    @note.setter
    def note(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "note", value)

    @property
    @pulumi.getter(name="ruleErrors")
    def rule_errors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PropertyActivationRuleErrorArgs']]]]:
        return pulumi.get(self, "rule_errors")

    @rule_errors.setter
    def rule_errors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PropertyActivationRuleErrorArgs']]]]):
        pulumi.set(self, "rule_errors", value)


@pulumi.input_type
class _PropertyActivationState:
    def __init__(__self__, *,
                 activation_id: Optional[pulumi.Input[str]] = None,
                 auto_acknowledge_rule_warnings: Optional[pulumi.Input[bool]] = None,
                 compliance_record: Optional[pulumi.Input['PropertyActivationComplianceRecordArgs']] = None,
                 contacts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 errors: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 note: Optional[pulumi.Input[str]] = None,
                 property_id: Optional[pulumi.Input[str]] = None,
                 rule_errors: Optional[pulumi.Input[Sequence[pulumi.Input['PropertyActivationRuleErrorArgs']]]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[int]] = None,
                 warnings: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering PropertyActivation resources.
        :param pulumi.Input[bool] auto_acknowledge_rule_warnings: Automatically acknowledge all rule warnings for activation to continue. Default is false
        :param pulumi.Input['PropertyActivationComplianceRecordArgs'] compliance_record: Provides an audit record when activating on a production network
        :param pulumi.Input[str] note: assigns a log message to the activation request
        """
        if activation_id is not None:
            pulumi.set(__self__, "activation_id", activation_id)
        if auto_acknowledge_rule_warnings is not None:
            pulumi.set(__self__, "auto_acknowledge_rule_warnings", auto_acknowledge_rule_warnings)
        if compliance_record is not None:
            pulumi.set(__self__, "compliance_record", compliance_record)
        if contacts is not None:
            pulumi.set(__self__, "contacts", contacts)
        if errors is not None:
            pulumi.set(__self__, "errors", errors)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if note is not None:
            pulumi.set(__self__, "note", note)
        if property_id is not None:
            pulumi.set(__self__, "property_id", property_id)
        if rule_errors is not None:
            pulumi.set(__self__, "rule_errors", rule_errors)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if warnings is not None:
            pulumi.set(__self__, "warnings", warnings)

    @property
    @pulumi.getter(name="activationId")
    def activation_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "activation_id")

    @activation_id.setter
    def activation_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "activation_id", value)

    @property
    @pulumi.getter(name="autoAcknowledgeRuleWarnings")
    def auto_acknowledge_rule_warnings(self) -> Optional[pulumi.Input[bool]]:
        """
        Automatically acknowledge all rule warnings for activation to continue. Default is false
        """
        return pulumi.get(self, "auto_acknowledge_rule_warnings")

    @auto_acknowledge_rule_warnings.setter
    def auto_acknowledge_rule_warnings(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_acknowledge_rule_warnings", value)

    @property
    @pulumi.getter(name="complianceRecord")
    def compliance_record(self) -> Optional[pulumi.Input['PropertyActivationComplianceRecordArgs']]:
        """
        Provides an audit record when activating on a production network
        """
        return pulumi.get(self, "compliance_record")

    @compliance_record.setter
    def compliance_record(self, value: Optional[pulumi.Input['PropertyActivationComplianceRecordArgs']]):
        pulumi.set(self, "compliance_record", value)

    @property
    @pulumi.getter
    def contacts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "contacts")

    @contacts.setter
    def contacts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "contacts", value)

    @property
    @pulumi.getter
    def errors(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "errors")

    @errors.setter
    def errors(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "errors", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter
    def note(self) -> Optional[pulumi.Input[str]]:
        """
        assigns a log message to the activation request
        """
        return pulumi.get(self, "note")

    @note.setter
    def note(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "note", value)

    @property
    @pulumi.getter(name="propertyId")
    def property_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "property_id")

    @property_id.setter
    def property_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "property_id", value)

    @property
    @pulumi.getter(name="ruleErrors")
    def rule_errors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PropertyActivationRuleErrorArgs']]]]:
        return pulumi.get(self, "rule_errors")

    @rule_errors.setter
    def rule_errors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PropertyActivationRuleErrorArgs']]]]):
        pulumi.set(self, "rule_errors", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter
    def warnings(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "warnings")

    @warnings.setter
    def warnings(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "warnings", value)


class PropertyActivation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 activation_id: Optional[pulumi.Input[str]] = None,
                 auto_acknowledge_rule_warnings: Optional[pulumi.Input[bool]] = None,
                 compliance_record: Optional[pulumi.Input[pulumi.InputType['PropertyActivationComplianceRecordArgs']]] = None,
                 contacts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 note: Optional[pulumi.Input[str]] = None,
                 property_id: Optional[pulumi.Input[str]] = None,
                 rule_errors: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PropertyActivationRuleErrorArgs']]]]] = None,
                 version: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Create a PropertyActivation resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] auto_acknowledge_rule_warnings: Automatically acknowledge all rule warnings for activation to continue. Default is false
        :param pulumi.Input[pulumi.InputType['PropertyActivationComplianceRecordArgs']] compliance_record: Provides an audit record when activating on a production network
        :param pulumi.Input[str] note: assigns a log message to the activation request
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PropertyActivationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a PropertyActivation resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param PropertyActivationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PropertyActivationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 activation_id: Optional[pulumi.Input[str]] = None,
                 auto_acknowledge_rule_warnings: Optional[pulumi.Input[bool]] = None,
                 compliance_record: Optional[pulumi.Input[pulumi.InputType['PropertyActivationComplianceRecordArgs']]] = None,
                 contacts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 note: Optional[pulumi.Input[str]] = None,
                 property_id: Optional[pulumi.Input[str]] = None,
                 rule_errors: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PropertyActivationRuleErrorArgs']]]]] = None,
                 version: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PropertyActivationArgs.__new__(PropertyActivationArgs)

            __props__.__dict__["activation_id"] = activation_id
            __props__.__dict__["auto_acknowledge_rule_warnings"] = auto_acknowledge_rule_warnings
            __props__.__dict__["compliance_record"] = compliance_record
            if contacts is None and not opts.urn:
                raise TypeError("Missing required property 'contacts'")
            __props__.__dict__["contacts"] = contacts
            __props__.__dict__["network"] = network
            __props__.__dict__["note"] = note
            if property_id is None and not opts.urn:
                raise TypeError("Missing required property 'property_id'")
            __props__.__dict__["property_id"] = property_id
            __props__.__dict__["rule_errors"] = rule_errors
            if version is None and not opts.urn:
                raise TypeError("Missing required property 'version'")
            __props__.__dict__["version"] = version
            __props__.__dict__["errors"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["warnings"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="akamai:properties/propertyActivation:PropertyActivation")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(PropertyActivation, __self__).__init__(
            'akamai:index/propertyActivation:PropertyActivation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            activation_id: Optional[pulumi.Input[str]] = None,
            auto_acknowledge_rule_warnings: Optional[pulumi.Input[bool]] = None,
            compliance_record: Optional[pulumi.Input[pulumi.InputType['PropertyActivationComplianceRecordArgs']]] = None,
            contacts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            errors: Optional[pulumi.Input[str]] = None,
            network: Optional[pulumi.Input[str]] = None,
            note: Optional[pulumi.Input[str]] = None,
            property_id: Optional[pulumi.Input[str]] = None,
            rule_errors: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PropertyActivationRuleErrorArgs']]]]] = None,
            status: Optional[pulumi.Input[str]] = None,
            version: Optional[pulumi.Input[int]] = None,
            warnings: Optional[pulumi.Input[str]] = None) -> 'PropertyActivation':
        """
        Get an existing PropertyActivation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] auto_acknowledge_rule_warnings: Automatically acknowledge all rule warnings for activation to continue. Default is false
        :param pulumi.Input[pulumi.InputType['PropertyActivationComplianceRecordArgs']] compliance_record: Provides an audit record when activating on a production network
        :param pulumi.Input[str] note: assigns a log message to the activation request
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PropertyActivationState.__new__(_PropertyActivationState)

        __props__.__dict__["activation_id"] = activation_id
        __props__.__dict__["auto_acknowledge_rule_warnings"] = auto_acknowledge_rule_warnings
        __props__.__dict__["compliance_record"] = compliance_record
        __props__.__dict__["contacts"] = contacts
        __props__.__dict__["errors"] = errors
        __props__.__dict__["network"] = network
        __props__.__dict__["note"] = note
        __props__.__dict__["property_id"] = property_id
        __props__.__dict__["rule_errors"] = rule_errors
        __props__.__dict__["status"] = status
        __props__.__dict__["version"] = version
        __props__.__dict__["warnings"] = warnings
        return PropertyActivation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="activationId")
    def activation_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "activation_id")

    @property
    @pulumi.getter(name="autoAcknowledgeRuleWarnings")
    def auto_acknowledge_rule_warnings(self) -> pulumi.Output[Optional[bool]]:
        """
        Automatically acknowledge all rule warnings for activation to continue. Default is false
        """
        return pulumi.get(self, "auto_acknowledge_rule_warnings")

    @property
    @pulumi.getter(name="complianceRecord")
    def compliance_record(self) -> pulumi.Output[Optional['outputs.PropertyActivationComplianceRecord']]:
        """
        Provides an audit record when activating on a production network
        """
        return pulumi.get(self, "compliance_record")

    @property
    @pulumi.getter
    def contacts(self) -> pulumi.Output[Sequence[str]]:
        return pulumi.get(self, "contacts")

    @property
    @pulumi.getter
    def errors(self) -> pulumi.Output[str]:
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter
    def network(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "network")

    @property
    @pulumi.getter
    def note(self) -> pulumi.Output[Optional[str]]:
        """
        assigns a log message to the activation request
        """
        return pulumi.get(self, "note")

    @property
    @pulumi.getter(name="propertyId")
    def property_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "property_id")

    @property
    @pulumi.getter(name="ruleErrors")
    def rule_errors(self) -> pulumi.Output[Sequence['outputs.PropertyActivationRuleError']]:
        return pulumi.get(self, "rule_errors")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[int]:
        return pulumi.get(self, "version")

    @property
    @pulumi.getter
    def warnings(self) -> pulumi.Output[str]:
        return pulumi.get(self, "warnings")

