# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['PropertyIncludeArgs', 'PropertyInclude']

@pulumi.input_type
class PropertyIncludeArgs:
    def __init__(__self__, *,
                 contract_id: pulumi.Input[str],
                 group_id: pulumi.Input[str],
                 rule_format: pulumi.Input[str],
                 type: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None,
                 product_id: Optional[pulumi.Input[str]] = None,
                 rules: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a PropertyInclude resource.
        :param pulumi.Input[str] contract_id: Identifies the contract to which the include is assigned
        :param pulumi.Input[str] group_id: Identifies the group to which the include is assigned
        :param pulumi.Input[str] rule_format: Indicates the versioned set of features and criteria
        :param pulumi.Input[str] type: Specifies the type of the include, either 'MICROSERVICES' or 'COMMON_SETTINGS'
        :param pulumi.Input[str] name: A descriptive name for the include
        :param pulumi.Input[str] product_id: The product assigned to the include
        :param pulumi.Input[str] rules: Property Rules as JSON
        """
        pulumi.set(__self__, "contract_id", contract_id)
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "rule_format", rule_format)
        pulumi.set(__self__, "type", type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if product_id is not None:
            pulumi.set(__self__, "product_id", product_id)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter(name="contractId")
    def contract_id(self) -> pulumi.Input[str]:
        """
        Identifies the contract to which the include is assigned
        """
        return pulumi.get(self, "contract_id")

    @contract_id.setter
    def contract_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "contract_id", value)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Input[str]:
        """
        Identifies the group to which the include is assigned
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "group_id", value)

    @property
    @pulumi.getter(name="ruleFormat")
    def rule_format(self) -> pulumi.Input[str]:
        """
        Indicates the versioned set of features and criteria
        """
        return pulumi.get(self, "rule_format")

    @rule_format.setter
    def rule_format(self, value: pulumi.Input[str]):
        pulumi.set(self, "rule_format", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Specifies the type of the include, either 'MICROSERVICES' or 'COMMON_SETTINGS'
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A descriptive name for the include
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> Optional[pulumi.Input[str]]:
        """
        The product assigned to the include
        """
        return pulumi.get(self, "product_id")

    @product_id.setter
    def product_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "product_id", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[str]]:
        """
        Property Rules as JSON
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rules", value)


@pulumi.input_type
class _PropertyIncludeState:
    def __init__(__self__, *,
                 contract_id: Optional[pulumi.Input[str]] = None,
                 group_id: Optional[pulumi.Input[str]] = None,
                 latest_version: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 product_id: Optional[pulumi.Input[str]] = None,
                 production_version: Optional[pulumi.Input[str]] = None,
                 rule_errors: Optional[pulumi.Input[str]] = None,
                 rule_format: Optional[pulumi.Input[str]] = None,
                 rule_warnings: Optional[pulumi.Input[str]] = None,
                 rules: Optional[pulumi.Input[str]] = None,
                 staging_version: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering PropertyInclude resources.
        :param pulumi.Input[str] contract_id: Identifies the contract to which the include is assigned
        :param pulumi.Input[str] group_id: Identifies the group to which the include is assigned
        :param pulumi.Input[int] latest_version: Specifies the most recent version of the include
        :param pulumi.Input[str] name: A descriptive name for the include
        :param pulumi.Input[str] product_id: The product assigned to the include
        :param pulumi.Input[str] production_version: The most recent version to be activated to the production network
        :param pulumi.Input[str] rule_errors: Rule validation errors
        :param pulumi.Input[str] rule_format: Indicates the versioned set of features and criteria
        :param pulumi.Input[str] rule_warnings: Rule validation warnings
        :param pulumi.Input[str] rules: Property Rules as JSON
        :param pulumi.Input[str] staging_version: The most recent version to be activated to the staging network
        :param pulumi.Input[str] type: Specifies the type of the include, either 'MICROSERVICES' or 'COMMON_SETTINGS'
        """
        if contract_id is not None:
            pulumi.set(__self__, "contract_id", contract_id)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if latest_version is not None:
            pulumi.set(__self__, "latest_version", latest_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if product_id is not None:
            pulumi.set(__self__, "product_id", product_id)
        if production_version is not None:
            pulumi.set(__self__, "production_version", production_version)
        if rule_errors is not None:
            pulumi.set(__self__, "rule_errors", rule_errors)
        if rule_format is not None:
            pulumi.set(__self__, "rule_format", rule_format)
        if rule_warnings is not None:
            pulumi.set(__self__, "rule_warnings", rule_warnings)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if staging_version is not None:
            pulumi.set(__self__, "staging_version", staging_version)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="contractId")
    def contract_id(self) -> Optional[pulumi.Input[str]]:
        """
        Identifies the contract to which the include is assigned
        """
        return pulumi.get(self, "contract_id")

    @contract_id.setter
    def contract_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "contract_id", value)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[str]]:
        """
        Identifies the group to which the include is assigned
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_id", value)

    @property
    @pulumi.getter(name="latestVersion")
    def latest_version(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the most recent version of the include
        """
        return pulumi.get(self, "latest_version")

    @latest_version.setter
    def latest_version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "latest_version", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A descriptive name for the include
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> Optional[pulumi.Input[str]]:
        """
        The product assigned to the include
        """
        return pulumi.get(self, "product_id")

    @product_id.setter
    def product_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "product_id", value)

    @property
    @pulumi.getter(name="productionVersion")
    def production_version(self) -> Optional[pulumi.Input[str]]:
        """
        The most recent version to be activated to the production network
        """
        return pulumi.get(self, "production_version")

    @production_version.setter
    def production_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "production_version", value)

    @property
    @pulumi.getter(name="ruleErrors")
    def rule_errors(self) -> Optional[pulumi.Input[str]]:
        """
        Rule validation errors
        """
        return pulumi.get(self, "rule_errors")

    @rule_errors.setter
    def rule_errors(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rule_errors", value)

    @property
    @pulumi.getter(name="ruleFormat")
    def rule_format(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the versioned set of features and criteria
        """
        return pulumi.get(self, "rule_format")

    @rule_format.setter
    def rule_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rule_format", value)

    @property
    @pulumi.getter(name="ruleWarnings")
    def rule_warnings(self) -> Optional[pulumi.Input[str]]:
        """
        Rule validation warnings
        """
        return pulumi.get(self, "rule_warnings")

    @rule_warnings.setter
    def rule_warnings(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rule_warnings", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[str]]:
        """
        Property Rules as JSON
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rules", value)

    @property
    @pulumi.getter(name="stagingVersion")
    def staging_version(self) -> Optional[pulumi.Input[str]]:
        """
        The most recent version to be activated to the staging network
        """
        return pulumi.get(self, "staging_version")

    @staging_version.setter
    def staging_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "staging_version", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the type of the include, either 'MICROSERVICES' or 'COMMON_SETTINGS'
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


class PropertyInclude(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 contract_id: Optional[pulumi.Input[str]] = None,
                 group_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 product_id: Optional[pulumi.Input[str]] = None,
                 rule_format: Optional[pulumi.Input[str]] = None,
                 rules: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a PropertyInclude resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] contract_id: Identifies the contract to which the include is assigned
        :param pulumi.Input[str] group_id: Identifies the group to which the include is assigned
        :param pulumi.Input[str] name: A descriptive name for the include
        :param pulumi.Input[str] product_id: The product assigned to the include
        :param pulumi.Input[str] rule_format: Indicates the versioned set of features and criteria
        :param pulumi.Input[str] rules: Property Rules as JSON
        :param pulumi.Input[str] type: Specifies the type of the include, either 'MICROSERVICES' or 'COMMON_SETTINGS'
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PropertyIncludeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a PropertyInclude resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param PropertyIncludeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PropertyIncludeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 contract_id: Optional[pulumi.Input[str]] = None,
                 group_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 product_id: Optional[pulumi.Input[str]] = None,
                 rule_format: Optional[pulumi.Input[str]] = None,
                 rules: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PropertyIncludeArgs.__new__(PropertyIncludeArgs)

            if contract_id is None and not opts.urn:
                raise TypeError("Missing required property 'contract_id'")
            __props__.__dict__["contract_id"] = contract_id
            if group_id is None and not opts.urn:
                raise TypeError("Missing required property 'group_id'")
            __props__.__dict__["group_id"] = group_id
            __props__.__dict__["name"] = name
            __props__.__dict__["product_id"] = product_id
            if rule_format is None and not opts.urn:
                raise TypeError("Missing required property 'rule_format'")
            __props__.__dict__["rule_format"] = rule_format
            __props__.__dict__["rules"] = rules
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["latest_version"] = None
            __props__.__dict__["production_version"] = None
            __props__.__dict__["rule_errors"] = None
            __props__.__dict__["rule_warnings"] = None
            __props__.__dict__["staging_version"] = None
        super(PropertyInclude, __self__).__init__(
            'akamai:index/propertyInclude:PropertyInclude',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            contract_id: Optional[pulumi.Input[str]] = None,
            group_id: Optional[pulumi.Input[str]] = None,
            latest_version: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            product_id: Optional[pulumi.Input[str]] = None,
            production_version: Optional[pulumi.Input[str]] = None,
            rule_errors: Optional[pulumi.Input[str]] = None,
            rule_format: Optional[pulumi.Input[str]] = None,
            rule_warnings: Optional[pulumi.Input[str]] = None,
            rules: Optional[pulumi.Input[str]] = None,
            staging_version: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None) -> 'PropertyInclude':
        """
        Get an existing PropertyInclude resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] contract_id: Identifies the contract to which the include is assigned
        :param pulumi.Input[str] group_id: Identifies the group to which the include is assigned
        :param pulumi.Input[int] latest_version: Specifies the most recent version of the include
        :param pulumi.Input[str] name: A descriptive name for the include
        :param pulumi.Input[str] product_id: The product assigned to the include
        :param pulumi.Input[str] production_version: The most recent version to be activated to the production network
        :param pulumi.Input[str] rule_errors: Rule validation errors
        :param pulumi.Input[str] rule_format: Indicates the versioned set of features and criteria
        :param pulumi.Input[str] rule_warnings: Rule validation warnings
        :param pulumi.Input[str] rules: Property Rules as JSON
        :param pulumi.Input[str] staging_version: The most recent version to be activated to the staging network
        :param pulumi.Input[str] type: Specifies the type of the include, either 'MICROSERVICES' or 'COMMON_SETTINGS'
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PropertyIncludeState.__new__(_PropertyIncludeState)

        __props__.__dict__["contract_id"] = contract_id
        __props__.__dict__["group_id"] = group_id
        __props__.__dict__["latest_version"] = latest_version
        __props__.__dict__["name"] = name
        __props__.__dict__["product_id"] = product_id
        __props__.__dict__["production_version"] = production_version
        __props__.__dict__["rule_errors"] = rule_errors
        __props__.__dict__["rule_format"] = rule_format
        __props__.__dict__["rule_warnings"] = rule_warnings
        __props__.__dict__["rules"] = rules
        __props__.__dict__["staging_version"] = staging_version
        __props__.__dict__["type"] = type
        return PropertyInclude(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="contractId")
    def contract_id(self) -> pulumi.Output[str]:
        """
        Identifies the contract to which the include is assigned
        """
        return pulumi.get(self, "contract_id")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Output[str]:
        """
        Identifies the group to which the include is assigned
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter(name="latestVersion")
    def latest_version(self) -> pulumi.Output[int]:
        """
        Specifies the most recent version of the include
        """
        return pulumi.get(self, "latest_version")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        A descriptive name for the include
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> pulumi.Output[Optional[str]]:
        """
        The product assigned to the include
        """
        return pulumi.get(self, "product_id")

    @property
    @pulumi.getter(name="productionVersion")
    def production_version(self) -> pulumi.Output[str]:
        """
        The most recent version to be activated to the production network
        """
        return pulumi.get(self, "production_version")

    @property
    @pulumi.getter(name="ruleErrors")
    def rule_errors(self) -> pulumi.Output[str]:
        """
        Rule validation errors
        """
        return pulumi.get(self, "rule_errors")

    @property
    @pulumi.getter(name="ruleFormat")
    def rule_format(self) -> pulumi.Output[str]:
        """
        Indicates the versioned set of features and criteria
        """
        return pulumi.get(self, "rule_format")

    @property
    @pulumi.getter(name="ruleWarnings")
    def rule_warnings(self) -> pulumi.Output[str]:
        """
        Rule validation warnings
        """
        return pulumi.get(self, "rule_warnings")

    @property
    @pulumi.getter
    def rules(self) -> pulumi.Output[str]:
        """
        Property Rules as JSON
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter(name="stagingVersion")
    def staging_version(self) -> pulumi.Output[str]:
        """
        The most recent version to be activated to the staging network
        """
        return pulumi.get(self, "staging_version")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Specifies the type of the include, either 'MICROSERVICES' or 'COMMON_SETTINGS'
        """
        return pulumi.get(self, "type")

