# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from ._inputs import *

__all__ = ['ProviderArgs', 'Provider']

@pulumi.input_type
class ProviderArgs:
    def __init__(__self__, *,
                 cache_enabled: Optional[pulumi.Input[bool]] = None,
                 config: Optional[pulumi.Input['ProviderConfigArgs']] = None,
                 config_section: Optional[pulumi.Input[str]] = None,
                 edgerc: Optional[pulumi.Input[str]] = None,
                 request_limit: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a Provider resource.
        :param pulumi.Input[str] config_section: The section of the edgerc file to use for configuration
        :param pulumi.Input[int] request_limit: The maximum number of API requests to be made per second (0 for no limit)
        """
        if cache_enabled is not None:
            pulumi.set(__self__, "cache_enabled", cache_enabled)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if config_section is not None:
            pulumi.set(__self__, "config_section", config_section)
        if edgerc is not None:
            pulumi.set(__self__, "edgerc", edgerc)
        if request_limit is not None:
            pulumi.set(__self__, "request_limit", request_limit)

    @property
    @pulumi.getter(name="cacheEnabled")
    def cache_enabled(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "cache_enabled")

    @cache_enabled.setter
    def cache_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cache_enabled", value)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input['ProviderConfigArgs']]:
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input['ProviderConfigArgs']]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter(name="configSection")
    def config_section(self) -> Optional[pulumi.Input[str]]:
        """
        The section of the edgerc file to use for configuration
        """
        return pulumi.get(self, "config_section")

    @config_section.setter
    def config_section(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config_section", value)

    @property
    @pulumi.getter
    def edgerc(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "edgerc")

    @edgerc.setter
    def edgerc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "edgerc", value)

    @property
    @pulumi.getter(name="requestLimit")
    def request_limit(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of API requests to be made per second (0 for no limit)
        """
        return pulumi.get(self, "request_limit")

    @request_limit.setter
    def request_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "request_limit", value)


class Provider(pulumi.ProviderResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cache_enabled: Optional[pulumi.Input[bool]] = None,
                 config: Optional[pulumi.Input[pulumi.InputType['ProviderConfigArgs']]] = None,
                 config_section: Optional[pulumi.Input[str]] = None,
                 edgerc: Optional[pulumi.Input[str]] = None,
                 request_limit: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        The provider type for the akamai package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] config_section: The section of the edgerc file to use for configuration
        :param pulumi.Input[int] request_limit: The maximum number of API requests to be made per second (0 for no limit)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProviderArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The provider type for the akamai package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param ProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cache_enabled: Optional[pulumi.Input[bool]] = None,
                 config: Optional[pulumi.Input[pulumi.InputType['ProviderConfigArgs']]] = None,
                 config_section: Optional[pulumi.Input[str]] = None,
                 edgerc: Optional[pulumi.Input[str]] = None,
                 request_limit: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProviderArgs.__new__(ProviderArgs)

            __props__.__dict__["cache_enabled"] = pulumi.Output.from_input(cache_enabled).apply(pulumi.runtime.to_json) if cache_enabled is not None else None
            __props__.__dict__["config"] = pulumi.Output.from_input(config).apply(pulumi.runtime.to_json) if config is not None else None
            __props__.__dict__["config_section"] = config_section
            __props__.__dict__["edgerc"] = edgerc
            __props__.__dict__["request_limit"] = pulumi.Output.from_input(request_limit).apply(pulumi.runtime.to_json) if request_limit is not None else None
        super(Provider, __self__).__init__(
            'akamai',
            resource_name,
            __props__,
            opts)

    @property
    @pulumi.getter(name="configSection")
    def config_section(self) -> pulumi.Output[Optional[str]]:
        """
        The section of the edgerc file to use for configuration
        """
        return pulumi.get(self, "config_section")

    @property
    @pulumi.getter
    def edgerc(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "edgerc")

