
import msal

from connectron.Authenticator.Base import Authenticator


class Authenticator_MicrosoftDataverse(Authenticator):
  def __init__(self,client_id,client_secret,tenant_id,resource_url):
    super().__init__(client_id,client_secret)
    self.tenant_id = tenant_id
    self.resource_url = resource_url
    self.token = self.__get_access_token()

  def __get_access_token(self):
    app = msal.ConfidentialClientApplication(self.client_id,authority=f"https://login.microsoftonline.com/{self.tenant_id}",client_credential=self.client_secret)
    result = app.acquire_token_for_client(scopes=[f"{self.resource_url}/.default"])
    return result["access_token"]