
import requests
import pandas as pd

from connectron.Authenticator.MicrosoftAuthenticator import Authenticator_MicrosoftDataverse
from connectron.Source.Base import Source

class Source_MicrosoftDataverse(Authenticator_MicrosoftDataverse,Source):
  def __init__(self,client_id,client_secret,tenant_id,resource_url,pagination=-1):
    Source.__init__(self,pagination=5000  if pagination  ==  -1 else  pagination)
    Authenticator_MicrosoftDataverse.__init__(self,client_id,client_secret,tenant_id,resource_url)

    #self.table_name = table_name

    self.headers = {
      "Authorization":f"Bearer {self.token}",
      "OData-MaxVersion":"4.0",
      "OData-Version":"4.0",
      "Accept":"application/json",
      "Prefer": "odata.maxpagesize=" + str(self.pagination),
      "Content-Type": "application/json; charset=utf-8",
      "Cache-Control": "no-cache"
    }

    


  def __datanormalize__(self, df):
    for col in df.columns:
      if df[col].dtype == "object":
        df[col] = pd.to_datetime(df[col], errors="ignore")
    return df

  def data_sample(self,table_name,select=None, filter=None, top=100):

    url = f"{self.resource_url}/api/data/v9.2/{table_name}"

    if select is None:
      select = "*"
    if filter is None:
      filter = ""
    else:
      filter = f"?$filter={filter}"

    api_url =  url+f"{filter}?$select={select}&$top={top}" if  "?"  not in  filter  else url  +  f"{filter}&$select={select}&$top={top}"

    records = []

    response = requests.get(api_url,headers=self.headers)
    response.raise_for_status()
    data = response.json()
    records.extend(data.get("value", []))

    df = pd.DataFrame(records)

    return self.__datanormalize__(df)

  def data_extract(self,table_name,select=None, filter=None, top=5000):

    url = f"{self.resource_url}/api/data/v9.2/{table_name}"

    if select is None:
      select = "*"
    if filter is None:
      filter = ""
    else:
      filter = f"?$filter={filter}"

    api_url =  url+f"{filter}?$select={select}&$top={top}" if  "?"  not in  filter  else url  +  f"{filter}&$select={select}&$top={top}"

    records = []

    while api_url:
      response = requests.get(api_url,headers=self.headers)
      response.raise_for_status()
      data = response.json()
      records.extend(data.get("value", []))
      api_url = data.get("@odata.nextLink")

    df = pd.DataFrame(records)

    return self.__datanormalize__(df)


