# Security Policy

## Reporting a Vulnerability

We at [Mozilla AI](https://www.mozilla.ai/) take the security of our projects seriously. We appreciate your efforts to responsibly disclose security vulnerabilities.

This document outlines the process for reporting vulnerabilities in `mcpd-sdk-python`.

### Supported Versions

The following versions are currently supported for security updates:

| Version | Supported          |
|---------|--------------------|
| 0.0.x   | :white_check_mark: |

**Please ensure you are using a supported version when reporting a vulnerability.**

## Reporting a Vulnerability

**Please DO NOT open a public GitHub issue.**

To report a security vulnerability, please send a detailed email to: [security@mozilla.ai](mailto:security@mozilla.ai)

Please include the following information in your report:

1.  **Project Name and Version:** Specify which project (`mozilla-ai/mcpd-sdk-python`) and which version(s) are affected.
2.  **Vulnerability Description:** A clear and concise description of the vulnerability.
3.  **Steps to Reproduce:** Detailed steps to reproduce the vulnerability, including any necessary code, configuration, or environment details.
4.  **Impact:** Describe the potential impact of the vulnerability (e.g., data breach, denial of service, privilege escalation).
5.  **Proof of Concept (Optional but Recommended):** Any proof-of-concept code or demonstration that helps us understand and verify the vulnerability. If you have this in a repository please ensure it is private, we can privately discuss granting access to specific Mozilla AI employees for review.
6.  **Your Contact Information (Optional):** If you wish to be credited for your discovery, please provide your name/handle and preferred contact method.

### Our Commitment

* We will acknowledge receipt of your report within 2 business days.
* We will investigate the report promptly and provide an initial assessment within 5 business days.
* We will keep you informed of our progress throughout the vulnerability resolution process.
* Once the vulnerability is patched, we will notify you and, with your permission, include your name in our release notes or security advisory as a thank you for your responsible disclosure.
* We follow a 'coordinated disclosure' approach, meaning we aim to have a fix available before public disclosure.

### Public Disclosure

Please allow us a reasonable amount of time to address the vulnerability before public disclosure. We request that you do not disclose the vulnerability publicly until we have confirmed a fix is available and have agreed on a disclosure timeline.

Our typical disclosure timeline for critical issues is up to 30 days from the initial report, but this may vary depending on complexity.

### Scope

This security policy applies to all components of [mcpd](https://github.com/mozilla-ai/mcpd) (for example, this repository: [mcpd-sdk-python](https://github.com/mozilla-ai/mcpd-sdk-python)).

Thank you for helping us keep our projects secure for everyone.
