# Generated by Django 4.2.18 on 2025-02-03 12:06

from django.db import migrations, models
import uuid


def create_installation_id(apps, schema_editor):
    Installation = apps.get_model("phonehome", "Installation")
    Installation.objects.create()  # id is implied (it's a uuid)


class Migration(migrations.Migration):

    replaces = [
        ('phonehome', '0001_initial'),
        ('phonehome', '0002_create_installation_id'),
        ('phonehome', '0003_outboundmessage'),
        ('phonehome', '0004_installation_created_at'),
        ('phonehome', '0005_installation_silence_email_system_warning'),
    ]

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="Installation",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("silence_email_system_warning", models.BooleanField(default=False)),
            ],
        ),
        migrations.RunPython(create_installation_id),
        migrations.CreateModel(
            name="OutboundMessage",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("attempted_at", models.DateTimeField(auto_now_add=True)),
                ("sent_at", models.DateTimeField(null=True)),
                ("message", models.TextField()),
            ],
        ),
    ]
