# Generated by Django 4.2.18 on 2025-02-03 12:06

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    replaces = [
        ('teams', '0001_initial'),
        ('teams', '0002_initial'),
        ('teams', '0003_alter_team_visibility'),
        ('teams', '0004_remove_team_slug'),
    ]

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),  # Defines AUTH_USER_MODEL, which we use
    ]

    operations = [
        migrations.CreateModel(
            name="Team",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("name", models.CharField(max_length=255, unique=True)),
                (
                    "visibility",
                    models.IntegerField(
                        choices=[(1, "Joinable"), (10, "Discoverable"), (99, "Hidden")],
                        default=10,
                        help_text="Which users can see this team and its issues?",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="TeamMembership",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "send_email_alerts",
                    models.BooleanField(blank=True, default=None, null=True),
                ),
                (
                    "role",
                    models.IntegerField(
                        choices=[(0, "Member"), (1, "Admin")], default=0
                    ),
                ),
                ("accepted", models.BooleanField(default=False)),
                (
                    "team",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="teams.team"
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "unique_together": {("team", "user")},
            },
        ),
    ]
